/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.datasketches.theta.CompactSketch;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ThetaSketchEstimate$;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenFallback;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.ThetaSketchUtils$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(expr) - Returns the estimated number of unique values\n    given the binary representation of a Datasketches ThetaSketch. ", examples="\n    Examples:\n      > SELECT _FUNC_(theta_sketch_agg(col)) FROM VALUES (1), (1), (2), (2), (3) tab(col);\n       3\n  ", group="misc_funcs", since="4.1.0")
@ScalaSignature(bytes="\u0006\u0005\u0005uf\u0001\u0002\u000e\u001c\u0001\"B\u0001\u0002\u0013\u0001\u0003\u0016\u0004%\t!\u0013\u0005\t\u001b\u0002\u0011\t\u0012)A\u0005\u0015\")a\n\u0001C\u0001\u001f\")!\u000b\u0001C!'\")q\u000b\u0001C)1\")1\f\u0001C!9\")Q\r\u0001C!M\")\u0001\u000f\u0001C!c\")Q\u000f\u0001C!m\"9A\u0010AA\u0001\n\u0003i\b\u0002C@\u0001#\u0003%\t!!\u0001\t\u0013\u0005]\u0001!!A\u0005B\u0005e\u0001\"CA\u0015\u0001\u0005\u0005I\u0011AA\u0016\u0011%\t\u0019\u0004AA\u0001\n\u0003\t)\u0004C\u0005\u0002<\u0001\t\t\u0011\"\u0011\u0002>!I\u00111\n\u0001\u0002\u0002\u0013\u0005\u0011Q\n\u0005\n\u0003#\u0002\u0011\u0011!C!\u0003'B\u0011\"a\u0016\u0001\u0003\u0003%\t%!\u0017\b\u0013\u0005u4$!A\t\u0002\u0005}d\u0001\u0003\u000e\u001c\u0003\u0003E\t!!!\t\r9#B\u0011AAM\u0011%\tY\nFA\u0001\n\u000b\ni\nC\u0005\u0002 R\t\t\u0011\"!\u0002\"\"I\u0011Q\u0015\u000b\u0002\u0002\u0013\u0005\u0015q\u0015\u0005\n\u0003g#\u0012\u0011!C\u0005\u0003k\u00131\u0003\u00165fi\u0006\u001c6.\u001a;dQ\u0016\u001bH/[7bi\u0016T!\u0001H\u000f\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003=}\t\u0001bY1uC2L8\u000f\u001e\u0006\u0003A\u0005\n1a]9m\u0015\t\u00113%A\u0003ta\u0006\u00148N\u0003\u0002%K\u00051\u0011\r]1dQ\u0016T\u0011AJ\u0001\u0004_J<7\u0001A\n\u0007\u0001%j3G\u000e\u001f\u0011\u0005)ZS\"A\u000e\n\u00051Z\"aD+oCJLX\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u00059\nT\"A\u0018\u000b\u0005AZ\u0012aB2pI\u0016<WM\\\u0005\u0003e=\u0012qbQ8eK\u001e,gNR1mY\n\f7m\u001b\t\u0003UQJ!!N\u000e\u0003#\u0015C\b/Z2ug&s\u0007/\u001e;UsB,7\u000f\u0005\u00028u5\t\u0001HC\u0001:\u0003\u0015\u00198-\u00197b\u0013\tY\u0004HA\u0004Qe>$Wo\u0019;\u0011\u0005u*eB\u0001 D\u001d\ty$)D\u0001A\u0015\t\tu%\u0001\u0004=e>|GOP\u0005\u0002s%\u0011A\tO\u0001\ba\u0006\u001c7.Y4f\u0013\t1uI\u0001\u0007TKJL\u0017\r\\5{C\ndWM\u0003\u0002Eq\u0005)1\r[5mIV\t!\n\u0005\u0002+\u0017&\u0011Aj\u0007\u0002\u000b\u000bb\u0004(/Z:tS>t\u0017AB2iS2$\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0003!F\u0003\"A\u000b\u0001\t\u000b!\u001b\u0001\u0019\u0001&\u0002\u001d9,H\u000e\\%oi>dWM]1oiV\tA\u000b\u0005\u00028+&\u0011a\u000b\u000f\u0002\b\u0005>|G.Z1o\u0003Q9\u0018\u000e\u001e5OK^\u001c\u0005.\u001b7e\u0013:$XM\u001d8bYR\u0011\u0001+\u0017\u0005\u00065\u0016\u0001\rAS\u0001\t]\u0016<8\t[5mI\u0006Q\u0001O]3uift\u0015-\\3\u0016\u0003u\u0003\"A\u00182\u000f\u0005}\u0003\u0007CA 9\u0013\t\t\u0007(\u0001\u0004Qe\u0016$WMZ\u0005\u0003G\u0012\u0014aa\u0015;sS:<'BA19\u0003)Ig\u000e];u)f\u0004Xm]\u000b\u0002OB\u0019Q\b\u001b6\n\u0005%<%aA*fcB\u00111N\\\u0007\u0002Y*\u0011QnH\u0001\u0006if\u0004Xm]\u0005\u0003_2\u0014\u0001#\u00112tiJ\f7\r\u001e#bi\u0006$\u0016\u0010]3\u0002\u0011\u0011\fG/\u0019+za\u0016,\u0012A\u001d\t\u0003WNL!\u0001\u001e7\u0003\u0011\u0011\u000bG/\u0019+za\u0016\fAB\\;mYN\u000bg-Z#wC2$\"a\u001e>\u0011\u0005]B\u0018BA=9\u0005\r\te.\u001f\u0005\u0006w&\u0001\ra^\u0001\u0006S:\u0004X\u000f^\u0001\u0005G>\u0004\u0018\u0010\u0006\u0002Q}\"9\u0001J\u0003I\u0001\u0002\u0004Q\u0015AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003\u0007Q3ASA\u0003W\t\t9\u0001\u0005\u0003\u0002\n\u0005MQBAA\u0006\u0015\u0011\ti!a\u0004\u0002\u0013Ut7\r[3dW\u0016$'bAA\tq\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005U\u00111\u0002\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002\u001cA!\u0011QDA\u0014\u001b\t\tyB\u0003\u0003\u0002\"\u0005\r\u0012\u0001\u00027b]\u001eT!!!\n\u0002\t)\fg/Y\u0005\u0004G\u0006}\u0011\u0001\u00049s_\u0012,8\r^!sSRLXCAA\u0017!\r9\u0014qF\u0005\u0004\u0003cA$aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$HcA<\u00028!I\u0011\u0011\b\b\u0002\u0002\u0003\u0007\u0011QF\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005}\u0002#BA!\u0003\u000f:XBAA\"\u0015\r\t)\u0005O\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA%\u0003\u0007\u0012\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR\u0019A+a\u0014\t\u0011\u0005e\u0002#!AA\u0002]\f!\u0003\u001d:pIV\u001cG/\u00127f[\u0016tGOT1nKR!\u00111DA+\u0011%\tI$EA\u0001\u0002\u0004\ti#\u0001\u0004fcV\fGn\u001d\u000b\u0004)\u0006m\u0003\u0002CA\u001d%\u0005\u0005\t\u0019A<)'\u0001\ty&!\u001a\u0002h\u0005-\u0014QNA9\u0003g\n9(!\u001f\u0011\u0007)\n\t'C\u0002\u0002dm\u0011Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0002j\u0005\tYA\u0003\u0011!A\u0001zf)\u0016(D?\"*\u0007\u0010\u001d:*A5\u0002#+\u001a;ve:\u001c\b\u0005\u001e5fA\u0015\u001cH/[7bi\u0016$\u0007E\\;nE\u0016\u0014\be\u001c4!k:L\u0017/^3!m\u0006dW/Z:\u000bA\u0001\u0002\u0003eZ5wK:\u0004C\u000f[3!E&t\u0017M]=!e\u0016\u0004(/Z:f]R\fG/[8oA=4\u0007%\u0019\u0011ECR\f7o[3uG\",7\u000f\t+iKR\f7k[3uG\"t\u0003%\u0001\u0005fq\u0006l\u0007\u000f\\3tC\t\ty'A;\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`QQDW\r^1`g.,Go\u00195`C\u001e<\u0007fY8mS%\u0002cIU(NAY\u000bE*V#TA!\n\u0014\u0006\f\u0011)c%b\u0003\u0005\u000b\u001a*Y\u0001B#'\u000b\u0017!QMJ\u0003\u0005^1cQ\r|G.K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!g)\u0001\u0003%A\u0003he>,\b/\t\u0002\u0002v\u0005QQ.[:d?\u001a,hnY:\u0002\u000bMLgnY3\"\u0005\u0005m\u0014!\u0002\u001b/c9\u0002\u0014a\u0005+iKR\f7k[3uG\",5\u000f^5nCR,\u0007C\u0001\u0016\u0015'\u0015!\u00121QAH!\u0019\t))a#K!6\u0011\u0011q\u0011\u0006\u0004\u0003\u0013C\u0014a\u0002:v]RLW.Z\u0005\u0005\u0003\u001b\u000b9IA\tBEN$(/Y2u\rVt7\r^5p]F\u0002B!!%\u0002\u00186\u0011\u00111\u0013\u0006\u0005\u0003+\u000b\u0019#\u0001\u0002j_&\u0019a)a%\u0015\u0005\u0005}\u0014\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005m\u0011!B1qa2LHc\u0001)\u0002$\")\u0001j\u0006a\u0001\u0015\u00069QO\\1qa2LH\u0003BAU\u0003_\u0003BaNAV\u0015&\u0019\u0011Q\u0016\u001d\u0003\r=\u0003H/[8o\u0011!\t\t\fGA\u0001\u0002\u0004\u0001\u0016a\u0001=%a\u0005aqO]5uKJ+\u0007\u000f\\1dKR\u0011\u0011q\u0017\t\u0005\u0003;\tI,\u0003\u0003\u0002<\u0006}!AB(cU\u0016\u001cG\u000f")
public class ThetaSketchEstimate
extends UnaryExpression
implements CodegenFallback,
ExpectsInputTypes,
Serializable {
    private final Expression child;

    public static Option<Expression> unapply(ThetaSketchEstimate x$0) {
        return ThetaSketchEstimate$.MODULE$.unapply(x$0);
    }

    public static <A> Function1<Expression, A> andThen(Function1<ThetaSketchEstimate, A> g) {
        return ThetaSketchEstimate$.MODULE$.andThen(g);
    }

    public static <A$> Function1<A$, ThetaSketchEstimate> compose(Function1<A$, Expression> g) {
        return ThetaSketchEstimate$.MODULE$.compose(g);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return CodegenFallback.doGenCode$(this, ctx, ev);
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public boolean nullIntolerant() {
        return true;
    }

    @Override
    public ThetaSketchEstimate withNewChildInternal(Expression newChild) {
        return this.copy(newChild);
    }

    @Override
    public String prettyName() {
        return "theta_sketch_estimate";
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)BinaryType$.MODULE$, (List)Nil$.MODULE$);
    }

    @Override
    public DataType dataType() {
        return LongType$.MODULE$;
    }

    @Override
    public Object nullSafeEval(Object input) {
        byte[] buffer = (byte[])input;
        CompactSketch sketch = ThetaSketchUtils$.MODULE$.wrapCompactSketch(buffer, this.prettyName());
        return BoxesRunTime.boxToLong((long)Math.round(sketch.getEstimate()));
    }

    public ThetaSketchEstimate copy(Expression child) {
        return new ThetaSketchEstimate(child);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    @Override
    public String productPrefix() {
        return "ThetaSketchEstimate";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.child();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ThetaSketchEstimate;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "child";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ThetaSketchEstimate)) return false;
        boolean bl = true;
        if (!bl) return false;
        ThetaSketchEstimate thetaSketchEstimate = (ThetaSketchEstimate)x$1;
        Expression expression = this.child();
        Expression expression2 = thetaSketchEstimate.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!thetaSketchEstimate.canEqual(this)) return false;
        return true;
    }

    public ThetaSketchEstimate(Expression child) {
        this.child = child;
        CodegenFallback.$init$(this);
        ExpectsInputTypes.$init$(this);
    }
}

