/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.sql.dictionary;

import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptorList;
import org.apache.derby.iapi.sql.dictionary.ConsInfo;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptorList;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.ForeignKeyConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.ReferencedKeyConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.i18n.MessageService;

public class DDUtils {
    public static ReferencedKeyConstraintDescriptor locateReferencedConstraint(DataDictionary dataDictionary, TableDescriptor tableDescriptor, String string, String[] stringArray, ConsInfo consInfo) throws StandardException {
        TableDescriptor tableDescriptor2 = consInfo.getReferencedTableDescriptor(dataDictionary);
        if (tableDescriptor2 == null) {
            throw StandardException.newException((String)"X0Y46.S", (Object[])new Object[]{string, consInfo.getReferencedTableName()});
        }
        String[] stringArray2 = consInfo.getReferencedColumnNames();
        if (stringArray2 == null || stringArray2.length == 0) {
            ReferencedKeyConstraintDescriptor referencedKeyConstraintDescriptor = tableDescriptor2.getPrimaryKey();
            if (referencedKeyConstraintDescriptor == null) {
                throw StandardException.newException((String)"X0Y41.S", (Object[])new Object[]{string, tableDescriptor2.getQualifiedName()});
            }
            ColumnDescriptorList columnDescriptorList = DDUtils.getColumnDescriptors(dataDictionary, tableDescriptor, stringArray);
            if (columnDescriptorList.size() != referencedKeyConstraintDescriptor.getColumnDescriptors().size()) {
                throw StandardException.newException((String)"X0Y43.S", (Object[])new Object[]{string, String.valueOf(columnDescriptorList.size()), String.valueOf(referencedKeyConstraintDescriptor.getColumnDescriptors().size())});
            }
            if (!referencedKeyConstraintDescriptor.areColumnsComparable(columnDescriptorList)) {
                throw StandardException.newException((String)"X0Y42.S", (Object[])new Object[]{string});
            }
            return referencedKeyConstraintDescriptor;
        }
        ColumnDescriptorList columnDescriptorList = DDUtils.getColumnDescriptors(dataDictionary, tableDescriptor, stringArray);
        ConstraintDescriptorList constraintDescriptorList = dataDictionary.getConstraintDescriptors(tableDescriptor2);
        int n = constraintDescriptorList.size();
        for (int i = 0; i < n; ++i) {
            int n2;
            ConstraintDescriptor constraintDescriptor = constraintDescriptorList.elementAt(i);
            if (!(constraintDescriptor instanceof ReferencedKeyConstraintDescriptor) || !constraintDescriptor.areColumnsComparable(columnDescriptorList) || !DDUtils.columnNamesMatch(stringArray2, constraintDescriptor.getColumnDescriptors())) continue;
            if (constraintDescriptor.deferrable() && ((n2 = consInfo.getReferentialActionDeleteRule()) == 0 || n2 == 3)) {
                throw StandardException.newException((String)"X0Y47.S", (Object[])new Object[]{string, tableDescriptor2.getQualifiedName()});
            }
            return (ReferencedKeyConstraintDescriptor)constraintDescriptor;
        }
        throw StandardException.newException((String)"X0Y44.S", (Object[])new Object[]{string, tableDescriptor2.getQualifiedName()});
    }

    public static ColumnDescriptorList getColumnDescriptors(DataDictionary dataDictionary, TableDescriptor tableDescriptor, String[] stringArray) throws StandardException {
        ColumnDescriptorList columnDescriptorList = new ColumnDescriptorList();
        for (int i = 0; i < stringArray.length; ++i) {
            ColumnDescriptor columnDescriptor = tableDescriptor.getColumnDescriptor(stringArray[i]);
            columnDescriptorList.add(tableDescriptor.getUUID(), columnDescriptor);
        }
        return columnDescriptorList;
    }

    public static boolean columnNamesMatch(String[] stringArray, ColumnDescriptorList columnDescriptorList) throws StandardException {
        if (stringArray.length != columnDescriptorList.size()) {
            return false;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string = columnDescriptorList.elementAt(i).getColumnName();
            if (string.equals(stringArray[i])) continue;
            return false;
        }
        return true;
    }

    public static void validateReferentialActions(DataDictionary dataDictionary, TableDescriptor tableDescriptor, String string, ConsInfo consInfo, String[] stringArray) throws StandardException {
        int n = consInfo.getReferentialActionDeleteRule();
        if (n == 3) {
            boolean bl = false;
            for (int i = 0; i < stringArray.length; ++i) {
                ColumnDescriptor columnDescriptor = tableDescriptor.getColumnDescriptor(stringArray[i]);
                if (!columnDescriptor.getType().isNullable()) continue;
                bl = true;
                break;
            }
            if (!bl) {
                throw StandardException.newException((String)"42834", (Object[])new Object[]{string});
            }
        }
        TableDescriptor tableDescriptor2 = consInfo.getReferencedTableDescriptor(dataDictionary);
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
        boolean bl = tableDescriptor2.getUUID().equals(tableDescriptor.getUUID());
        String string2 = tableDescriptor2.getSchemaName() + "." + tableDescriptor2.getName();
        int n2 = DDUtils.getCurrentDeleteConnections(dataDictionary, tableDescriptor, -1, hashtable, false, true);
        DDUtils.validateDeleteConnection(dataDictionary, tableDescriptor, tableDescriptor2, n, hashtable, new Hashtable<String, Integer>(hashtable), true, string, false, new StringBuffer(0), string2, bl, n2);
        if (!bl) {
            DDUtils.checkForAnyExistingDeleteConnectionViolations(dataDictionary, tableDescriptor, n, hashtable, string);
        }
    }

    private static int getCurrentDeleteConnections(DataDictionary dataDictionary, TableDescriptor tableDescriptor, int n, Hashtable<String, Integer> hashtable, boolean bl, boolean bl2) throws StandardException {
        int n2 = -1;
        tableDescriptor.emptyConstraintDescriptorList();
        ConstraintDescriptorList constraintDescriptorList = dataDictionary.getConstraintDescriptors(tableDescriptor);
        int n3 = constraintDescriptorList.size();
        boolean bl3 = bl;
        for (int i = 0; i < n3; ++i) {
            ConstraintDescriptor constraintDescriptor = constraintDescriptorList.elementAt(i);
            if (!(constraintDescriptor instanceof ForeignKeyConstraintDescriptor)) continue;
            ForeignKeyConstraintDescriptor foreignKeyConstraintDescriptor = (ForeignKeyConstraintDescriptor)constraintDescriptor;
            String string = foreignKeyConstraintDescriptor.getConstraintName();
            int n4 = foreignKeyConstraintDescriptor.getRaDeleteRule();
            int n5 = foreignKeyConstraintDescriptor.getRaUpdateRule();
            if (bl2 && foreignKeyConstraintDescriptor.isSelfReferencingFK()) {
                n2 = n4;
                bl2 = false;
            }
            ReferencedKeyConstraintDescriptor referencedKeyConstraintDescriptor = foreignKeyConstraintDescriptor.getReferencedConstraint();
            TableDescriptor tableDescriptor2 = referencedKeyConstraintDescriptor.getTableDescriptor();
            int n6 = n == -1 ? n4 : n;
            String string2 = tableDescriptor2.getSchemaName() + "." + tableDescriptor2.getName();
            Integer n7 = hashtable.get(string2);
            if (n7 != null) {
                bl = bl3;
                continue;
            }
            if (n4 != 0) {
                if (bl) {
                    bl = bl3;
                    continue;
                }
                bl = true;
            }
            hashtable.put(string2, n6);
            if (!foreignKeyConstraintDescriptor.isSelfReferencingFK()) {
                DDUtils.getCurrentDeleteConnections(dataDictionary, tableDescriptor2, n6, hashtable, true, false);
            }
            bl = bl3;
        }
        return n2;
    }

    private static void validateDeleteConnection(DataDictionary dataDictionary, TableDescriptor tableDescriptor, TableDescriptor tableDescriptor2, int n, Hashtable<String, Integer> hashtable, Hashtable<String, Integer> hashtable2, boolean bl, String string, boolean bl2, StringBuffer stringBuffer, String string2, boolean bl3, int n2) throws StandardException {
        Integer n3;
        if (bl) {
            String string3 = tableDescriptor2.getSchemaName() + "." + tableDescriptor2.getName();
            n3 = hashtable.get(string3);
            if (bl3) {
                if (n2 != -1) {
                    if (n2 != n) {
                        if (n2 == 3) {
                            throw DDUtils.generateError("XCL33.S", string, string2);
                        }
                        throw DDUtils.generateError("XCL36.S", string, n2);
                    }
                    if (n2 == 3 && n == 3) {
                        throw DDUtils.generateError("XCL33.S", string, string2);
                    }
                }
                if (bl3 && hashtable.contains(0) && n != 0) {
                    throw DDUtils.generateError("XCL37.S", string, 0);
                }
                return;
            }
            if (n2 != -1 && n == 0 && n2 != 0) {
                throw DDUtils.generateError("XCL39.S", string);
            }
            if (n3 != null) {
                DDUtils.checkForMultiplePathInvalidCases(n3, n, string, string2);
            }
            if (n != 0) {
                bl2 = true;
            }
            stringBuffer.append(n);
        }
        boolean bl4 = bl2;
        boolean bl5 = true;
        ConstraintDescriptorList constraintDescriptorList = dataDictionary.getConstraintDescriptors(tableDescriptor2);
        int n4 = constraintDescriptorList.size();
        for (int i = 0; i < n4; ++i) {
            String string4;
            ConstraintDescriptor constraintDescriptor = constraintDescriptorList.elementAt(i);
            if (!(constraintDescriptor instanceof ForeignKeyConstraintDescriptor)) continue;
            ForeignKeyConstraintDescriptor foreignKeyConstraintDescriptor = (ForeignKeyConstraintDescriptor)constraintDescriptor;
            String string5 = foreignKeyConstraintDescriptor.getConstraintName();
            int n5 = foreignKeyConstraintDescriptor.getRaDeleteRule();
            int n6 = foreignKeyConstraintDescriptor.getRaUpdateRule();
            ReferencedKeyConstraintDescriptor referencedKeyConstraintDescriptor = foreignKeyConstraintDescriptor.getReferencedConstraint();
            TableDescriptor tableDescriptor3 = referencedKeyConstraintDescriptor.getTableDescriptor();
            if (n5 != 0) {
                if (bl2) {
                    bl2 = bl4;
                    continue;
                }
                bl2 = true;
                bl5 = false;
            }
            boolean bl6 = foreignKeyConstraintDescriptor.isSelfReferencingFK();
            stringBuffer.append(n5);
            boolean bl7 = tableDescriptor3.getUUID().equals(tableDescriptor.getUUID());
            if (bl7) {
                for (int j = 0; j < stringBuffer.length(); ++j) {
                    int n7 = Character.getNumericValue(stringBuffer.charAt(j));
                    if (n7 == n) continue;
                    if (n7 != 0) {
                        throw DDUtils.generateError("XCL40.S", string);
                    }
                    throw DDUtils.generateError("XCL34.S", string, string2);
                }
            }
            if ((n3 = hashtable2.get(string4 = tableDescriptor3.getSchemaName() + "." + tableDescriptor3.getName())) != null) {
                if (!bl6 && bl5) {
                    DDUtils.checkForMultiplePathInvalidCases(n3, n, string, string2);
                }
            } else {
                n3 = hashtable.get(string4);
                if (n3 == null) {
                    if (bl5) {
                        hashtable.put(string4, n);
                    }
                    if (!bl6) {
                        DDUtils.validateDeleteConnection(dataDictionary, tableDescriptor, tableDescriptor3, n, hashtable, hashtable2, false, string, bl2, stringBuffer, string2, bl3, n2);
                    }
                }
            }
            bl2 = bl4;
            stringBuffer.setLength(stringBuffer.length() - 1);
        }
    }

    private static void checkForMultiplePathInvalidCases(int n, int n2, String string, String string2) throws StandardException {
        if (n != n2) {
            if (n == 3) {
                throw DDUtils.generateError("XCL35.S", string, string2);
            }
            throw DDUtils.generateError("XCL38.S", string, n);
        }
        if (n == 3 && n2 == 3) {
            throw DDUtils.generateError("XCL35.S", string, string2);
        }
    }

    private static void checkForAnyExistingDeleteConnectionViolations(DataDictionary dataDictionary, TableDescriptor tableDescriptor, int n, Hashtable<String, Integer> hashtable, String string) throws StandardException {
        if (n != 0) {
            return;
        }
        String string2 = tableDescriptor.getSchemaName() + "." + tableDescriptor.getName();
        for (ConstraintDescriptor constraintDescriptor : dataDictionary.getConstraintDescriptors(tableDescriptor)) {
            ConstraintDescriptorList constraintDescriptorList;
            int n2;
            if (!(constraintDescriptor instanceof ReferencedKeyConstraintDescriptor) || (n2 = (constraintDescriptorList = dataDictionary.getActiveConstraintDescriptors(((ReferencedKeyConstraintDescriptor)constraintDescriptor).getForeignKeyConstraints(3))).size()) == 0) continue;
            Hashtable<String, Integer> hashtable2 = new Hashtable<String, Integer>();
            for (int i = 0; i < n2; ++i) {
                ForeignKeyConstraintDescriptor foreignKeyConstraintDescriptor = (ForeignKeyConstraintDescriptor)constraintDescriptorList.elementAt(i);
                TableDescriptor tableDescriptor2 = foreignKeyConstraintDescriptor.getTableDescriptor();
                int n3 = foreignKeyConstraintDescriptor.getRaDeleteRule();
                if (!foreignKeyConstraintDescriptor.isSelfReferencingFK()) {
                    DDUtils.getCurrentDeleteConnections(dataDictionary, tableDescriptor2, -1, hashtable2, false, true);
                    Enumeration<String> enumeration = hashtable2.keys();
                    while (enumeration.hasMoreElements()) {
                        int n4;
                        String string3 = enumeration.nextElement();
                        if (string3.equals(string2) || !hashtable.containsKey(string3) || ((n4 = hashtable2.get(string3).intValue()) != 3 || n3 != 3) && n4 == n3) continue;
                        throw DDUtils.generateError("XCL41.S", string);
                    }
                }
                hashtable2.clear();
            }
        }
    }

    private static StandardException generateError(String string, String string2) {
        String string3 = MessageService.getTextMessage((String)string, (Object[])new Object[0]);
        return StandardException.newException((String)"42915", (Object[])new Object[]{string2, string3});
    }

    private static StandardException generateError(String string, String string2, int n) {
        String string3 = MessageService.getTextMessage((String)(switch (n) {
            case 0 -> "CASCADE";
            case 1 -> "RESTRICT";
            case 3 -> "SET NULL";
            case 4 -> "SET DEFAULT";
            default -> "NO ACTION";
        }), (Object[])new Object[0]);
        String string4 = MessageService.getTextMessage((String)string, (Object[])new Object[]{string3});
        return StandardException.newException((String)"42915", (Object[])new Object[]{string2, string4});
    }

    private static StandardException generateError(String string, String string2, String string3) {
        String string4 = MessageService.getTextMessage((String)string, (Object[])new Object[]{string3});
        return StandardException.newException((String)"42915", (Object[])new Object[]{string2, string4});
    }
}

