/*
 * Decompiled with CFR 0.152.
 */
package coursierapi.shaded.lang3;

import coursierapi.shaded.lang3.StringUtils;
import coursierapi.shaded.lang3.function.Suppliers;
import java.util.function.Supplier;

public final class SystemProperties {
    public static String getOsName() {
        return SystemProperties.getProperty("os.name");
    }

    public static String getProperty(String property) {
        return SystemProperties.getProperty(property, Suppliers.nul());
    }

    static String getProperty(String property, Supplier<String> defaultValue) {
        try {
            if (StringUtils.isEmpty(property)) {
                return defaultValue.get();
            }
            String value = System.getProperty(property);
            return StringUtils.getIfEmpty(value, defaultValue);
        }
        catch (SecurityException ignore) {
            return defaultValue.get();
        }
    }
}

