/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.util;

import org.apache.spark.SparkConf;
import org.apache.spark.internal.config.Network$;
import org.apache.spark.rpc.RpcAddress$;
import org.apache.spark.rpc.RpcEndpointRef;
import org.apache.spark.rpc.RpcEnv;
import org.apache.spark.rpc.RpcTimeout;
import org.apache.spark.rpc.RpcTimeout$;
import org.apache.spark.util.Utils$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.runtime.BoxesRunTime;

public final class RpcUtils$ {
    public static final RpcUtils$ MODULE$ = new RpcUtils$();
    private static final RpcTimeout INFINITE_TIMEOUT = new RpcTimeout(new package.DurationLong(package$.MODULE$.DurationLong(Long.MAX_VALUE)).nanos(), "infinite");
    private static final int MAX_MESSAGE_SIZE_IN_MB = 2047;

    public RpcEndpointRef makeDriverRef(String name, SparkConf conf, RpcEnv rpcEnv) {
        String driverHost = conf.get(org.apache.spark.internal.config.package$.MODULE$.DRIVER_HOST_ADDRESS().key(), "localhost");
        int driverPort = conf.getInt(org.apache.spark.internal.config.package$.MODULE$.DRIVER_PORT().key(), 7077);
        Utils$.MODULE$.checkHost(driverHost);
        return rpcEnv.setupEndpointRef(RpcAddress$.MODULE$.apply(driverHost, driverPort), name);
    }

    public RpcEndpointRef makeDriverRef(String name, String driverHost, int driverPort, RpcEnv rpcEnv) {
        Utils$.MODULE$.checkHost(driverHost);
        return rpcEnv.setupEndpointRef(RpcAddress$.MODULE$.apply(driverHost, driverPort), name);
    }

    public RpcTimeout askRpcTimeout(SparkConf conf) {
        return RpcTimeout$.MODULE$.apply(conf, (Seq<String>)new .colon.colon((Object)Network$.MODULE$.RPC_ASK_TIMEOUT().key(), (List)new .colon.colon((Object)Network$.MODULE$.NETWORK_TIMEOUT().key(), (List)Nil$.MODULE$)), "120s");
    }

    public RpcTimeout lookupRpcTimeout(SparkConf conf) {
        return RpcTimeout$.MODULE$.apply(conf, (Seq<String>)new .colon.colon((Object)Network$.MODULE$.RPC_LOOKUP_TIMEOUT().key(), (List)new .colon.colon((Object)Network$.MODULE$.NETWORK_TIMEOUT().key(), (List)Nil$.MODULE$)), "120s");
    }

    public RpcTimeout INFINITE_TIMEOUT() {
        return INFINITE_TIMEOUT;
    }

    private int MAX_MESSAGE_SIZE_IN_MB() {
        return MAX_MESSAGE_SIZE_IN_MB;
    }

    public int maxMessageSizeBytes(SparkConf conf) {
        int maxSizeInMB = BoxesRunTime.unboxToInt((Object)conf.get(Network$.MODULE$.RPC_MESSAGE_MAX_SIZE()));
        if (maxSizeInMB > this.MAX_MESSAGE_SIZE_IN_MB()) {
            throw new IllegalArgumentException(Network$.MODULE$.RPC_MESSAGE_MAX_SIZE().key() + " should not be greater than " + this.MAX_MESSAGE_SIZE_IN_MB() + " MB");
        }
        return maxSizeInMB * 1024 * 1024;
    }

    private RpcUtils$() {
    }
}

