/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.st;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.RuntimeReplaceable;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.objects.StaticInvoke;
import org.apache.spark.sql.catalyst.expressions.objects.StaticInvoke$;
import org.apache.spark.sql.catalyst.expressions.st.ExpressionDefaults$;
import org.apache.spark.sql.catalyst.expressions.st.GeospatialInputTypes;
import org.apache.spark.sql.catalyst.expressions.st.ST_GeogFromWKB$;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.catalyst.trees.UnaryLike;
import org.apache.spark.sql.catalyst.util.STUtils;
import org.apache.spark.sql.connector.catalog.functions.ScalarFunction;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.GeographyType;
import org.apache.spark.sql.types.GeographyType$;
import scala.Enumeration;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(wkb) - Parses the WKB description of a geography and returns the corresponding GEOGRAPHY value.", arguments="\n    Arguments:\n      * wkb - A BINARY value in WKB format, representing a GEOGRAPHY value.\n  ", examples="\n    Examples:\n      > SELECT hex(st_asbinary(_FUNC_(X'0101000000000000000000F03F0000000000000040')));\n       0101000000000000000000F03F0000000000000040\n  ", since="4.1.0", group="st_funcs")
@ScalaSignature(bytes="\u0006\u0005\u0005Uf\u0001B\r\u001b\u0001&B\u0001\"\u0014\u0001\u0003\u0016\u0004%\tA\u0014\u0005\t\u001f\u0002\u0011\t\u0012)A\u0005U!)\u0001\u000b\u0001C\u0001#\")A\u000b\u0001C!+\"Aq\f\u0001EC\u0002\u0013\u0005c\nC\u0003a\u0001\u0011\u0005\u0013\rC\u0003k\u0001\u0011\u0005c\nC\u0003l\u0001\u0011EC\u000eC\u0004p\u0001\u0005\u0005I\u0011\u00019\t\u000fI\u0004\u0011\u0013!C\u0001g\"9a\u0010AA\u0001\n\u0003z\b\"CA\b\u0001\u0005\u0005I\u0011AA\t\u0011%\tI\u0002AA\u0001\n\u0003\tY\u0002C\u0005\u0002(\u0001\t\t\u0011\"\u0011\u0002*!I\u0011q\u0007\u0001\u0002\u0002\u0013\u0005\u0011\u0011\b\u0005\n\u0003\u0007\u0002\u0011\u0011!C!\u0003\u000bB\u0011\"!\u0013\u0001\u0003\u0003%\t%a\u0013\b\u0013\u0005U$$!A\t\u0002\u0005]d\u0001C\r\u001b\u0003\u0003E\t!!\u001f\t\rA\u001bB\u0011AAI\u0011%\t\u0019jEA\u0001\n\u000b\n)\nC\u0005\u0002\u0018N\t\t\u0011\"!\u0002\u001a\"I\u0011QT\n\u0002\u0002\u0013\u0005\u0015q\u0014\u0005\n\u0003W\u001b\u0012\u0011!C\u0005\u0003[\u0013ab\u0015+`\u000f\u0016|wM\u0012:p[^[%I\u0003\u0002\u001c9\u0005\u00111\u000f\u001e\u0006\u0003;y\t1\"\u001a=qe\u0016\u001c8/[8og*\u0011q\u0004I\u0001\tG\u0006$\u0018\r\\=ti*\u0011\u0011EI\u0001\u0004gFd'BA\u0012%\u0003\u0015\u0019\b/\u0019:l\u0015\t)c%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002O\u0005\u0019qN]4\u0004\u0001M9\u0001A\u000b\u00182km\n\u0005CA\u0016-\u001b\u0005a\u0012BA\u0017\u001d\u0005))\u0005\u0010\u001d:fgNLwN\u001c\t\u0003W=J!\u0001\r\u000f\u0003%I+h\u000e^5nKJ+\u0007\u000f\\1dK\u0006\u0014G.\u001a\t\u0003eMj\u0011AG\u0005\u0003ii\u0011AcR3pgB\fG/[1m\u0013:\u0004X\u000f\u001e+za\u0016\u001c\bc\u0001\u001c:U5\tqG\u0003\u00029=\u0005)AO]3fg&\u0011!h\u000e\u0002\n+:\f'/\u001f'jW\u0016\u0004\"\u0001P \u000e\u0003uR\u0011AP\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0001v\u0012q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002C\u0015:\u00111\t\u0013\b\u0003\t\u001ek\u0011!\u0012\u0006\u0003\r\"\na\u0001\u0010:p_Rt\u0014\"\u0001 \n\u0005%k\u0014a\u00029bG.\fw-Z\u0005\u0003\u00172\u0013AbU3sS\u0006d\u0017N_1cY\u0016T!!S\u001f\u0002\u0007]\\'-F\u0001+\u0003\u001198N\u0019\u0011\u0002\rqJg.\u001b;?)\t\u00116\u000b\u0005\u00023\u0001!)Qj\u0001a\u0001U\u0005Q\u0011N\u001c9viRK\b/Z:\u0016\u0003Y\u00032AQ,Z\u0013\tAFJA\u0002TKF\u0004\"AW/\u000e\u0003mS!\u0001\u0018\u0011\u0002\u000bQL\b/Z:\n\u0005y[&\u0001E!cgR\u0014\u0018m\u0019;ECR\fG+\u001f9f\u0003-\u0011X\r\u001d7bG\u0016lWM\u001c;\u0002\u0015A\u0014X\r\u001e;z\u001d\u0006lW-F\u0001c!\t\u0019wM\u0004\u0002eKB\u0011A)P\u0005\u0003Mv\na\u0001\u0015:fI\u00164\u0017B\u00015j\u0005\u0019\u0019FO]5oO*\u0011a-P\u0001\u0006G\"LG\u000eZ\u0001\u0015o&$\bNT3x\u0007\"LG\u000eZ%oi\u0016\u0014h.\u00197\u0015\u0005Ik\u0007\"\u00028\t\u0001\u0004Q\u0013\u0001\u00038fo\u000eC\u0017\u000e\u001c3\u0002\t\r|\u0007/\u001f\u000b\u0003%FDq!T\u0005\u0011\u0002\u0003\u0007!&\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0003QT#AK;,\u0003Y\u0004\"a\u001e?\u000e\u0003aT!!\u001f>\u0002\u0013Ut7\r[3dW\u0016$'BA>>\u0003)\tgN\\8uCRLwN\\\u0005\u0003{b\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011\u0011\u0001\t\u0005\u0003\u0007\ti!\u0004\u0002\u0002\u0006)!\u0011qAA\u0005\u0003\u0011a\u0017M\\4\u000b\u0005\u0005-\u0011\u0001\u00026bm\u0006L1\u0001[A\u0003\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\t\u0019\u0002E\u0002=\u0003+I1!a\u0006>\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\ti\"a\t\u0011\u0007q\ny\"C\u0002\u0002\"u\u00121!\u00118z\u0011%\t)#DA\u0001\u0002\u0004\t\u0019\"A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003W\u0001b!!\f\u00024\u0005uQBAA\u0018\u0015\r\t\t$P\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA\u001b\u0003_\u0011\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!\u00111HA!!\ra\u0014QH\u0005\u0004\u0003\u007fi$a\u0002\"p_2,\u0017M\u001c\u0005\n\u0003Ky\u0011\u0011!a\u0001\u0003;\t!\u0003\u001d:pIV\u001cG/\u00127f[\u0016tGOT1nKR!\u0011\u0011AA$\u0011%\t)\u0003EA\u0001\u0002\u0004\t\u0019\"\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003w\ti\u0005C\u0005\u0002&E\t\t\u00111\u0001\u0002\u001e!:\u0002!!\u0015\u0002X\u0005e\u0013QLA0\u0003G\n)'!\u001b\u0002l\u0005=\u0014\u0011\u000f\t\u0004W\u0005M\u0013bAA+9\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017EAA.\u0003\u0019|f)\u0016(D?\":8NY\u0015![\u0001\u0002\u0016M]:fg\u0002\"\b.\u001a\u0011X\u0017\n\u0003C-Z:de&\u0004H/[8oA=4\u0007%\u0019\u0011hK><'/\u00199is\u0002\ng\u000e\u001a\u0011sKR,(O\\:!i\",\u0007eY8se\u0016\u001c\bo\u001c8eS:<\u0007eR#P\u000fJ\u000b\u0005\u000bS-!m\u0006dW/\u001a\u0018\u0002\u0013\u0005\u0014x-^7f]R\u001c\u0018EAA1\u0003yS\u0001\u0005\t\u0011!\u0003J<W/\\3oiNT$\u0002\t\u0011!A\u0001\u0002#\u0006I<lE\u0002j\u0003%\u0011\u0011C\u0013:\u000b%+\u0017\u0011wC2,X\rI5oA][%\t\t4pe6\fG\u000f\f\u0011sKB\u0014Xm]3oi&tw\rI1!\u000f\u0016{uIU!Q\u0011f\u0003c/\u00197vK:R\u0001\u0005I\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012\u0011qM\u0001\u00028)\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003\u0003.\u001a=)gR|\u0016m\u001d2j]\u0006\u0014\u0018\u0010K0G+:\u001bu\f\u000b-(aE\u0002\u0014\u0007\r\u00191aA\u0002\u0004\u0007\r\u00191aA\u0002\u0004\u0007\r\u00191a\u0019\u00034G\u0012\u00191aA\u0002\u0004\u0007\r\u00191aA\u0002\u0004\u0007\r\u001b1O%J\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00111cA\n\u0004\u0007\r\u00191aA\u0002\u0004\u0007\r\u00191aA\u0002\u0004\u0007\r\u00191\rB\u001ad\t\r\u00191aA\u0002\u0004\u0007\r\u00191aA\u0002\u0004\u0007\u000e\u0019\u000bA\u0001\nQa]5oG\u0016\f#!!\u001c\u0002\u000bQr\u0013G\f\u0019\u0002\u000b\u001d\u0014x.\u001e9\"\u0005\u0005M\u0014\u0001C:u?\u001a,hnY:\u0002\u001dM#vlR3pO\u001a\u0013x.\\,L\u0005B\u0011!gE\n\u0006'\u0005m\u0014q\u0011\t\u0007\u0003{\n\u0019I\u000b*\u000e\u0005\u0005}$bAAA{\u00059!/\u001e8uS6,\u0017\u0002BAC\u0003\u007f\u0012\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c82!\u0011\tI)a$\u000e\u0005\u0005-%\u0002BAG\u0003\u0013\t!![8\n\u0007-\u000bY\t\u0006\u0002\u0002x\u0005AAo\\*ue&tw\r\u0006\u0002\u0002\u0002\u0005)\u0011\r\u001d9msR\u0019!+a'\t\u000b53\u0002\u0019\u0001\u0016\u0002\u000fUt\u0017\r\u001d9msR!\u0011\u0011UAT!\u0011a\u00141\u0015\u0016\n\u0007\u0005\u0015VH\u0001\u0004PaRLwN\u001c\u0005\t\u0003S;\u0012\u0011!a\u0001%\u0006\u0019\u0001\u0010\n\u0019\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\u0005=\u0006\u0003BA\u0002\u0003cKA!a-\u0002\u0006\t1qJ\u00196fGR\u0004")
public class ST_GeogFromWKB
extends Expression
implements RuntimeReplaceable,
GeospatialInputTypes,
UnaryLike<Expression>,
Serializable {
    private Expression replacement;
    private final Expression wkb;
    private transient Seq<Expression> children;
    private Seq<Enumeration.Value> nodePatterns;
    private Expression canonicalized;
    private volatile transient boolean bitmap$trans$0;
    private volatile byte bitmap$0;

    public static Option<Expression> unapply(ST_GeogFromWKB x$0) {
        return ST_GeogFromWKB$.MODULE$.unapply(x$0);
    }

    public static <A> Function1<Expression, A> andThen(Function1<ST_GeogFromWKB, A> g) {
        return ST_GeogFromWKB$.MODULE$.andThen(g);
    }

    public static <A$> Function1<A$, ST_GeogFromWKB> compose(Function1<A$, Expression> g) {
        return ST_GeogFromWKB$.MODULE$.compose(g);
    }

    @Override
    public final TreeNode mapChildren(Function1 f) {
        return UnaryLike.mapChildren$(this, f);
    }

    @Override
    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return UnaryLike.withNewChildrenInternal$(this, newChildren);
    }

    @Override
    public /* synthetic */ TypeCheckResult org$apache$spark$sql$catalyst$expressions$st$GeospatialInputTypes$$super$checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return GeospatialInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public boolean nullable() {
        return RuntimeReplaceable.nullable$(this);
    }

    @Override
    public DataType dataType() {
        return RuntimeReplaceable.dataType$(this);
    }

    @Override
    public final Object eval(InternalRow input) {
        return RuntimeReplaceable.eval$(this, input);
    }

    @Override
    public final InternalRow eval$default$1() {
        return RuntimeReplaceable.eval$default$1$(this);
    }

    @Override
    public final ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return RuntimeReplaceable.doGenCode$(this, ctx, ev);
    }

    private Seq<Expression> children$lzycompute() {
        ST_GeogFromWKB sT_GeogFromWKB = this;
        synchronized (sT_GeogFromWKB) {
            if (!this.bitmap$trans$0) {
                this.children = UnaryLike.children$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.children;
    }

    @Override
    public final Seq<Expression> children() {
        if (!this.bitmap$trans$0) {
            return this.children$lzycompute();
        }
        return this.children;
    }

    @Override
    public Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private Expression canonicalized$lzycompute() {
        ST_GeogFromWKB sT_GeogFromWKB = this;
        synchronized (sT_GeogFromWKB) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.canonicalized = RuntimeReplaceable.canonicalized$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.canonicalized;
    }

    @Override
    public Expression canonicalized() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.canonicalized$lzycompute();
        }
        return this.canonicalized;
    }

    @Override
    public void org$apache$spark$sql$catalyst$expressions$RuntimeReplaceable$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public Expression wkb() {
        return this.wkb;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)BinaryType$.MODULE$, (List)Nil$.MODULE$);
    }

    private Expression replacement$lzycompute() {
        ST_GeogFromWKB sT_GeogFromWKB = this;
        synchronized (sT_GeogFromWKB) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                Class<STUtils> x$1 = STUtils.class;
                GeographyType x$2 = GeographyType$.MODULE$.apply(ExpressionDefaults$.MODULE$.DEFAULT_GEOGRAPHY_SRID());
                String x$3 = "stGeogFromWKB";
                .colon.colon x$4 = new .colon.colon((Object)this.wkb(), (List)Nil$.MODULE$);
                boolean x$5 = false;
                Seq<AbstractDataType> x$6 = StaticInvoke$.MODULE$.apply$default$5();
                boolean x$7 = StaticInvoke$.MODULE$.apply$default$6();
                boolean x$8 = StaticInvoke$.MODULE$.apply$default$8();
                Option<ScalarFunction<?>> x$9 = StaticInvoke$.MODULE$.apply$default$9();
                this.replacement = new StaticInvoke(STUtils.class, (DataType)x$2, "stGeogFromWKB", (Seq<Expression>)x$4, x$6, x$7, false, x$8, x$9);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.replacement;
    }

    @Override
    public Expression replacement() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.replacement$lzycompute();
        }
        return this.replacement;
    }

    @Override
    public String prettyName() {
        return "st_geogfromwkb";
    }

    @Override
    public Expression child() {
        return this.wkb();
    }

    @Override
    public ST_GeogFromWKB withNewChildInternal(Expression newChild) {
        return this.copy(newChild);
    }

    public ST_GeogFromWKB copy(Expression wkb) {
        return new ST_GeogFromWKB(wkb);
    }

    public Expression copy$default$1() {
        return this.wkb();
    }

    @Override
    public String productPrefix() {
        return "ST_GeogFromWKB";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.wkb();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ST_GeogFromWKB;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "wkb";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ST_GeogFromWKB)) return false;
        boolean bl = true;
        if (!bl) return false;
        ST_GeogFromWKB sT_GeogFromWKB = (ST_GeogFromWKB)x$1;
        Expression expression = this.wkb();
        Expression expression2 = sT_GeogFromWKB.wkb();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!sT_GeogFromWKB.canEqual(this)) return false;
        return true;
    }

    public ST_GeogFromWKB(Expression wkb) {
        this.wkb = wkb;
        RuntimeReplaceable.$init$(this);
        ExpectsInputTypes.$init$(this);
        GeospatialInputTypes.$init$(this);
        UnaryLike.$init$(this);
        Statics.releaseFence();
    }
}

