/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.datasketches.kll.KllFloatsSketch;
import org.apache.datasketches.kll.KllSketch;
import org.apache.datasketches.memory.Memory;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.KllSketchMergeBase;
import org.apache.spark.sql.catalyst.expressions.KllSketchMergeFloat$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(left, right) - Merges two sketch buffers together into one.\n  ", examples="\n    Examples:\n      > SELECT LENGTH(kll_sketch_to_string_float(_FUNC_(kll_sketch_agg_float(col), kll_sketch_agg_float(col)))) > 0 FROM VALUES (CAST(1.0 AS FLOAT)), (CAST(2.0 AS FLOAT)), (CAST(3.0 AS FLOAT)), (CAST(4.0 AS FLOAT)), (CAST(5.0 AS FLOAT)) tab(col);\n       true\n  ", group="sketch_funcs", since="4.1.0")
@ScalaSignature(bytes="\u0006\u0005\u0005ue\u0001\u0002\u000e\u001c\u0001\"B\u0001b\u0010\u0001\u0003\u0016\u0004%\t\u0001\u0011\u0005\t\t\u0002\u0011\t\u0012)A\u0005\u0003\"AQ\t\u0001BK\u0002\u0013\u0005\u0001\t\u0003\u0005G\u0001\tE\t\u0015!\u0003B\u0011\u00159\u0005\u0001\"\u0001I\u0011\u0015a\u0005\u0001\"\u0011N\u0011\u0015\u0011\u0006\u0001\"\u0011T\u0011\u0015a\u0006\u0001\"\u0011^\u0011\u001d\u0019\u0007!!A\u0005\u0002\u0011Dqa\u001a\u0001\u0012\u0002\u0013\u0005\u0001\u000eC\u0004t\u0001E\u0005I\u0011\u00015\t\u000fQ\u0004\u0011\u0011!C!k\"9Q\u0010AA\u0001\n\u0003q\b\"CA\u0003\u0001\u0005\u0005I\u0011AA\u0004\u0011%\ti\u0001AA\u0001\n\u0003\ny\u0001C\u0005\u0002\u001e\u0001\t\t\u0011\"\u0001\u0002 !I\u0011\u0011\u0006\u0001\u0002\u0002\u0013\u0005\u00131\u0006\u0005\n\u0003_\u0001\u0011\u0011!C!\u0003c9\u0011\"!\u0016\u001c\u0003\u0003E\t!a\u0016\u0007\u0011iY\u0012\u0011!E\u0001\u00033Baa\u0012\u000b\u0005\u0002\u0005E\u0004\"CA:)\u0005\u0005IQIA;\u0011%\t9\bFA\u0001\n\u0003\u000bI\bC\u0005\u0002\u0000Q\t\t\u0011\"!\u0002\u0002\"I\u00111\u0013\u000b\u0002\u0002\u0013%\u0011Q\u0013\u0002\u0014\u00172d7k[3uG\"lUM]4f\r2|\u0017\r\u001e\u0006\u00039u\t1\"\u001a=qe\u0016\u001c8/[8og*\u0011adH\u0001\tG\u0006$\u0018\r\\=ti*\u0011\u0001%I\u0001\u0004gFd'B\u0001\u0012$\u0003\u0015\u0019\b/\u0019:l\u0015\t!S%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002M\u0005\u0019qN]4\u0004\u0001M!\u0001!K\u00174!\tQ3&D\u0001\u001c\u0013\ta3D\u0001\nLY2\u001c6.\u001a;dQ6+'oZ3CCN,\u0007C\u0001\u00182\u001b\u0005y#\"\u0001\u0019\u0002\u000bM\u001c\u0017\r\\1\n\u0005Iz#a\u0002)s_\u0012,8\r\u001e\t\u0003iqr!!\u000e\u001e\u000f\u0005YJT\"A\u001c\u000b\u0005a:\u0013A\u0002\u001fs_>$h(C\u00011\u0013\tYt&A\u0004qC\u000e\\\u0017mZ3\n\u0005ur$\u0001D*fe&\fG.\u001b>bE2,'BA\u001e0\u0003\u0011aWM\u001a;\u0016\u0003\u0005\u0003\"A\u000b\"\n\u0005\r[\"AC#yaJ,7o]5p]\u0006)A.\u001a4uA\u0005)!/[4ii\u00061!/[4ii\u0002\na\u0001P5oSRtDcA%K\u0017B\u0011!\u0006\u0001\u0005\u0006\u007f\u0015\u0001\r!\u0011\u0005\u0006\u000b\u0016\u0001\r!Q\u0001\u0018o&$\bNT3x\u0007\"LG\u000e\u001a:f]&sG/\u001a:oC2$2!\u0011(Q\u0011\u0015ye\u00011\u0001B\u0003\u001dqWm\u001e'fMRDQ!\u0015\u0004A\u0002\u0005\u000b\u0001B\\3x%&<\u0007\u000e^\u0001\u000baJ,G\u000f^=OC6,W#\u0001+\u0011\u0005UKfB\u0001,X!\t1t&\u0003\u0002Y_\u00051\u0001K]3eK\u001aL!AW.\u0003\rM#(/\u001b8h\u0015\tAv&\u0001\u0007ok2d7+\u00194f\u000bZ\fG\u000eF\u0002_C\n\u0004\"AL0\n\u0005\u0001|#aA!os\")q\b\u0003a\u0001=\")Q\t\u0003a\u0001=\u0006!1m\u001c9z)\rIUM\u001a\u0005\b\u007f%\u0001\n\u00111\u0001B\u0011\u001d)\u0015\u0002%AA\u0002\u0005\u000babY8qs\u0012\"WMZ1vYR$\u0013'F\u0001jU\t\t%nK\u0001l!\ta\u0017/D\u0001n\u0015\tqw.A\u0005v]\u000eDWmY6fI*\u0011\u0001oL\u0001\u000bC:tw\u000e^1uS>t\u0017B\u0001:n\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\ta\u000f\u0005\u0002xy6\t\u0001P\u0003\u0002zu\u0006!A.\u00198h\u0015\u0005Y\u0018\u0001\u00026bm\u0006L!A\u0017=\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0003}\u00042ALA\u0001\u0013\r\t\u0019a\f\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0004=\u0006%\u0001\u0002CA\u0006\u001d\u0005\u0005\t\u0019A@\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\t\t\u0002E\u0003\u0002\u0014\u0005ea,\u0004\u0002\u0002\u0016)\u0019\u0011qC\u0018\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002\u001c\u0005U!\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!!\t\u0002(A\u0019a&a\t\n\u0007\u0005\u0015rFA\u0004C_>dW-\u00198\t\u0011\u0005-\u0001#!AA\u0002y\u000b!\u0003\u001d:pIV\u001cG/\u00127f[\u0016tGOT1nKR\u0019a/!\f\t\u0011\u0005-\u0011#!AA\u0002}\fa!Z9vC2\u001cH\u0003BA\u0011\u0003gA\u0001\"a\u0003\u0013\u0003\u0003\u0005\rA\u0018\u0015\u0014\u0001\u0005]\u0012QHA \u0003\u0007\n)%!\u0013\u0002L\u0005=\u0013\u0011\u000b\t\u0004U\u0005e\u0012bAA\u001e7\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017EAA!\u0003)S\u0001\u0005\t\u0011!?\u001a+fjQ0)Y\u00164G\u000f\f\u0011sS\u001eDG/\u000b\u0011.A5+'oZ3tAQ<x\u000eI:lKR\u001c\u0007\u000e\t2vM\u001a,'o\u001d\u0011u_\u001e,G\u000f[3sA%tGo\u001c\u0011p]\u0016t#\u0002\t\u0011\u0002\u0011\u0015D\u0018-\u001c9mKN\f#!a\u0012\u0002\u0005SQ\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006\u0005T#O\u000fRC\u0005f\u001b7m?N\\W\r^2i?R|wl\u001d;sS:<wL\u001a7pCRDsLR+O\u0007~C3\u000e\u001c7`g.,Go\u00195`C\u001e<wL\u001a7pCRD3m\u001c7*Y\u0001ZG\u000e\\0tW\u0016$8\r[0bO\u001e|f\r\\8bi\"\u001aw\u000e\\\u0015*S%\u0002c\b\t\u0019!\rJ{U\n\t,B\u0019V+5\u000b\t\u0015D\u0003N#\u0006&\r\u00181A\u0005\u001b\u0006E\u0012'P\u0003RK\u0013\u0006\f\u0011)\u0007\u0006\u001bF\u000b\u000b\u001a/a\u0001\n5\u000b\t$M\u001f\u0006#\u0016&\u000b\u0017!Q\r\u000b5\u000b\u0016\u00154]A\u0002\u0013i\u0015\u0011G\u0019>\u000bE+K\u0015-A!\u001a\u0015i\u0015+)i9\u0002\u0004%Q*!\r2{\u0015\tV\u0015*Y\u0001B3)Q*UQUr\u0003\u0007I!TA\u0019cu*\u0011+*S\u0001\"\u0018M\u0019\u0015d_2L3H\u0003\u0011!A\u0001\u0002\u0003\u0005\t;sk\u0016T\u0001\u0005I\u0001\u0006OJ|W\u000f]\u0011\u0003\u0003\u001b\nAb]6fi\u000eDwLZ;oGN\fQa]5oG\u0016\f#!a\u0015\u0002\u000bQr\u0013G\f\u0019\u0002'-cGnU6fi\u000eDW*\u001a:hK\u001acw.\u0019;\u0011\u0005)\"2#\u0002\u000b\u0002\\\u0005\u001d\u0004cBA/\u0003G\n\u0015)S\u0007\u0003\u0003?R1!!\u00190\u0003\u001d\u0011XO\u001c;j[\u0016LA!!\u001a\u0002`\t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u001a\u0011\t\u0005%\u0014qN\u0007\u0003\u0003WR1!!\u001c{\u0003\tIw.C\u0002>\u0003W\"\"!a\u0016\u0002\u0011Q|7\u000b\u001e:j]\u001e$\u0012A^\u0001\u0006CB\u0004H.\u001f\u000b\u0006\u0013\u0006m\u0014Q\u0010\u0005\u0006\u007f]\u0001\r!\u0011\u0005\u0006\u000b^\u0001\r!Q\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\t\u0019)a$\u0011\u000b9\n))!#\n\u0007\u0005\u001duF\u0001\u0004PaRLwN\u001c\t\u0006]\u0005-\u0015)Q\u0005\u0004\u0003\u001b{#A\u0002+va2,'\u0007\u0003\u0005\u0002\u0012b\t\t\u00111\u0001J\u0003\rAH\u0005M\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0003\u0003/\u00032a^AM\u0013\r\tY\n\u001f\u0002\u0007\u001f\nTWm\u0019;")
public class KllSketchMergeFloat
extends KllSketchMergeBase
implements Serializable {
    private final Expression left;
    private final Expression right;

    public static Option<Tuple2<Expression, Expression>> unapply(KllSketchMergeFloat x$0) {
        return KllSketchMergeFloat$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple2<Expression, Expression>, KllSketchMergeFloat> tupled() {
        return KllSketchMergeFloat$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, KllSketchMergeFloat>> curried() {
        return KllSketchMergeFloat$.MODULE$.curried();
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public Expression withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight);
    }

    @Override
    public String prettyName() {
        return "kll_sketch_merge_float";
    }

    @Override
    public Object nullSafeEval(Object left, Object right) {
        byte[] byArray;
        try {
            byte[] leftBuffer = (byte[])left;
            byte[] rightBuffer = (byte[])right;
            KllFloatsSketch leftSketch = KllFloatsSketch.heapify((Memory)Memory.wrap((byte[])leftBuffer));
            KllFloatsSketch rightSketch = KllFloatsSketch.wrap((Memory)Memory.wrap((byte[])rightBuffer));
            leftSketch.merge((KllSketch)rightSketch);
            byArray = leftSketch.toByteArray();
        }
        catch (Exception exception) {
            throw QueryExecutionErrors$.MODULE$.kllInvalidInputSketchBuffer(this.prettyName(), QueryExecutionErrors$.MODULE$.kllInvalidInputSketchBuffer$default$2());
        }
        return byArray;
    }

    public KllSketchMergeFloat copy(Expression left, Expression right) {
        return new KllSketchMergeFloat(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "KllSketchMergeFloat";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.left();
            }
            case 1: {
                return this.right();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof KllSketchMergeFloat;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "left";
            }
            case 1: {
                return "right";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof KllSketchMergeFloat)) return false;
        boolean bl = true;
        if (!bl) return false;
        KllSketchMergeFloat kllSketchMergeFloat = (KllSketchMergeFloat)x$1;
        Expression expression = this.left();
        Expression expression2 = kllSketchMergeFloat.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = kllSketchMergeFloat.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!kllSketchMergeFloat.canEqual(this)) return false;
        return true;
    }

    public KllSketchMergeFloat(Expression left, Expression right) {
        this.left = left;
        this.right = right;
    }
}

