/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.util;

import org.apache.spark.sql.catalyst.util.Geography;
import org.apache.spark.sql.catalyst.util.Geometry;
import org.apache.spark.sql.errors.QueryExecutionErrors;
import org.apache.spark.sql.types.GeographyType;
import org.apache.spark.sql.types.GeometryType;
import org.apache.spark.unsafe.types.GeographyVal;
import org.apache.spark.unsafe.types.GeometryVal;

public final class STUtils {
    static Geography fromPhysVal(GeographyVal value) {
        return Geography.fromBytes(value.getBytes());
    }

    static Geometry fromPhysVal(GeometryVal value) {
        return Geometry.fromBytes(value.getBytes());
    }

    static GeographyVal toPhysVal(Geography g) {
        return g.getValue();
    }

    static GeometryVal toPhysVal(Geometry g) {
        return g.getValue();
    }

    public static GeometryVal geographyToGeometry(GeographyVal geographyVal) {
        return STUtils.toPhysVal(Geometry.fromBytes(geographyVal.getBytes()));
    }

    public static GeometryVal serializeGeomFromWKB(org.apache.spark.sql.types.Geometry geometry, GeometryType gt) {
        int geometrySrid = geometry.getSrid();
        gt.assertSridAllowedForType(geometrySrid);
        return STUtils.toPhysVal(Geometry.fromWkb(geometry.getBytes(), geometrySrid));
    }

    public static GeographyVal serializeGeogFromWKB(org.apache.spark.sql.types.Geography geography, GeographyType gt) {
        int geographySrid = geography.getSrid();
        gt.assertSridAllowedForType(geographySrid);
        return STUtils.toPhysVal(Geography.fromWkb(geography.getBytes(), geographySrid));
    }

    public static org.apache.spark.sql.types.Geometry deserializeGeom(GeometryVal geometry, GeometryType gt) {
        int geometrySrid = STUtils.stSrid(geometry);
        gt.assertSridAllowedForType(geometrySrid);
        byte[] wkb = STUtils.stAsBinary(geometry);
        return org.apache.spark.sql.types.Geometry.fromWKB((byte[])wkb, (int)geometrySrid);
    }

    public static org.apache.spark.sql.types.Geography deserializeGeog(GeographyVal geography, GeographyType gt) {
        int geographySrid = STUtils.stSrid(geography);
        gt.assertSridAllowedForType(geographySrid);
        byte[] wkb = STUtils.stAsBinary(geography);
        return org.apache.spark.sql.types.Geography.fromWKB((byte[])wkb, (int)geographySrid);
    }

    public static byte[] stAsBinary(GeographyVal geo) {
        return STUtils.fromPhysVal(geo).toWkb();
    }

    public static byte[] stAsBinary(GeometryVal geo) {
        return STUtils.fromPhysVal(geo).toWkb();
    }

    public static GeographyVal stGeogFromWKB(byte[] wkb) {
        return STUtils.toPhysVal(Geography.fromWkb(wkb));
    }

    public static GeometryVal stGeomFromWKB(byte[] wkb) {
        return STUtils.toPhysVal(Geometry.fromWkb(wkb));
    }

    public static GeometryVal stGeomFromWKB(byte[] wkb, int srid) {
        if (!GeometryType.isSridSupported((int)srid)) {
            throw QueryExecutionErrors.stInvalidSridValueError(srid);
        }
        return STUtils.toPhysVal(Geometry.fromWkb(wkb, srid));
    }

    public static GeographyVal stSetSrid(GeographyVal geo, int srid) {
        if (!GeographyType.isSridSupported((int)srid)) {
            throw QueryExecutionErrors.stInvalidSridValueError(srid);
        }
        Geography copy = STUtils.fromPhysVal(geo).copy();
        copy.setSrid(srid);
        return STUtils.toPhysVal(copy);
    }

    public static GeometryVal stSetSrid(GeometryVal geo, int srid) {
        if (!GeometryType.isSridSupported((int)srid)) {
            throw QueryExecutionErrors.stInvalidSridValueError(srid);
        }
        Geometry copy = STUtils.fromPhysVal(geo).copy();
        copy.setSrid(srid);
        return STUtils.toPhysVal(copy);
    }

    public static int stSrid(GeographyVal geog) {
        return STUtils.fromPhysVal(geog).srid();
    }

    public static int stSrid(GeometryVal geom) {
        return STUtils.fromPhysVal(geom).srid();
    }
}

