/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.state;

import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.BoundReference;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection$;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.execution.streaming.state.HDFSBackedStateStoreMap;
import org.apache.spark.sql.execution.streaming.state.HDFSBackedStateStoreMap$;
import org.apache.spark.sql.execution.streaming.state.KeyValueIntegrityVerifier;
import org.apache.spark.sql.execution.streaming.state.UnsafeRowPair;
import org.apache.spark.sql.execution.streaming.state.UnsafeRowPair$;
import org.apache.spark.sql.execution.streaming.state.UnsafeRowWrapper;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u0005Md\u0001\u0002\f\u0018\u0001\u0019B\u0001\"\r\u0001\u0003\u0002\u0003\u0006IA\r\u0005\tq\u0001\u0011\t\u0011)A\u0005s!AA\b\u0001BC\u0002\u0013%Q\b\u0003\u0005E\u0001\t\u0005\t\u0015!\u0003?\u0011\u0015)\u0005\u0001\"\u0001G\u0011\u001dY\u0005A1A\u0005\n1CaA\u0019\u0001!\u0002\u0013i\u0005bB2\u0001\u0005\u0004%I\u0001\u001a\u0005\u0007]\u0002\u0001\u000b\u0011B3\t\u000f=\u0004!\u0019!C\u0005a\"9\u0011q\u0001\u0001!\u0002\u0013\t\b\"CA\u0005\u0001\t\u0007I\u0011BA\u0006\u0011!\t\u0019\u0002\u0001Q\u0001\n\u00055\u0001bBA\u000b\u0001\u0011\u0005\u0013q\u0003\u0005\b\u00033\u0001A\u0011IA\u000e\u0011\u001d\t\t\u0003\u0001C!\u0003GAq!a\u000b\u0001\t\u0003\ti\u0003C\u0004\u0002:\u0001!\t%a\u000f\t\u000f\u0005}\u0002\u0001\"\u0011\u0002B!9\u0011q\n\u0001\u0005B\u0005E\u0003bBA6\u0001\u0011\u0005\u0013Q\u000e\u0002'!J,g-\u001b=TG\u0006tg.\u00192mK\"#ei\u0015\"bG.,Gm\u0015;bi\u0016\u001cFo\u001c:f\u001b\u0006\u0004(B\u0001\r\u001a\u0003\u0015\u0019H/\u0019;f\u0015\tQ2$A\u0005tiJ,\u0017-\\5oO*\u0011A$H\u0001\nKb,7-\u001e;j_:T!AH\u0010\u0002\u0007M\fHN\u0003\u0002!C\u0005)1\u000f]1sW*\u0011!eI\u0001\u0007CB\f7\r[3\u000b\u0003\u0011\n1a\u001c:h\u0007\u0001\u00192\u0001A\u0014.!\tA3&D\u0001*\u0015\u0005Q\u0013!B:dC2\f\u0017B\u0001\u0017*\u0005\u0019\te.\u001f*fMB\u0011afL\u0007\u0002/%\u0011\u0001g\u0006\u0002\u0018\u0011\u001235KQ1dW\u0016$7\u000b^1uKN#xN]3NCB\f\u0011b[3z'\u000eDW-\\1\u0011\u0005M2T\"\u0001\u001b\u000b\u0005Uj\u0012!\u0002;za\u0016\u001c\u0018BA\u001c5\u0005)\u0019FO];diRK\b/Z\u0001\u0011]Vl7i\u001c7t!J,g-\u001b=LKf\u0004\"\u0001\u000b\u001e\n\u0005mJ#aA%oi\u0006a!/Z1e-\u0016\u0014\u0018NZ5feV\ta\bE\u0002)\u007f\u0005K!\u0001Q\u0015\u0003\r=\u0003H/[8o!\tq#)\u0003\u0002D/\tI2*Z=WC2,X-\u00138uK\u001e\u0014\u0018\u000e^=WKJLg-[3s\u00035\u0011X-\u00193WKJLg-[3sA\u00051A(\u001b8jiz\"Ba\u0012%J\u0015B\u0011a\u0006\u0001\u0005\u0006c\u0015\u0001\rA\r\u0005\u0006q\u0015\u0001\r!\u000f\u0005\u0006y\u0015\u0001\rAP\u0001\u0004[\u0006\u0004X#A'\u0011\t9+vkX\u0007\u0002\u001f*\u0011\u0001+U\u0001\u000bG>t7-\u001e:sK:$(B\u0001*T\u0003\u0011)H/\u001b7\u000b\u0003Q\u000bAA[1wC&\u0011ak\u0014\u0002\u0012\u0007>t7-\u001e:sK:$\b*Y:i\u001b\u0006\u0004\bC\u0001-^\u001b\u0005I&B\u0001.\\\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005qk\u0012\u0001C2bi\u0006d\u0017p\u001d;\n\u0005yK&!C+og\u00064WMU8x!\tq\u0003-\u0003\u0002b/\t\u0001RK\\:bM\u0016\u0014vn^,sCB\u0004XM]\u0001\u0005[\u0006\u0004\b%\u0001\nqe\u00164\u0017\u000e_&fsR{7*Z=t\u001b\u0006\u0004X#A3\u0011\t9+vK\u001a\t\u0004O2<V\"\u00015\u000b\u0005%T\u0017aB7vi\u0006\u0014G.\u001a\u0006\u0003W&\n!bY8mY\u0016\u001cG/[8o\u0013\ti\u0007NA\u0002TKR\f1\u0003\u001d:fM&D8*Z=U_.+\u0017p]'ba\u0002\na\u0003\u001d:fM&D8*Z=GS\u0016dGm],ji\"LE\r_\u000b\u0002cB\u0019!O_?\u000f\u0005MDhB\u0001;x\u001b\u0005)(B\u0001<&\u0003\u0019a$o\\8u}%\t!&\u0003\u0002zS\u00059\u0001/Y2lC\u001e,\u0017BA>}\u0005\r\u0019V-\u001d\u0006\u0003s&\u0002R\u0001\u000b@\u0002\u0002eJ!a`\u0015\u0003\rQ+\b\u000f\\33!\r\u0019\u00141A\u0005\u0004\u0003\u000b!$aC*ueV\u001cGOR5fY\u0012\fq\u0003\u001d:fM&D8*Z=GS\u0016dGm],ji\"LE\r\u001f\u0011\u0002'A\u0014XMZ5y\u0017\u0016L\bK]8kK\u000e$\u0018n\u001c8\u0016\u0005\u00055\u0001c\u0001-\u0002\u0010%\u0019\u0011\u0011C-\u0003!Us7/\u00194f!J|'.Z2uS>t\u0017\u0001\u00069sK\u001aL\u0007pS3z!J|'.Z2uS>t\u0007%\u0001\u0003tSj,G#A\u001d\u0002\u0007\u001d,G\u000fF\u0002X\u0003;Aa!a\b\u0010\u0001\u00049\u0016aA6fs\u0006\u0019\u0001/\u001e;\u0015\u000b}\u000b)#a\n\t\r\u0005}\u0001\u00031\u0001X\u0011\u0019\tI\u0003\u0005a\u0001?\u0006)a/\u00197vK\u00061\u0001/\u001e;BY2$B!a\f\u00026A\u0019\u0001&!\r\n\u0007\u0005M\u0012F\u0001\u0003V]&$\bBBA\u001c#\u0001\u0007Q&A\u0003pi\",'/\u0001\u0004sK6|g/\u001a\u000b\u0004?\u0006u\u0002BBA\u0010%\u0001\u0007q+\u0001\u0005ji\u0016\u0014\u0018\r^8s)\t\t\u0019\u0005E\u0003s\u0003\u000b\nI%C\u0002\u0002Hq\u0014\u0001\"\u0013;fe\u0006$xN\u001d\t\u0004]\u0005-\u0013bAA'/\tiQK\\:bM\u0016\u0014vn\u001e)bSJ\fQ\"\u001a8uefLE/\u001a:bi>\u0014HCAA*!\u0015\u0011\u0018QIA+!\u0019\t9&!\u001aX?:!\u0011\u0011LA1\u001d\u0011\tY&a\u0018\u000f\u0007Q\fi&C\u0001U\u0013\t\u00116+C\u0002\u0002dE\u000b1!T1q\u0013\u0011\t9'!\u001b\u0003\u000b\u0015sGO]=\u000b\u0007\u0005\r\u0014+\u0001\u0006qe\u00164\u0017\u000e_*dC:$B!a\u0011\u0002p!1\u0011\u0011O\u000bA\u0002]\u000b\u0011\u0002\u001d:fM&D8*Z=")
public class PrefixScannableHDFSBackedStateStoreMap
implements HDFSBackedStateStoreMap {
    private final Option<KeyValueIntegrityVerifier> readVerifier;
    private final ConcurrentHashMap<UnsafeRow, UnsafeRowWrapper> map;
    private final ConcurrentHashMap<UnsafeRow, Set<UnsafeRow>> prefixKeyToKeysMap;
    private final Seq<Tuple2<StructField, Object>> prefixKeyFieldsWithIdx;
    private final UnsafeProjection prefixKeyProjection;

    private Option<KeyValueIntegrityVerifier> readVerifier() {
        return this.readVerifier;
    }

    private ConcurrentHashMap<UnsafeRow, UnsafeRowWrapper> map() {
        return this.map;
    }

    private ConcurrentHashMap<UnsafeRow, Set<UnsafeRow>> prefixKeyToKeysMap() {
        return this.prefixKeyToKeysMap;
    }

    private Seq<Tuple2<StructField, Object>> prefixKeyFieldsWithIdx() {
        return this.prefixKeyFieldsWithIdx;
    }

    private UnsafeProjection prefixKeyProjection() {
        return this.prefixKeyProjection;
    }

    @Override
    public int size() {
        return this.map().size();
    }

    @Override
    public UnsafeRow get(UnsafeRow key) {
        return HDFSBackedStateStoreMap$.MODULE$.getAndVerifyValueRow(key, this.map().get(key), this.readVerifier());
    }

    @Override
    public UnsafeRowWrapper put(UnsafeRow key, UnsafeRowWrapper value) {
        UnsafeRowWrapper ret = this.map().put(key, value);
        UnsafeRow prefixKey = this.prefixKeyProjection().apply((InternalRow)key).copy();
        this.prefixKeyToKeysMap().compute(prefixKey, (x$2, v) -> {
            if (v == null) {
                HashSet set = new HashSet();
                set.add((Object)key);
                return set;
            }
            v.add((Object)key);
            return v;
        });
        return ret;
    }

    @Override
    public void putAll(HDFSBackedStateStoreMap other) {
        HDFSBackedStateStoreMap hDFSBackedStateStoreMap = other;
        if (hDFSBackedStateStoreMap instanceof PrefixScannableHDFSBackedStateStoreMap) {
            PrefixScannableHDFSBackedStateStoreMap prefixScannableHDFSBackedStateStoreMap = (PrefixScannableHDFSBackedStateStoreMap)hDFSBackedStateStoreMap;
            this.map().putAll(prefixScannableHDFSBackedStateStoreMap.map());
            CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(prefixScannableHDFSBackedStateStoreMap.prefixKeyToKeysMap()).asScala().foreach((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    UnsafeRow prefixKey = (UnsafeRow)tuple2._1();
                    Set keySet = (Set)tuple2._2();
                    HashSet newSet = new HashSet();
                    newSet.$plus$plus$eq((IterableOnce)keySet);
                    return this.prefixKeyToKeysMap().put(prefixKey, (Set<UnsafeRow>)newSet);
                }
                throw new MatchError((Object)tuple2);
            });
            return;
        }
        other.entryIterator().foreach((Function1 & Serializable)pair -> this.put((UnsafeRow)pair.getKey(), (UnsafeRowWrapper)pair.getValue()));
    }

    @Override
    public UnsafeRowWrapper remove(UnsafeRow key) {
        UnsafeRowWrapper ret = this.map().remove(key);
        if (ret != null) {
            UnsafeRow prefixKey = this.prefixKeyProjection().apply((InternalRow)key).copy();
            v0 = this.prefixKeyToKeysMap().computeIfPresent(prefixKey, (x$3, v) -> {
                v.remove((Object)key);
                if (v.isEmpty()) {
                    return null;
                }
                return v;
            });
        } else {
            v0 = BoxedUnit.UNIT;
        }
        return ret;
    }

    @Override
    public Iterator<UnsafeRowPair> iterator() {
        UnsafeRowPair unsafeRowPair = new UnsafeRowPair(UnsafeRowPair$.MODULE$.$lessinit$greater$default$1(), UnsafeRowPair$.MODULE$.$lessinit$greater$default$2());
        return this.entryIterator().map((Function1 & Serializable)entry -> {
            UnsafeRow valueRow = HDFSBackedStateStoreMap$.MODULE$.getAndVerifyValueRow((UnsafeRow)entry.getKey(), (UnsafeRowWrapper)entry.getValue(), this.readVerifier());
            return unsafeRowPair.withRows((UnsafeRow)entry.getKey(), valueRow);
        });
    }

    @Override
    public Iterator<Map.Entry<UnsafeRow, UnsafeRowWrapper>> entryIterator() {
        return CollectionConverters$.MODULE$.SetHasAsScala(this.map().entrySet()).asScala().iterator();
    }

    @Override
    public Iterator<UnsafeRowPair> prefixScan(UnsafeRow prefixKey) {
        UnsafeRowPair unsafeRowPair = new UnsafeRowPair(UnsafeRowPair$.MODULE$.$lessinit$greater$default$1(), UnsafeRowPair$.MODULE$.$lessinit$greater$default$2());
        return ((IterableOnce)this.prefixKeyToKeysMap().getOrDefault(prefixKey, (Set<UnsafeRow>)Set$.MODULE$.empty())).iterator().map((Function1 & Serializable)keyRow -> {
            UnsafeRow valueRow = HDFSBackedStateStoreMap$.MODULE$.getAndVerifyValueRow((UnsafeRow)keyRow, this.map().get(keyRow), this.readVerifier());
            return unsafeRowPair.withRows((UnsafeRow)keyRow, valueRow);
        });
    }

    public PrefixScannableHDFSBackedStateStoreMap(StructType keySchema, int numColsPrefixKey, Option<KeyValueIntegrityVerifier> readVerifier) {
        this.readVerifier = readVerifier;
        this.map = new ConcurrentHashMap();
        this.prefixKeyToKeysMap = new ConcurrentHashMap();
        this.prefixKeyFieldsWithIdx = (Seq)((IterableOps)keySchema.zipWithIndex()).take(numColsPrefixKey);
        Seq refs = (Seq)this.prefixKeyFieldsWithIdx().map((Function1 & Serializable)x -> new BoundReference(x._2$mcI$sp(), ((StructField)x._1()).dataType(), ((StructField)x._1()).nullable()));
        this.prefixKeyProjection = UnsafeProjection$.MODULE$.create(refs);
    }
}

