/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy;

import java.io.Serializable;
import java.util.ServiceLoader;
import org.apache.spark.SparkException;
import org.apache.spark.deploy.SparkDiagnosticsSetter;
import org.apache.spark.deploy.SparkSubmitOperation;
import org.apache.spark.util.ArrayImplicits$;
import org.apache.spark.util.Utils$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.immutable.ArraySeq;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.runtime.BoxesRunTime;

public final class SparkSubmitUtils$ {
    public static final SparkSubmitUtils$ MODULE$ = new SparkSubmitUtils$();

    public SparkSubmitOperation getSubmitOperations(String master) {
        ClassLoader loader = Utils$.MODULE$.getContextOrSparkClassLoader();
        Iterable serviceLoaders = (Iterable)CollectionConverters$.MODULE$.IterableHasAsScala(ServiceLoader.load(SparkSubmitOperation.class, loader)).asScala().filter((Function1 & Serializable)x$29 -> BoxesRunTime.boxToBoolean((boolean)x$29.supports(master)));
        int n = serviceLoaders.size();
        if (n > 1) {
            throw new SparkException("Multiple(" + n + ") external SparkSubmitOperations clients registered for master url " + master + ".");
        }
        if (1 == n) {
            return (SparkSubmitOperation)serviceLoaders.headOption().get();
        }
        throw new IllegalArgumentException("No external SparkSubmitOperations clients found for master url: '" + master + "'");
    }

    public Tuple2<String, String> parseSparkConfProperty(String pair) {
        SeqOps seqOps;
        ArraySeq arraySeq = ArrayImplicits$.MODULE$.SparkArrayOps((Object)pair.split("=", 2)).toImmutableArraySeq();
        if (arraySeq != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.Seq().unapplySeq((SeqOps)arraySeq)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2) == 0) {
            String k = (String)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
            String v = (String)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
            return new Tuple2((Object)k, (Object)v);
        }
        throw new SparkException("Spark config without '=': " + pair);
    }

    public Option<SparkDiagnosticsSetter> getSparkDiagnosticsSetters(String master) {
        ClassLoader loader = Utils$.MODULE$.getContextOrSparkClassLoader();
        Iterable serviceLoaders = (Iterable)CollectionConverters$.MODULE$.IterableHasAsScala(ServiceLoader.load(SparkDiagnosticsSetter.class, loader)).asScala().filter((Function1 & Serializable)x$30 -> BoxesRunTime.boxToBoolean((boolean)x$30.supports(master)));
        int n = serviceLoaders.size();
        if (n > 1) {
            throw new SparkException("Multiple(" + n + ") external SparkDiagnosticsSetter registered.");
        }
        if (1 == n) {
            return new Some(serviceLoaders.headOption().get());
        }
        return None$.MODULE$;
    }

    private SparkSubmitUtils$() {
    }
}

