/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.autoscaling.v2;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.autoscaling.v2.HPAScalingPolicy;
import io.fabric8.kubernetes.api.model.autoscaling.v2.HPAScalingPolicyBuilder;
import io.fabric8.kubernetes.api.model.autoscaling.v2.HPAScalingPolicyFluent;
import io.fabric8.kubernetes.api.model.autoscaling.v2.HPAScalingRules;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class HPAScalingRulesFluent<A extends HPAScalingRulesFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private ArrayList<HPAScalingPolicyBuilder> policies = new ArrayList();
    private String selectPolicy;
    private Integer stabilizationWindowSeconds;
    private Quantity tolerance;

    public HPAScalingRulesFluent() {
    }

    public HPAScalingRulesFluent(HPAScalingRules instance) {
        this.copyInstance(instance);
    }

    public A addAllToPolicies(Collection<HPAScalingPolicy> items) {
        if (this.policies == null) {
            this.policies = new ArrayList();
        }
        for (HPAScalingPolicy item : items) {
            HPAScalingPolicyBuilder builder = new HPAScalingPolicyBuilder(item);
            this._visitables.get((Object)"policies").add(builder);
            this.policies.add(builder);
        }
        return (A)((Object)this);
    }

    public PoliciesNested<A> addNewPolicy() {
        return new PoliciesNested(-1, null);
    }

    public A addNewPolicy(Integer periodSeconds, String type, Integer value) {
        return this.addToPolicies(new HPAScalingPolicy(periodSeconds, type, value));
    }

    public PoliciesNested<A> addNewPolicyLike(HPAScalingPolicy item) {
        return new PoliciesNested(-1, item);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToPolicies(HPAScalingPolicy ... items) {
        if (this.policies == null) {
            this.policies = new ArrayList();
        }
        for (HPAScalingPolicy item : items) {
            HPAScalingPolicyBuilder builder = new HPAScalingPolicyBuilder(item);
            this._visitables.get((Object)"policies").add(builder);
            this.policies.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToPolicies(int index, HPAScalingPolicy item) {
        if (this.policies == null) {
            this.policies = new ArrayList();
        }
        HPAScalingPolicyBuilder builder = new HPAScalingPolicyBuilder(item);
        if (index < 0 || index >= this.policies.size()) {
            this._visitables.get((Object)"policies").add(builder);
            this.policies.add(builder);
        } else {
            this._visitables.get((Object)"policies").add(builder);
            this.policies.add(index, builder);
        }
        return (A)((Object)this);
    }

    public HPAScalingPolicy buildFirstPolicy() {
        return this.policies.get(0).build();
    }

    public HPAScalingPolicy buildLastPolicy() {
        return this.policies.get(this.policies.size() - 1).build();
    }

    public HPAScalingPolicy buildMatchingPolicy(Predicate<HPAScalingPolicyBuilder> predicate) {
        for (HPAScalingPolicyBuilder item : this.policies) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public List<HPAScalingPolicy> buildPolicies() {
        return this.policies != null ? HPAScalingRulesFluent.build(this.policies) : null;
    }

    public HPAScalingPolicy buildPolicy(int index) {
        return this.policies.get(index).build();
    }

    protected void copyInstance(HPAScalingRules instance) {
        HPAScalingRules hPAScalingRules = instance = instance != null ? instance : new HPAScalingRules();
        if (instance != null) {
            this.withPolicies(instance.getPolicies());
            this.withSelectPolicy(instance.getSelectPolicy());
            this.withStabilizationWindowSeconds(instance.getStabilizationWindowSeconds());
            this.withTolerance(instance.getTolerance());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public PoliciesNested<A> editFirstPolicy() {
        if (this.policies.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "policies"));
        }
        return this.setNewPolicyLike(0, this.buildPolicy(0));
    }

    public PoliciesNested<A> editLastPolicy() {
        int index = this.policies.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "policies"));
        }
        return this.setNewPolicyLike(index, this.buildPolicy(index));
    }

    public PoliciesNested<A> editMatchingPolicy(Predicate<HPAScalingPolicyBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.policies.size(); ++i) {
            if (!predicate.test(this.policies.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "policies"));
        }
        return this.setNewPolicyLike(index, this.buildPolicy(index));
    }

    public PoliciesNested<A> editPolicy(int index) {
        if (this.policies.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "policies"));
        }
        return this.setNewPolicyLike(index, this.buildPolicy(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HPAScalingRulesFluent that = (HPAScalingRulesFluent)((Object)o);
        if (!Objects.equals(this.policies, that.policies)) {
            return false;
        }
        if (!Objects.equals(this.selectPolicy, that.selectPolicy)) {
            return false;
        }
        if (!Objects.equals(this.stabilizationWindowSeconds, that.stabilizationWindowSeconds)) {
            return false;
        }
        if (!Objects.equals(this.tolerance, that.tolerance)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getSelectPolicy() {
        return this.selectPolicy;
    }

    public Integer getStabilizationWindowSeconds() {
        return this.stabilizationWindowSeconds;
    }

    public Quantity getTolerance() {
        return this.tolerance;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasMatchingPolicy(Predicate<HPAScalingPolicyBuilder> predicate) {
        for (HPAScalingPolicyBuilder item : this.policies) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasPolicies() {
        return this.policies != null && !this.policies.isEmpty();
    }

    public boolean hasSelectPolicy() {
        return this.selectPolicy != null;
    }

    public boolean hasStabilizationWindowSeconds() {
        return this.stabilizationWindowSeconds != null;
    }

    public boolean hasTolerance() {
        return this.tolerance != null;
    }

    public int hashCode() {
        return Objects.hash(this.policies, this.selectPolicy, this.stabilizationWindowSeconds, this.tolerance, this.additionalProperties);
    }

    public A removeAllFromPolicies(Collection<HPAScalingPolicy> items) {
        if (this.policies == null) {
            return (A)((Object)this);
        }
        for (HPAScalingPolicy item : items) {
            HPAScalingPolicyBuilder builder = new HPAScalingPolicyBuilder(item);
            this._visitables.get((Object)"policies").remove((Object)builder);
            this.policies.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromPolicies(HPAScalingPolicy ... items) {
        if (this.policies == null) {
            return (A)((Object)this);
        }
        for (HPAScalingPolicy item : items) {
            HPAScalingPolicyBuilder builder = new HPAScalingPolicyBuilder(item);
            this._visitables.get((Object)"policies").remove((Object)builder);
            this.policies.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromPolicies(Predicate<HPAScalingPolicyBuilder> predicate) {
        if (this.policies == null) {
            return (A)((Object)this);
        }
        Iterator<HPAScalingPolicyBuilder> each = this.policies.iterator();
        List visitables = this._visitables.get((Object)"policies");
        while (each.hasNext()) {
            HPAScalingPolicyBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public PoliciesNested<A> setNewPolicyLike(int index, HPAScalingPolicy item) {
        return new PoliciesNested(index, item);
    }

    public A setToPolicies(int index, HPAScalingPolicy item) {
        if (this.policies == null) {
            this.policies = new ArrayList();
        }
        HPAScalingPolicyBuilder builder = new HPAScalingPolicyBuilder(item);
        if (index < 0 || index >= this.policies.size()) {
            this._visitables.get((Object)"policies").add(builder);
            this.policies.add(builder);
        } else {
            this._visitables.get((Object)"policies").add(builder);
            this.policies.set(index, builder);
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.policies != null && !this.policies.isEmpty()) {
            sb.append("policies:");
            sb.append(this.policies);
            sb.append(",");
        }
        if (this.selectPolicy != null) {
            sb.append("selectPolicy:");
            sb.append(this.selectPolicy);
            sb.append(",");
        }
        if (this.stabilizationWindowSeconds != null) {
            sb.append("stabilizationWindowSeconds:");
            sb.append(this.stabilizationWindowSeconds);
            sb.append(",");
        }
        if (this.tolerance != null) {
            sb.append("tolerance:");
            sb.append(this.tolerance);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withNewTolerance(String amount) {
        return this.withTolerance(new Quantity(amount));
    }

    public A withNewTolerance(String amount, String format) {
        return this.withTolerance(new Quantity(amount, format));
    }

    public A withPolicies(List<HPAScalingPolicy> policies) {
        if (this.policies != null) {
            this._visitables.get((Object)"policies").clear();
        }
        if (policies != null) {
            this.policies = new ArrayList();
            for (HPAScalingPolicy item : policies) {
                this.addToPolicies(item);
            }
        } else {
            this.policies = null;
        }
        return (A)((Object)this);
    }

    public A withPolicies(HPAScalingPolicy ... policies) {
        if (this.policies != null) {
            this.policies.clear();
            this._visitables.remove((Object)"policies");
        }
        if (policies != null) {
            for (HPAScalingPolicy item : policies) {
                this.addToPolicies(item);
            }
        }
        return (A)((Object)this);
    }

    public A withSelectPolicy(String selectPolicy) {
        this.selectPolicy = selectPolicy;
        return (A)((Object)this);
    }

    public A withStabilizationWindowSeconds(Integer stabilizationWindowSeconds) {
        this.stabilizationWindowSeconds = stabilizationWindowSeconds;
        return (A)((Object)this);
    }

    public A withTolerance(Quantity tolerance) {
        this.tolerance = tolerance;
        return (A)((Object)this);
    }

    public class PoliciesNested<N>
    extends HPAScalingPolicyFluent<PoliciesNested<N>>
    implements Nested<N> {
        HPAScalingPolicyBuilder builder;
        int index;

        PoliciesNested(int index, HPAScalingPolicy item) {
            this.index = index;
            this.builder = new HPAScalingPolicyBuilder(this, item);
        }

        public N and() {
            return (N)HPAScalingRulesFluent.this.setToPolicies(this.index, this.builder.build());
        }

        public N endPolicy() {
            return this.and();
        }
    }
}

