/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.arrow;

import java.nio.file.Path;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.classic.Dataset;
import org.apache.spark.sql.classic.SparkSession;
import org.apache.spark.sql.execution.arrow.ArrowConverters$;
import org.apache.spark.sql.execution.arrow.SparkArrowFileReader;
import org.apache.spark.sql.execution.arrow.SparkArrowFileWriter;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.ArrowUtils$;
import scala.collection.Iterator;

public final class ArrowFileReadWrite$ {
    public static final ArrowFileReadWrite$ MODULE$ = new ArrowFileReadWrite$();

    public void save(Dataset<Row> df, Path path) {
        int maxRecordsPerBatch = df.sparkSession().sessionState().conf().arrowMaxRecordsPerBatch();
        RDD<byte[]> rdd = df.toArrowBatchRdd(maxRecordsPerBatch, "UTC", true, false);
        Schema arrowSchema = ArrowUtils$.MODULE$.toArrowSchema(df.schema(), "UTC", true, false);
        SparkArrowFileWriter writer = new SparkArrowFileWriter(arrowSchema, path);
        writer.write((Iterator<byte[]>)rdd.toLocalIterator());
    }

    public Dataset<Row> load(SparkSession spark, Path path) {
        SparkArrowFileReader reader = new SparkArrowFileReader(path);
        StructType schema = ArrowUtils$.MODULE$.fromArrowSchema(reader.schema());
        return ArrowConverters$.MODULE$.toDataFrame(reader.read(), schema, spark, "UTC", true, false);
    }

    private ArrowFileReadWrite$() {
    }
}

