/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.volcano.api.model.batch.v1alpha1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.Duration;
import io.fabric8.volcano.api.model.batch.v1alpha1.JobSpec;
import io.fabric8.volcano.api.model.batch.v1alpha1.LifecyclePolicy;
import io.fabric8.volcano.api.model.batch.v1alpha1.LifecyclePolicyBuilder;
import io.fabric8.volcano.api.model.batch.v1alpha1.LifecyclePolicyFluent;
import io.fabric8.volcano.api.model.batch.v1alpha1.TaskSpec;
import io.fabric8.volcano.api.model.batch.v1alpha1.TaskSpecBuilder;
import io.fabric8.volcano.api.model.batch.v1alpha1.TaskSpecFluent;
import io.fabric8.volcano.api.model.batch.v1alpha1.VolumeSpec;
import io.fabric8.volcano.api.model.batch.v1alpha1.VolumeSpecBuilder;
import io.fabric8.volcano.api.model.batch.v1alpha1.VolumeSpecFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class JobSpecFluent<A extends JobSpecFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private Integer maxRetry;
    private Integer minAvailable;
    private Integer minSuccess;
    private Map<String, List<String>> plugins;
    private ArrayList<LifecyclePolicyBuilder> policies = new ArrayList();
    private String priorityClassName;
    private String queue;
    private Duration runningEstimate;
    private String schedulerName;
    private ArrayList<TaskSpecBuilder> tasks = new ArrayList();
    private Integer ttlSecondsAfterFinished;
    private ArrayList<VolumeSpecBuilder> volumes = new ArrayList();

    public JobSpecFluent() {
    }

    public JobSpecFluent(JobSpec instance) {
        this.copyInstance(instance);
    }

    public A addAllToPolicies(Collection<LifecyclePolicy> items) {
        if (this.policies == null) {
            this.policies = new ArrayList();
        }
        for (LifecyclePolicy item : items) {
            LifecyclePolicyBuilder builder = new LifecyclePolicyBuilder(item);
            this._visitables.get((Object)"policies").add(builder);
            this.policies.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToTasks(Collection<TaskSpec> items) {
        if (this.tasks == null) {
            this.tasks = new ArrayList();
        }
        for (TaskSpec item : items) {
            TaskSpecBuilder builder = new TaskSpecBuilder(item);
            this._visitables.get((Object)"tasks").add(builder);
            this.tasks.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToVolumes(Collection<VolumeSpec> items) {
        if (this.volumes == null) {
            this.volumes = new ArrayList();
        }
        for (VolumeSpec item : items) {
            VolumeSpecBuilder builder = new VolumeSpecBuilder(item);
            this._visitables.get((Object)"volumes").add(builder);
            this.volumes.add(builder);
        }
        return (A)((Object)this);
    }

    public PoliciesNested<A> addNewPolicy() {
        return new PoliciesNested(-1, null);
    }

    public PoliciesNested<A> addNewPolicyLike(LifecyclePolicy item) {
        return new PoliciesNested(-1, item);
    }

    public TasksNested<A> addNewTask() {
        return new TasksNested(-1, null);
    }

    public TasksNested<A> addNewTaskLike(TaskSpec item) {
        return new TasksNested(-1, item);
    }

    public VolumesNested<A> addNewVolume() {
        return new VolumesNested(-1, null);
    }

    public VolumesNested<A> addNewVolumeLike(VolumeSpec item) {
        return new VolumesNested(-1, item);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToPlugins(Map<String, List<String>> map) {
        if (this.plugins == null && map != null) {
            this.plugins = new LinkedHashMap<String, List<String>>();
        }
        if (map != null) {
            this.plugins.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToPlugins(String key, List<String> value) {
        if (this.plugins == null && key != null && value != null) {
            this.plugins = new LinkedHashMap<String, List<String>>();
        }
        if (key != null && value != null) {
            this.plugins.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToPolicies(LifecyclePolicy ... items) {
        if (this.policies == null) {
            this.policies = new ArrayList();
        }
        for (LifecyclePolicy item : items) {
            LifecyclePolicyBuilder builder = new LifecyclePolicyBuilder(item);
            this._visitables.get((Object)"policies").add(builder);
            this.policies.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToPolicies(int index, LifecyclePolicy item) {
        if (this.policies == null) {
            this.policies = new ArrayList();
        }
        LifecyclePolicyBuilder builder = new LifecyclePolicyBuilder(item);
        if (index < 0 || index >= this.policies.size()) {
            this._visitables.get((Object)"policies").add(builder);
            this.policies.add(builder);
        } else {
            this._visitables.get((Object)"policies").add(builder);
            this.policies.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToTasks(TaskSpec ... items) {
        if (this.tasks == null) {
            this.tasks = new ArrayList();
        }
        for (TaskSpec item : items) {
            TaskSpecBuilder builder = new TaskSpecBuilder(item);
            this._visitables.get((Object)"tasks").add(builder);
            this.tasks.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToTasks(int index, TaskSpec item) {
        if (this.tasks == null) {
            this.tasks = new ArrayList();
        }
        TaskSpecBuilder builder = new TaskSpecBuilder(item);
        if (index < 0 || index >= this.tasks.size()) {
            this._visitables.get((Object)"tasks").add(builder);
            this.tasks.add(builder);
        } else {
            this._visitables.get((Object)"tasks").add(builder);
            this.tasks.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToVolumes(VolumeSpec ... items) {
        if (this.volumes == null) {
            this.volumes = new ArrayList();
        }
        for (VolumeSpec item : items) {
            VolumeSpecBuilder builder = new VolumeSpecBuilder(item);
            this._visitables.get((Object)"volumes").add(builder);
            this.volumes.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToVolumes(int index, VolumeSpec item) {
        if (this.volumes == null) {
            this.volumes = new ArrayList();
        }
        VolumeSpecBuilder builder = new VolumeSpecBuilder(item);
        if (index < 0 || index >= this.volumes.size()) {
            this._visitables.get((Object)"volumes").add(builder);
            this.volumes.add(builder);
        } else {
            this._visitables.get((Object)"volumes").add(builder);
            this.volumes.add(index, builder);
        }
        return (A)((Object)this);
    }

    public LifecyclePolicy buildFirstPolicy() {
        return this.policies.get(0).build();
    }

    public TaskSpec buildFirstTask() {
        return this.tasks.get(0).build();
    }

    public VolumeSpec buildFirstVolume() {
        return this.volumes.get(0).build();
    }

    public LifecyclePolicy buildLastPolicy() {
        return this.policies.get(this.policies.size() - 1).build();
    }

    public TaskSpec buildLastTask() {
        return this.tasks.get(this.tasks.size() - 1).build();
    }

    public VolumeSpec buildLastVolume() {
        return this.volumes.get(this.volumes.size() - 1).build();
    }

    public LifecyclePolicy buildMatchingPolicy(Predicate<LifecyclePolicyBuilder> predicate) {
        for (LifecyclePolicyBuilder item : this.policies) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public TaskSpec buildMatchingTask(Predicate<TaskSpecBuilder> predicate) {
        for (TaskSpecBuilder item : this.tasks) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public VolumeSpec buildMatchingVolume(Predicate<VolumeSpecBuilder> predicate) {
        for (VolumeSpecBuilder item : this.volumes) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public List<LifecyclePolicy> buildPolicies() {
        return this.policies != null ? JobSpecFluent.build(this.policies) : null;
    }

    public LifecyclePolicy buildPolicy(int index) {
        return this.policies.get(index).build();
    }

    public TaskSpec buildTask(int index) {
        return this.tasks.get(index).build();
    }

    public List<TaskSpec> buildTasks() {
        return this.tasks != null ? JobSpecFluent.build(this.tasks) : null;
    }

    public VolumeSpec buildVolume(int index) {
        return this.volumes.get(index).build();
    }

    public List<VolumeSpec> buildVolumes() {
        return this.volumes != null ? JobSpecFluent.build(this.volumes) : null;
    }

    protected void copyInstance(JobSpec instance) {
        JobSpec jobSpec = instance = instance != null ? instance : new JobSpec();
        if (instance != null) {
            this.withMaxRetry(instance.getMaxRetry());
            this.withMinAvailable(instance.getMinAvailable());
            this.withMinSuccess(instance.getMinSuccess());
            this.withPlugins(instance.getPlugins());
            this.withPolicies(instance.getPolicies());
            this.withPriorityClassName(instance.getPriorityClassName());
            this.withQueue(instance.getQueue());
            this.withRunningEstimate(instance.getRunningEstimate());
            this.withSchedulerName(instance.getSchedulerName());
            this.withTasks(instance.getTasks());
            this.withTtlSecondsAfterFinished(instance.getTtlSecondsAfterFinished());
            this.withVolumes(instance.getVolumes());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public PoliciesNested<A> editFirstPolicy() {
        if (this.policies.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "policies"));
        }
        return this.setNewPolicyLike(0, this.buildPolicy(0));
    }

    public TasksNested<A> editFirstTask() {
        if (this.tasks.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "tasks"));
        }
        return this.setNewTaskLike(0, this.buildTask(0));
    }

    public VolumesNested<A> editFirstVolume() {
        if (this.volumes.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "volumes"));
        }
        return this.setNewVolumeLike(0, this.buildVolume(0));
    }

    public PoliciesNested<A> editLastPolicy() {
        int index = this.policies.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "policies"));
        }
        return this.setNewPolicyLike(index, this.buildPolicy(index));
    }

    public TasksNested<A> editLastTask() {
        int index = this.tasks.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "tasks"));
        }
        return this.setNewTaskLike(index, this.buildTask(index));
    }

    public VolumesNested<A> editLastVolume() {
        int index = this.volumes.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "volumes"));
        }
        return this.setNewVolumeLike(index, this.buildVolume(index));
    }

    public PoliciesNested<A> editMatchingPolicy(Predicate<LifecyclePolicyBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.policies.size(); ++i) {
            if (!predicate.test(this.policies.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "policies"));
        }
        return this.setNewPolicyLike(index, this.buildPolicy(index));
    }

    public TasksNested<A> editMatchingTask(Predicate<TaskSpecBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.tasks.size(); ++i) {
            if (!predicate.test(this.tasks.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "tasks"));
        }
        return this.setNewTaskLike(index, this.buildTask(index));
    }

    public VolumesNested<A> editMatchingVolume(Predicate<VolumeSpecBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.volumes.size(); ++i) {
            if (!predicate.test(this.volumes.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "volumes"));
        }
        return this.setNewVolumeLike(index, this.buildVolume(index));
    }

    public PoliciesNested<A> editPolicy(int index) {
        if (this.policies.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "policies"));
        }
        return this.setNewPolicyLike(index, this.buildPolicy(index));
    }

    public TasksNested<A> editTask(int index) {
        if (this.tasks.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "tasks"));
        }
        return this.setNewTaskLike(index, this.buildTask(index));
    }

    public VolumesNested<A> editVolume(int index) {
        if (this.volumes.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "volumes"));
        }
        return this.setNewVolumeLike(index, this.buildVolume(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JobSpecFluent that = (JobSpecFluent)((Object)o);
        if (!Objects.equals(this.maxRetry, that.maxRetry)) {
            return false;
        }
        if (!Objects.equals(this.minAvailable, that.minAvailable)) {
            return false;
        }
        if (!Objects.equals(this.minSuccess, that.minSuccess)) {
            return false;
        }
        if (!Objects.equals(this.plugins, that.plugins)) {
            return false;
        }
        if (!Objects.equals(this.policies, that.policies)) {
            return false;
        }
        if (!Objects.equals(this.priorityClassName, that.priorityClassName)) {
            return false;
        }
        if (!Objects.equals(this.queue, that.queue)) {
            return false;
        }
        if (!Objects.equals(this.runningEstimate, that.runningEstimate)) {
            return false;
        }
        if (!Objects.equals(this.schedulerName, that.schedulerName)) {
            return false;
        }
        if (!Objects.equals(this.tasks, that.tasks)) {
            return false;
        }
        if (!Objects.equals(this.ttlSecondsAfterFinished, that.ttlSecondsAfterFinished)) {
            return false;
        }
        if (!Objects.equals(this.volumes, that.volumes)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Integer getMaxRetry() {
        return this.maxRetry;
    }

    public Integer getMinAvailable() {
        return this.minAvailable;
    }

    public Integer getMinSuccess() {
        return this.minSuccess;
    }

    public Map<String, List<String>> getPlugins() {
        return this.plugins;
    }

    public String getPriorityClassName() {
        return this.priorityClassName;
    }

    public String getQueue() {
        return this.queue;
    }

    public Duration getRunningEstimate() {
        return this.runningEstimate;
    }

    public String getSchedulerName() {
        return this.schedulerName;
    }

    public Integer getTtlSecondsAfterFinished() {
        return this.ttlSecondsAfterFinished;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasMatchingPolicy(Predicate<LifecyclePolicyBuilder> predicate) {
        for (LifecyclePolicyBuilder item : this.policies) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMatchingTask(Predicate<TaskSpecBuilder> predicate) {
        for (TaskSpecBuilder item : this.tasks) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMatchingVolume(Predicate<VolumeSpecBuilder> predicate) {
        for (VolumeSpecBuilder item : this.volumes) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMaxRetry() {
        return this.maxRetry != null;
    }

    public boolean hasMinAvailable() {
        return this.minAvailable != null;
    }

    public boolean hasMinSuccess() {
        return this.minSuccess != null;
    }

    public boolean hasPlugins() {
        return this.plugins != null;
    }

    public boolean hasPolicies() {
        return this.policies != null && !this.policies.isEmpty();
    }

    public boolean hasPriorityClassName() {
        return this.priorityClassName != null;
    }

    public boolean hasQueue() {
        return this.queue != null;
    }

    public boolean hasRunningEstimate() {
        return this.runningEstimate != null;
    }

    public boolean hasSchedulerName() {
        return this.schedulerName != null;
    }

    public boolean hasTasks() {
        return this.tasks != null && !this.tasks.isEmpty();
    }

    public boolean hasTtlSecondsAfterFinished() {
        return this.ttlSecondsAfterFinished != null;
    }

    public boolean hasVolumes() {
        return this.volumes != null && !this.volumes.isEmpty();
    }

    public int hashCode() {
        return Objects.hash(this.maxRetry, this.minAvailable, this.minSuccess, this.plugins, this.policies, this.priorityClassName, this.queue, this.runningEstimate, this.schedulerName, this.tasks, this.ttlSecondsAfterFinished, this.volumes, this.additionalProperties);
    }

    public A removeAllFromPolicies(Collection<LifecyclePolicy> items) {
        if (this.policies == null) {
            return (A)((Object)this);
        }
        for (LifecyclePolicy item : items) {
            LifecyclePolicyBuilder builder = new LifecyclePolicyBuilder(item);
            this._visitables.get((Object)"policies").remove((Object)builder);
            this.policies.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromTasks(Collection<TaskSpec> items) {
        if (this.tasks == null) {
            return (A)((Object)this);
        }
        for (TaskSpec item : items) {
            TaskSpecBuilder builder = new TaskSpecBuilder(item);
            this._visitables.get((Object)"tasks").remove((Object)builder);
            this.tasks.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromVolumes(Collection<VolumeSpec> items) {
        if (this.volumes == null) {
            return (A)((Object)this);
        }
        for (VolumeSpec item : items) {
            VolumeSpecBuilder builder = new VolumeSpecBuilder(item);
            this._visitables.get((Object)"volumes").remove((Object)builder);
            this.volumes.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromPlugins(String key) {
        if (this.plugins == null) {
            return (A)((Object)this);
        }
        if (key != null && this.plugins != null) {
            this.plugins.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromPlugins(Map<String, List<String>> map) {
        if (this.plugins == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.plugins == null) continue;
                this.plugins.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromPolicies(LifecyclePolicy ... items) {
        if (this.policies == null) {
            return (A)((Object)this);
        }
        for (LifecyclePolicy item : items) {
            LifecyclePolicyBuilder builder = new LifecyclePolicyBuilder(item);
            this._visitables.get((Object)"policies").remove((Object)builder);
            this.policies.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeFromTasks(TaskSpec ... items) {
        if (this.tasks == null) {
            return (A)((Object)this);
        }
        for (TaskSpec item : items) {
            TaskSpecBuilder builder = new TaskSpecBuilder(item);
            this._visitables.get((Object)"tasks").remove((Object)builder);
            this.tasks.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeFromVolumes(VolumeSpec ... items) {
        if (this.volumes == null) {
            return (A)((Object)this);
        }
        for (VolumeSpec item : items) {
            VolumeSpecBuilder builder = new VolumeSpecBuilder(item);
            this._visitables.get((Object)"volumes").remove((Object)builder);
            this.volumes.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromPolicies(Predicate<LifecyclePolicyBuilder> predicate) {
        if (this.policies == null) {
            return (A)((Object)this);
        }
        Iterator<LifecyclePolicyBuilder> each = this.policies.iterator();
        List visitables = this._visitables.get((Object)"policies");
        while (each.hasNext()) {
            LifecyclePolicyBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromTasks(Predicate<TaskSpecBuilder> predicate) {
        if (this.tasks == null) {
            return (A)((Object)this);
        }
        Iterator<TaskSpecBuilder> each = this.tasks.iterator();
        List visitables = this._visitables.get((Object)"tasks");
        while (each.hasNext()) {
            TaskSpecBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromVolumes(Predicate<VolumeSpecBuilder> predicate) {
        if (this.volumes == null) {
            return (A)((Object)this);
        }
        Iterator<VolumeSpecBuilder> each = this.volumes.iterator();
        List visitables = this._visitables.get((Object)"volumes");
        while (each.hasNext()) {
            VolumeSpecBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public PoliciesNested<A> setNewPolicyLike(int index, LifecyclePolicy item) {
        return new PoliciesNested(index, item);
    }

    public TasksNested<A> setNewTaskLike(int index, TaskSpec item) {
        return new TasksNested(index, item);
    }

    public VolumesNested<A> setNewVolumeLike(int index, VolumeSpec item) {
        return new VolumesNested(index, item);
    }

    public A setToPolicies(int index, LifecyclePolicy item) {
        if (this.policies == null) {
            this.policies = new ArrayList();
        }
        LifecyclePolicyBuilder builder = new LifecyclePolicyBuilder(item);
        if (index < 0 || index >= this.policies.size()) {
            this._visitables.get((Object)"policies").add(builder);
            this.policies.add(builder);
        } else {
            this._visitables.get((Object)"policies").add(builder);
            this.policies.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToTasks(int index, TaskSpec item) {
        if (this.tasks == null) {
            this.tasks = new ArrayList();
        }
        TaskSpecBuilder builder = new TaskSpecBuilder(item);
        if (index < 0 || index >= this.tasks.size()) {
            this._visitables.get((Object)"tasks").add(builder);
            this.tasks.add(builder);
        } else {
            this._visitables.get((Object)"tasks").add(builder);
            this.tasks.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToVolumes(int index, VolumeSpec item) {
        if (this.volumes == null) {
            this.volumes = new ArrayList();
        }
        VolumeSpecBuilder builder = new VolumeSpecBuilder(item);
        if (index < 0 || index >= this.volumes.size()) {
            this._visitables.get((Object)"volumes").add(builder);
            this.volumes.add(builder);
        } else {
            this._visitables.get((Object)"volumes").add(builder);
            this.volumes.set(index, builder);
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.maxRetry != null) {
            sb.append("maxRetry:");
            sb.append(this.maxRetry);
            sb.append(",");
        }
        if (this.minAvailable != null) {
            sb.append("minAvailable:");
            sb.append(this.minAvailable);
            sb.append(",");
        }
        if (this.minSuccess != null) {
            sb.append("minSuccess:");
            sb.append(this.minSuccess);
            sb.append(",");
        }
        if (this.plugins != null && !this.plugins.isEmpty()) {
            sb.append("plugins:");
            sb.append(this.plugins);
            sb.append(",");
        }
        if (this.policies != null && !this.policies.isEmpty()) {
            sb.append("policies:");
            sb.append(this.policies);
            sb.append(",");
        }
        if (this.priorityClassName != null) {
            sb.append("priorityClassName:");
            sb.append(this.priorityClassName);
            sb.append(",");
        }
        if (this.queue != null) {
            sb.append("queue:");
            sb.append(this.queue);
            sb.append(",");
        }
        if (this.runningEstimate != null) {
            sb.append("runningEstimate:");
            sb.append(this.runningEstimate);
            sb.append(",");
        }
        if (this.schedulerName != null) {
            sb.append("schedulerName:");
            sb.append(this.schedulerName);
            sb.append(",");
        }
        if (this.tasks != null && !this.tasks.isEmpty()) {
            sb.append("tasks:");
            sb.append(this.tasks);
            sb.append(",");
        }
        if (this.ttlSecondsAfterFinished != null) {
            sb.append("ttlSecondsAfterFinished:");
            sb.append(this.ttlSecondsAfterFinished);
            sb.append(",");
        }
        if (this.volumes != null && !this.volumes.isEmpty()) {
            sb.append("volumes:");
            sb.append(this.volumes);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withMaxRetry(Integer maxRetry) {
        this.maxRetry = maxRetry;
        return (A)((Object)this);
    }

    public A withMinAvailable(Integer minAvailable) {
        this.minAvailable = minAvailable;
        return (A)((Object)this);
    }

    public A withMinSuccess(Integer minSuccess) {
        this.minSuccess = minSuccess;
        return (A)((Object)this);
    }

    public <K, V> A withPlugins(Map<String, List<String>> plugins) {
        this.plugins = plugins == null ? null : new LinkedHashMap<String, List<String>>(plugins);
        return (A)((Object)this);
    }

    public A withPolicies(List<LifecyclePolicy> policies) {
        if (this.policies != null) {
            this._visitables.get((Object)"policies").clear();
        }
        if (policies != null) {
            this.policies = new ArrayList();
            for (LifecyclePolicy item : policies) {
                this.addToPolicies(item);
            }
        } else {
            this.policies = null;
        }
        return (A)((Object)this);
    }

    public A withPolicies(LifecyclePolicy ... policies) {
        if (this.policies != null) {
            this.policies.clear();
            this._visitables.remove((Object)"policies");
        }
        if (policies != null) {
            for (LifecyclePolicy item : policies) {
                this.addToPolicies(item);
            }
        }
        return (A)((Object)this);
    }

    public A withPriorityClassName(String priorityClassName) {
        this.priorityClassName = priorityClassName;
        return (A)((Object)this);
    }

    public A withQueue(String queue) {
        this.queue = queue;
        return (A)((Object)this);
    }

    public A withRunningEstimate(Duration runningEstimate) {
        this.runningEstimate = runningEstimate;
        return (A)((Object)this);
    }

    public A withSchedulerName(String schedulerName) {
        this.schedulerName = schedulerName;
        return (A)((Object)this);
    }

    public A withTasks(List<TaskSpec> tasks) {
        if (this.tasks != null) {
            this._visitables.get((Object)"tasks").clear();
        }
        if (tasks != null) {
            this.tasks = new ArrayList();
            for (TaskSpec item : tasks) {
                this.addToTasks(item);
            }
        } else {
            this.tasks = null;
        }
        return (A)((Object)this);
    }

    public A withTasks(TaskSpec ... tasks) {
        if (this.tasks != null) {
            this.tasks.clear();
            this._visitables.remove((Object)"tasks");
        }
        if (tasks != null) {
            for (TaskSpec item : tasks) {
                this.addToTasks(item);
            }
        }
        return (A)((Object)this);
    }

    public A withTtlSecondsAfterFinished(Integer ttlSecondsAfterFinished) {
        this.ttlSecondsAfterFinished = ttlSecondsAfterFinished;
        return (A)((Object)this);
    }

    public A withVolumes(List<VolumeSpec> volumes) {
        if (this.volumes != null) {
            this._visitables.get((Object)"volumes").clear();
        }
        if (volumes != null) {
            this.volumes = new ArrayList();
            for (VolumeSpec item : volumes) {
                this.addToVolumes(item);
            }
        } else {
            this.volumes = null;
        }
        return (A)((Object)this);
    }

    public A withVolumes(VolumeSpec ... volumes) {
        if (this.volumes != null) {
            this.volumes.clear();
            this._visitables.remove((Object)"volumes");
        }
        if (volumes != null) {
            for (VolumeSpec item : volumes) {
                this.addToVolumes(item);
            }
        }
        return (A)((Object)this);
    }

    public class VolumesNested<N>
    extends VolumeSpecFluent<VolumesNested<N>>
    implements Nested<N> {
        VolumeSpecBuilder builder;
        int index;

        VolumesNested(int index, VolumeSpec item) {
            this.index = index;
            this.builder = new VolumeSpecBuilder(this, item);
        }

        public N and() {
            return (N)JobSpecFluent.this.setToVolumes(this.index, this.builder.build());
        }

        public N endVolume() {
            return this.and();
        }
    }

    public class TasksNested<N>
    extends TaskSpecFluent<TasksNested<N>>
    implements Nested<N> {
        TaskSpecBuilder builder;
        int index;

        TasksNested(int index, TaskSpec item) {
            this.index = index;
            this.builder = new TaskSpecBuilder(this, item);
        }

        public N and() {
            return (N)JobSpecFluent.this.setToTasks(this.index, this.builder.build());
        }

        public N endTask() {
            return this.and();
        }
    }

    public class PoliciesNested<N>
    extends LifecyclePolicyFluent<PoliciesNested<N>>
    implements Nested<N> {
        LifecyclePolicyBuilder builder;
        int index;

        PoliciesNested(int index, LifecyclePolicy item) {
            this.index = index;
            this.builder = new LifecyclePolicyBuilder(this, item);
        }

        public N and() {
            return (N)JobSpecFluent.this.setToPolicies(this.index, this.builder.build());
        }

        public N endPolicy() {
            return this.and();
        }
    }
}

