/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.QueryContext;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.RuntimeReplaceable;
import org.apache.spark.sql.catalyst.expressions.VectorFunctionImplUtils;
import org.apache.spark.sql.catalyst.expressions.VectorNorm$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.objects.StaticInvoke;
import org.apache.spark.sql.catalyst.expressions.objects.StaticInvoke$;
import org.apache.spark.sql.errors.DataTypeErrorsBase;
import org.apache.spark.sql.errors.QueryErrorsBase;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Enumeration;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(vector, degree) - Returns the Lp norm of a float vector using the specified degree.\n    Degree defaults to 2.0 (Euclidean norm) if unspecified. Supported values: 1.0 (L1 norm),\n    2.0 (L2 norm), float('inf') (infinity norm).\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(array(3.0F, 4.0F), 2.0F);\n       5.0\n      > SELECT _FUNC_(array(3.0F, 4.0F), 1.0F);\n       7.0\n      > SELECT _FUNC_(array(3.0F, 4.0F), float('inf'));\n       4.0\n  ", since="4.2.0", group="vector_funcs")
@ScalaSignature(bytes="\u0006\u0005\u0005%g\u0001B\u000f\u001f\u0001.B\u0001b\u0013\u0001\u0003\u0016\u0004%\t\u0001\u0014\u0005\t\u001b\u0002\u0011\t\u0012)A\u0005Y!Aa\n\u0001BK\u0002\u0013\u0005A\n\u0003\u0005P\u0001\tE\t\u0015!\u0003-\u0011\u0015\u0001\u0006\u0001\"\u0001R\u0011\u0015\u0001\u0006\u0001\"\u0001V\u0011\u00159\u0006\u0001\"\u0011Y\u0011!y\u0006\u0001#b\u0001\n\u0003b\u0005\"\u00021\u0001\t\u0003\n\u0007\"\u00026\u0001\t\u0003Z\u0007\"B8\u0001\t#\u0002\bb\u0002<\u0001\u0003\u0003%\ta\u001e\u0005\bu\u0002\t\n\u0011\"\u0001|\u0011!\ti\u0001AI\u0001\n\u0003Y\b\"CA\b\u0001\u0005\u0005I\u0011IA\t\u0011%\t\t\u0003AA\u0001\n\u0003\t\u0019\u0003C\u0005\u0002,\u0001\t\t\u0011\"\u0001\u0002.!I\u0011\u0011\b\u0001\u0002\u0002\u0013\u0005\u00131\b\u0005\n\u0003\u0013\u0002\u0011\u0011!C\u0001\u0003\u0017B\u0011\"!\u0016\u0001\u0003\u0003%\t%a\u0016\t\u0013\u0005m\u0003!!A\u0005B\u0005us!CAA=\u0005\u0005\t\u0012AAB\r!ib$!A\t\u0002\u0005\u0015\u0005B\u0002)\u0018\t\u0003\ti\nC\u0005\u0002 ^\t\t\u0011\"\u0012\u0002\"\"I\u00111U\f\u0002\u0002\u0013\u0005\u0015Q\u0015\u0005\n\u0003W;\u0012\u0011!CA\u0003[C\u0011\"a0\u0018\u0003\u0003%I!!1\u0003\u0015Y+7\r^8s\u001d>\u0014XN\u0003\u0002 A\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\t\t#%\u0001\u0005dCR\fG._:u\u0015\t\u0019C%A\u0002tc2T!!\n\u0014\u0002\u000bM\u0004\u0018M]6\u000b\u0005\u001dB\u0013AB1qC\u000eDWMC\u0001*\u0003\ry'oZ\u0002\u0001'\u0019\u0001A\u0006M\u001a:\u007fA\u0011QFL\u0007\u0002=%\u0011qF\b\u0002\u000b\u000bb\u0004(/Z:tS>t\u0007CA\u00172\u0013\t\u0011dD\u0001\nSk:$\u0018.\\3SKBd\u0017mY3bE2,\u0007C\u0001\u001b8\u001b\u0005)$B\u0001\u001c#\u0003\u0019)'O]8sg&\u0011\u0001(\u000e\u0002\u0010#V,'/_#se>\u00148OQ1tKB\u0011!(P\u0007\u0002w)\tA(A\u0003tG\u0006d\u0017-\u0003\u0002?w\t9\u0001K]8ek\u000e$\bC\u0001!I\u001d\t\teI\u0004\u0002C\u000b6\t1I\u0003\u0002EU\u00051AH]8pizJ\u0011\u0001P\u0005\u0003\u000fn\nq\u0001]1dW\u0006<W-\u0003\u0002J\u0015\na1+\u001a:jC2L'0\u00192mK*\u0011qiO\u0001\u0007m\u0016\u001cGo\u001c:\u0016\u00031\nqA^3di>\u0014\b%\u0001\u0004eK\u001e\u0014X-Z\u0001\bI\u0016<'/Z3!\u0003\u0019a\u0014N\\5u}Q\u0019!k\u0015+\u0011\u00055\u0002\u0001\"B&\u0006\u0001\u0004a\u0003\"\u0002(\u0006\u0001\u0004aCC\u0001*W\u0011\u0015Ye\u00011\u0001-\u0003M\u0019\u0007.Z2l\u0013:\u0004X\u000f\u001e#bi\u0006$\u0016\u0010]3t)\u0005I\u0006C\u0001.^\u001b\u0005Y&B\u0001/!\u0003!\tg.\u00197zg&\u001c\u0018B\u00010\\\u0005=!\u0016\u0010]3DQ\u0016\u001c7NU3tk2$\u0018a\u0003:fa2\f7-Z7f]R\f!\u0002\u001d:fiRLh*Y7f+\u0005\u0011\u0007CA2h\u001d\t!W\r\u0005\u0002Cw%\u0011amO\u0001\u0007!J,G-\u001a4\n\u0005!L'AB*ue&twM\u0003\u0002gw\u0005A1\r[5mIJ,g.F\u0001m!\r\u0001U\u000eL\u0005\u0003]*\u00131aU3r\u0003]9\u0018\u000e\u001e5OK^\u001c\u0005.\u001b7ee\u0016t\u0017J\u001c;fe:\fG\u000e\u0006\u0002Sc\")!o\u0003a\u0001g\u0006Ya.Z<DQ&dGM]3o!\r\u0001E\u000fL\u0005\u0003k*\u0013!\"\u00138eKb,GmU3r\u0003\u0011\u0019w\u000e]=\u0015\u0007IC\u0018\u0010C\u0004L\u0019A\u0005\t\u0019\u0001\u0017\t\u000f9c\u0001\u0013!a\u0001Y\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\nT#\u0001?+\u00051j8&\u0001@\u0011\u0007}\fI!\u0004\u0002\u0002\u0002)!\u00111AA\u0003\u0003%)hn\u00195fG.,GMC\u0002\u0002\bm\n!\"\u00198o_R\fG/[8o\u0013\u0011\tY!!\u0001\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\t\u0019\u0002\u0005\u0003\u0002\u0016\u0005}QBAA\f\u0015\u0011\tI\"a\u0007\u0002\t1\fgn\u001a\u0006\u0003\u0003;\tAA[1wC&\u0019\u0001.a\u0006\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005\u0015\u0002c\u0001\u001e\u0002(%\u0019\u0011\u0011F\u001e\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005=\u0012Q\u0007\t\u0004u\u0005E\u0012bAA\u001aw\t\u0019\u0011I\\=\t\u0013\u0005]\u0012#!AA\u0002\u0005\u0015\u0012a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002>A1\u0011qHA#\u0003_i!!!\u0011\u000b\u0007\u0005\r3(\u0001\u0006d_2dWm\u0019;j_:LA!a\u0012\u0002B\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\ti%a\u0015\u0011\u0007i\ny%C\u0002\u0002Rm\u0012qAQ8pY\u0016\fg\u000eC\u0005\u00028M\t\t\u00111\u0001\u00020\u0005\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\u0011\t\u0019\"!\u0017\t\u0013\u0005]B#!AA\u0002\u0005\u0015\u0012AB3rk\u0006d7\u000f\u0006\u0003\u0002N\u0005}\u0003\"CA\u001c+\u0005\u0005\t\u0019AA\u0018QM\u0001\u00111MA5\u0003W\ny'!\u001d\u0002v\u0005]\u00141PA?!\ri\u0013QM\u0005\u0004\u0003Or\"!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u0003[\n\u0011\u0011\u001d\u0006!A\u0001\u0002sLR+O\u0007~Cc/Z2u_Jd\u0003\u0005Z3he\u0016,\u0017\u0006I\u0017!%\u0016$XO\u001d8tAQDW\r\t'qA9|'/\u001c\u0011pM\u0002\n\u0007E\u001a7pCR\u0004c/Z2u_J\u0004So]5oO\u0002\"\b.\u001a\u0011ta\u0016\u001c\u0017NZ5fI\u0002\"Wm\u001a:fK:R\u0001\u0005\t\u0011!\t\u0016<'/Z3!I\u00164\u0017-\u001e7ug\u0002\"x\u000e\t\u001a/a\u0001BS)^2mS\u0012,\u0017M\u001c\u0011o_Jl\u0017\u0006I5gAUt7\u000f]3dS\u001aLW\r\u001a\u0018!'V\u0004\bo\u001c:uK\u0012\u0004c/\u00197vKNT\u0004%\r\u00181A!b\u0015\u0007\t8pe6LCF\u0003\u0011!A\u0001\u0012d\u0006\r\u0011)\u0019J\u0002cn\u001c:nS1\u0002c\r\\8bi\":\u0013N\u001c4(S\u0001B\u0013N\u001c4j]&$\u0018\u0010\t8pe6LcF\u0003\u0011!\u0003!)\u00070Y7qY\u0016\u001c\u0018EAA:\u0003\u0005U%\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK1se\u0006L\bf\r\u00181\r2\u0002CG\f\u0019GS1\u0002#G\f\u0019GSmR\u0001\u0005\t\u0011!A\u0001\u0002SG\f\u0019\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u0005\u0014(/Y=)g9\u0002d\t\f\u00115]A2\u0015\u0006\f\u00112]A2\u0015f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00118]AR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006&\u0019:sCfD3G\f\u0019GY\u0001\"d\u0006\r$*Y\u00012Gn\\1uQ\u001dJgNZ\u0014*SmR\u0001\u0005\t\u0011!A\u0001\u0002CG\f\u0019\u000bA\u0001\nQa]5oG\u0016\f#!!\u001f\u0002\u000bQr#G\f\u0019\u0002\u000b\u001d\u0014x.\u001e9\"\u0005\u0005}\u0014\u0001\u0004<fGR|'o\u00184v]\u000e\u001c\u0018A\u0003,fGR|'OT8s[B\u0011QfF\n\u0006/\u0005\u001d\u00151\u0013\t\b\u0003\u0013\u000by\t\f\u0017S\u001b\t\tYIC\u0002\u0002\u000en\nqA];oi&lW-\u0003\u0003\u0002\u0012\u0006-%!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oeA!\u0011QSAN\u001b\t\t9J\u0003\u0003\u0002\u001a\u0006m\u0011AA5p\u0013\rI\u0015q\u0013\u000b\u0003\u0003\u0007\u000b\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003'\tQ!\u00199qYf$RAUAT\u0003SCQa\u0013\u000eA\u00021BQA\u0014\u000eA\u00021\nq!\u001e8baBd\u0017\u0010\u0006\u0003\u00020\u0006m\u0006#\u0002\u001e\u00022\u0006U\u0016bAAZw\t1q\n\u001d;j_:\u0004RAOA\\Y1J1!!/<\u0005\u0019!V\u000f\u001d7fe!A\u0011QX\u000e\u0002\u0002\u0003\u0007!+A\u0002yIA\nAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"!a1\u0011\t\u0005U\u0011QY\u0005\u0005\u0003\u000f\f9B\u0001\u0004PE*,7\r\u001e")
public class VectorNorm
extends Expression
implements RuntimeReplaceable,
QueryErrorsBase,
Serializable {
    private Expression replacement;
    private final Expression vector;
    private final Expression degree;
    private Seq<Enumeration.Value> nodePatterns;
    private Expression canonicalized;
    private volatile byte bitmap$0;

    public static Option<Tuple2<Expression, Expression>> unapply(VectorNorm x$0) {
        return VectorNorm$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple2<Expression, Expression>, VectorNorm> tupled() {
        return VectorNorm$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, VectorNorm>> curried() {
        return VectorNorm$.MODULE$.curried();
    }

    @Override
    public String toSQLConfVal(String conf) {
        return QueryErrorsBase.toSQLConfVal$(this, conf);
    }

    @Override
    public String toSQLExpr(Expression e) {
        return QueryErrorsBase.toSQLExpr$(this, e);
    }

    @Override
    public String toSQLValue(Object v, DataType t) {
        return QueryErrorsBase.toSQLValue$(this, v, t);
    }

    @Override
    public String ordinalNumber(int i) {
        return QueryErrorsBase.ordinalNumber$(this, i);
    }

    public String toSQLId(String parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, (String)parts);
    }

    public String toSQLId(Seq<String> parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, parts);
    }

    public String toSQLStmt(String text) {
        return DataTypeErrorsBase.toSQLStmt$((DataTypeErrorsBase)this, (String)text);
    }

    public String toSQLConf(String conf) {
        return DataTypeErrorsBase.toSQLConf$((DataTypeErrorsBase)this, (String)conf);
    }

    public String toSQLType(String text) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (String)text);
    }

    public String toSQLType(AbstractDataType t) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (AbstractDataType)t);
    }

    public String toSQLValue(String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (String)value);
    }

    public String toSQLValue(UTF8String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (UTF8String)value);
    }

    public String toSQLValue(short value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (short)value);
    }

    public String toSQLValue(int value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (int)value);
    }

    public String toSQLValue(long value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (long)value);
    }

    public String toSQLValue(float value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (float)value);
    }

    public String toSQLValue(double value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (double)value);
    }

    public String quoteByDefault(String elem) {
        return DataTypeErrorsBase.quoteByDefault$((DataTypeErrorsBase)this, (String)elem);
    }

    public String getSummary(QueryContext sqlContext) {
        return DataTypeErrorsBase.getSummary$((DataTypeErrorsBase)this, (QueryContext)sqlContext);
    }

    public QueryContext[] getQueryContext(QueryContext context) {
        return DataTypeErrorsBase.getQueryContext$((DataTypeErrorsBase)this, (QueryContext)context);
    }

    public String toDSOption(String option) {
        return DataTypeErrorsBase.toDSOption$((DataTypeErrorsBase)this, (String)option);
    }

    @Override
    public boolean nullable() {
        return RuntimeReplaceable.nullable$(this);
    }

    @Override
    public DataType dataType() {
        return RuntimeReplaceable.dataType$(this);
    }

    @Override
    public final Object eval(InternalRow input) {
        return RuntimeReplaceable.eval$(this, input);
    }

    @Override
    public final InternalRow eval$default$1() {
        return RuntimeReplaceable.eval$default$1$(this);
    }

    @Override
    public final ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return RuntimeReplaceable.doGenCode$(this, ctx, ev);
    }

    @Override
    public Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private Expression canonicalized$lzycompute() {
        VectorNorm vectorNorm = this;
        synchronized (vectorNorm) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.canonicalized = RuntimeReplaceable.canonicalized$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.canonicalized;
    }

    @Override
    public Expression canonicalized() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.canonicalized$lzycompute();
        }
        return this.canonicalized;
    }

    @Override
    public void org$apache$spark$sql$catalyst$expressions$RuntimeReplaceable$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public Expression vector() {
        return this.vector;
    }

    public Expression degree() {
        return this.degree;
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        ArrayType arrayType;
        DataType dataType;
        DataType dataType2;
        Tuple2 tuple2 = new Tuple2((Object)this.vector().dataType(), (Object)this.degree().dataType());
        if (tuple2 != null) {
            ArrayType arrayType2;
            DataType dataType3;
            DataType dataType4 = (DataType)tuple2._1();
            DataType dataType5 = (DataType)tuple2._2();
            if (dataType4 instanceof ArrayType && FloatType$.MODULE$.equals(dataType3 = (arrayType2 = (ArrayType)dataType4).elementType()) && FloatType$.MODULE$.equals(dataType5)) {
                return TypeCheckResult$TypeCheckSuccess$.MODULE$;
            }
        }
        if (tuple2 != null && (dataType2 = (DataType)tuple2._1()) instanceof ArrayType && FloatType$.MODULE$.equals(dataType = (arrayType = (ArrayType)dataType2).elementType())) {
            return new TypeCheckResult.DataTypeMismatch("UNEXPECTED_INPUT_TYPE", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paramIndex"), (Object)this.ordinalNumber(1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"requiredType"), (Object)this.toSQLType((AbstractDataType)FloatType$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputSql"), (Object)this.toSQLExpr(this.degree())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputType"), (Object)this.toSQLType((AbstractDataType)this.degree().dataType()))}))));
        }
        return new TypeCheckResult.DataTypeMismatch("UNEXPECTED_INPUT_TYPE", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paramIndex"), (Object)this.ordinalNumber(0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"requiredType"), (Object)this.toSQLType((AbstractDataType)ArrayType$.MODULE$.apply((DataType)FloatType$.MODULE$))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputSql"), (Object)this.toSQLExpr(this.vector())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputType"), (Object)this.toSQLType((AbstractDataType)this.vector().dataType()))}))));
    }

    private Expression replacement$lzycompute() {
        VectorNorm vectorNorm = this;
        synchronized (vectorNorm) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.replacement = new StaticInvoke(VectorFunctionImplUtils.class, (DataType)FloatType$.MODULE$, "vectorNorm", (Seq<Expression>)new .colon.colon((Object)this.vector(), (List)new .colon.colon((Object)this.degree(), (List)new .colon.colon((Object)Literal$.MODULE$.apply(this.prettyName()), (List)Nil$.MODULE$))), (Seq<AbstractDataType>)new .colon.colon((Object)ArrayType$.MODULE$.apply((DataType)FloatType$.MODULE$), (List)new .colon.colon((Object)FloatType$.MODULE$, (List)new .colon.colon((Object)StringType$.MODULE$, (List)Nil$.MODULE$))), StaticInvoke$.MODULE$.apply$default$6(), StaticInvoke$.MODULE$.apply$default$7(), StaticInvoke$.MODULE$.apply$default$8(), StaticInvoke$.MODULE$.apply$default$9());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.replacement;
    }

    @Override
    public Expression replacement() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.replacement$lzycompute();
        }
        return this.replacement;
    }

    @Override
    public String prettyName() {
        return "vector_norm";
    }

    @Override
    public Seq<Expression> children() {
        return new .colon.colon((Object)this.vector(), (List)new .colon.colon((Object)this.degree(), (List)Nil$.MODULE$));
    }

    @Override
    public VectorNorm withNewChildrenInternal(IndexedSeq<Expression> newChildren) {
        return this.copy((Expression)newChildren.apply(0), (Expression)newChildren.apply(1));
    }

    public VectorNorm copy(Expression vector, Expression degree) {
        return new VectorNorm(vector, degree);
    }

    public Expression copy$default$1() {
        return this.vector();
    }

    public Expression copy$default$2() {
        return this.degree();
    }

    @Override
    public String productPrefix() {
        return "VectorNorm";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.vector();
            }
            case 1: {
                return this.degree();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof VectorNorm;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "vector";
            }
            case 1: {
                return "degree";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof VectorNorm)) return false;
        boolean bl = true;
        if (!bl) return false;
        VectorNorm vectorNorm = (VectorNorm)x$1;
        Expression expression = this.vector();
        Expression expression2 = vectorNorm.vector();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.degree();
        Expression expression4 = vectorNorm.degree();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!vectorNorm.canEqual(this)) return false;
        return true;
    }

    public VectorNorm(Expression vector, Expression degree) {
        this.vector = vector;
        this.degree = degree;
        RuntimeReplaceable.$init$(this);
        DataTypeErrorsBase.$init$((DataTypeErrorsBase)this);
        QueryErrorsBase.$init$(this);
        Statics.releaseFence();
    }

    public VectorNorm(Expression vector) {
        this(vector, Literal$.MODULE$.apply(BoxesRunTime.boxToFloat((float)2.0f)));
    }
}

