/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.aggregate;

import java.io.Serializable;
import org.apache.datasketches.kll.KllDoublesSketch;
import org.apache.datasketches.kll.KllSketch;
import org.apache.datasketches.memory.Memory;
import org.apache.spark.SparkUnsupportedOperationException;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.aggregate.KllSketchAggBase;
import org.apache.spark.sql.catalyst.expressions.aggregate.KllSketchAggDouble$;
import org.apache.spark.sql.catalyst.expressions.aggregate.TypedImperativeAggregate;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.TypeCollection$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple4;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(expr[, k]) - Returns the KllDoublesSketch compact binary representation.\n      The optional k parameter controls the size and accuracy of the sketch (default 200, range 8-65535).\n      Larger k values provide more accurate quantile estimates but result in larger, slower sketches.\n  ", examples="\n    Examples:\n      > SELECT LENGTH(kll_sketch_to_string_double(_FUNC_(col))) > 0 FROM VALUES (CAST(1.0 AS DOUBLE)), (CAST(2.0 AS DOUBLE)), (CAST(3.0 AS DOUBLE)), (CAST(4.0 AS DOUBLE)), (CAST(5.0 AS DOUBLE)) tab(col);\n       true\n      > SELECT LENGTH(kll_sketch_to_string_double(_FUNC_(col, 400))) > 0 FROM VALUES (CAST(1.0 AS DOUBLE)), (CAST(2.0 AS DOUBLE)), (CAST(3.0 AS DOUBLE)), (CAST(4.0 AS DOUBLE)), (CAST(5.0 AS DOUBLE)) tab(col);\n       true\n  ", group="agg_funcs", since="4.1.0")
@ScalaSignature(bytes="\u0006\u0005\tMf\u0001\u0002\u001b6\u0001\u0012C\u0001B\u001b\u0001\u0003\u0016\u0004%\ta\u001b\u0005\t_\u0002\u0011\t\u0012)A\u0005Y\"A\u0001\u000f\u0001BK\u0002\u0013\u0005\u0011\u000f\u0003\u0005v\u0001\tE\t\u0015!\u0003s\u0011!1\bA!f\u0001\n\u0003:\b\u0002C>\u0001\u0005#\u0005\u000b\u0011\u0002=\t\u0011q\u0004!Q3A\u0005B]D\u0001\" \u0001\u0003\u0012\u0003\u0006I\u0001\u001f\u0005\u0006}\u0002!\ta \u0005\u0007}\u0002!\t!a\u0003\t\ry\u0004A\u0011AA\b\u0011\u001d\t)\u0002\u0001C!\u0003/Aq!a\b\u0001\t\u0003\n\t\u0003C\u0004\u0002(\u0001!\t%!\u000b\t\u000f\u0005=\u0002\u0001\"\u0015\u00022!9\u0011Q\b\u0001\u0005B\u0005}\u0002bBA'\u0001\u0011\u0005\u0013q\n\u0005\b\u00033\u0002A\u0011IA.\u0011\u001d\t\u0019\u0007\u0001C!\u0003KBq!a\u001e\u0001\t\u0003\nI\bC\u0004\u0002\b\u0002!\t%!#\t\u000f\u0005-\u0005\u0001\"\u0011\u0002\u000e\"9\u0011q\u0014\u0001\u0005B\u0005\u0005\u0006bBAU\u0001\u0011\u0005\u00131\u0016\u0005\b\u0003k\u0003A\u0011IA\\\u0011\u001d\t9\r\u0001C!\u0003\u0013D\u0011\"a4\u0001\u0003\u0003%\t!!5\t\u0013\u0005m\u0007!%A\u0005\u0002\u0005u\u0007\"CAz\u0001E\u0005I\u0011AA{\u0011%\tI\u0010AI\u0001\n\u0003\tY\u0010C\u0005\u0002\u0000\u0002\t\n\u0011\"\u0001\u0002|\"I!\u0011\u0001\u0001\u0002\u0002\u0013\u0005#1\u0001\u0005\t\u0005'\u0001\u0011\u0011!C\u0001o\"I!Q\u0003\u0001\u0002\u0002\u0013\u0005!q\u0003\u0005\n\u0005;\u0001\u0011\u0011!C!\u0005?A\u0011B!\f\u0001\u0003\u0003%\tAa\f\t\u0013\tM\u0002!!A\u0005B\tU\u0002\"\u0003B\u001d\u0001\u0005\u0005I\u0011\tB\u001e\u000f%\u0011y&NA\u0001\u0012\u0003\u0011\tG\u0002\u00055k\u0005\u0005\t\u0012\u0001B2\u0011\u0019q\b\u0006\"\u0001\u0003|!I!Q\u0010\u0015\u0002\u0002\u0013\u0015#q\u0010\u0005\n\u0005\u0003C\u0013\u0011!CA\u0005\u0007C\u0011B!$)#\u0003%\t!!>\t\u0013\t=\u0005&%A\u0005\u0002\u0005m\b\"\u0003BIQE\u0005I\u0011AA~\u0011%\u0011\u0019\nKA\u0001\n\u0003\u0013)\nC\u0005\u0003$\"\n\n\u0011\"\u0001\u0002v\"I!Q\u0015\u0015\u0012\u0002\u0013\u0005\u00111 \u0005\n\u0005OC\u0013\u0013!C\u0001\u0003wD\u0011B!+)\u0003\u0003%IAa+\u0003%-cGnU6fi\u000eD\u0017iZ4E_V\u0014G.\u001a\u0006\u0003m]\n\u0011\"Y4he\u0016<\u0017\r^3\u000b\u0005aJ\u0014aC3yaJ,7o]5p]NT!AO\u001e\u0002\u0011\r\fG/\u00197zgRT!\u0001P\u001f\u0002\u0007M\fHN\u0003\u0002?\u007f\u0005)1\u000f]1sW*\u0011\u0001)Q\u0001\u0007CB\f7\r[3\u000b\u0003\t\u000b1a\u001c:h\u0007\u0001\u0019b\u0001A#R)bs\u0006c\u0001$H\u00136\tQ'\u0003\u0002Ik\tAB+\u001f9fI&k\u0007/\u001a:bi&4X-Q4he\u0016<\u0017\r^3\u0011\u0005){U\"A&\u000b\u00051k\u0015aA6mY*\u0011ajP\u0001\rI\u0006$\u0018m]6fi\u000eDWm]\u0005\u0003!.\u0013\u0001c\u00137m\t>,(\r\\3t'.,Go\u00195\u0011\u0005\u0019\u0013\u0016BA*6\u0005AYE\u000e\\*lKR\u001c\u0007.Q4h\u0005\u0006\u001cX\r\u0005\u0002V-6\tq'\u0003\u0002Xo\t\tR\t\u001f9fGR\u001c\u0018J\u001c9viRK\b/Z:\u0011\u0005ecV\"\u0001.\u000b\u0003m\u000bQa]2bY\u0006L!!\u0018.\u0003\u000fA\u0013x\u000eZ;diB\u0011ql\u001a\b\u0003A\u0016t!!\u00193\u000e\u0003\tT!aY\"\u0002\rq\u0012xn\u001c;?\u0013\u0005Y\u0016B\u00014[\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001[5\u0003\u0019M+'/[1mSj\f'\r\\3\u000b\u0005\u0019T\u0016!B2iS2$W#\u00017\u0011\u0005Uk\u0017B\u000188\u0005))\u0005\u0010\u001d:fgNLwN\\\u0001\u0007G\"LG\u000e\u001a\u0011\u0002\u000b-,\u0005\u0010\u001d:\u0016\u0003I\u00042!W:m\u0013\t!(L\u0001\u0004PaRLwN\\\u0001\u0007W\u0016C\bO\u001d\u0011\u0002-5,H/\u00192mK\u0006;wMQ;gM\u0016\u0014xJ\u001a4tKR,\u0012\u0001\u001f\t\u00033fL!A\u001f.\u0003\u0007%sG/A\fnkR\f'\r\\3BO\u001e\u0014UO\u001a4fe>3gm]3uA\u0005!\u0012N\u001c9vi\u0006;wMQ;gM\u0016\u0014xJ\u001a4tKR\fQ#\u001b8qkR\fum\u001a\"vM\u001a,'o\u00144gg\u0016$\b%\u0001\u0004=S:LGO\u0010\u000b\u000b\u0003\u0003\t\u0019!!\u0002\u0002\b\u0005%\u0001C\u0001$\u0001\u0011\u0015Q\u0017\u00021\u0001m\u0011\u001d\u0001\u0018\u0002%AA\u0002IDqA^\u0005\u0011\u0002\u0003\u0007\u0001\u0010C\u0004}\u0013A\u0005\t\u0019\u0001=\u0015\t\u0005\u0005\u0011Q\u0002\u0005\u0006U*\u0001\r\u0001\u001c\u000b\u0007\u0003\u0003\t\t\"a\u0005\t\u000b)\\\u0001\u0019\u00017\t\u000bA\\\u0001\u0019\u00017\u0002\u0011\rD\u0017\u000e\u001c3sK:,\"!!\u0007\u0011\t}\u000bY\u0002\\\u0005\u0004\u0003;I'aA*fc\u0006ir/\u001b;i\u001d\u0016<X*\u001e;bE2,\u0017iZ4Ck\u001a4WM](gMN,G\u000f\u0006\u0003\u0002\u0002\u0005\r\u0002BBA\u0013\u001b\u0001\u0007\u00010A\roK^lU\u000f^1cY\u0016\fum\u001a\"vM\u001a,'o\u00144gg\u0016$\u0018aG<ji\"tUm^%oaV$\u0018iZ4Ck\u001a4WM](gMN,G\u000f\u0006\u0003\u0002\u0002\u0005-\u0002BBA\u0017\u001d\u0001\u0007\u00010A\foK^Le\u000e];u\u0003\u001e<')\u001e4gKJ|eMZ:fi\u00069r/\u001b;i\u001d\u0016<8\t[5mIJ,g.\u00138uKJt\u0017\r\u001c\u000b\u0005\u0003\u0003\t\u0019\u0004C\u0004\u00026=\u0001\r!a\u000e\u0002\u00179,wo\u00115jY\u0012\u0014XM\u001c\t\u0005?\u0006eB.C\u0002\u0002<%\u0014!\"\u00138eKb,GmU3r\u0003!!\u0017\r^1UsB,WCAA!!\u0011\t\u0019%!\u0013\u000e\u0005\u0005\u0015#bAA$w\u0005)A/\u001f9fg&!\u00111JA#\u0005!!\u0015\r^1UsB,\u0017AC5oaV$H+\u001f9fgV\u0011\u0011\u0011\u000b\t\u0006?\u0006m\u00111\u000b\t\u0005\u0003\u0007\n)&\u0003\u0003\u0002X\u0005\u0015#\u0001E!cgR\u0014\u0018m\u0019;ECR\fG+\u001f9f\u0003!qW\u000f\u001c7bE2,WCAA/!\rI\u0016qL\u0005\u0004\u0003CR&a\u0002\"p_2,\u0017M\\\u0001\u000baJ,G\u000f^=OC6,WCAA4!\u0011\tI'!\u001d\u000f\t\u0005-\u0014Q\u000e\t\u0003CjK1!a\u001c[\u0003\u0019\u0001&/\u001a3fM&!\u00111OA;\u0005\u0019\u0019FO]5oO*\u0019\u0011q\u000e.\u0002'\rDWmY6J]B,H\u000fR1uCRK\b/Z:\u0015\u0005\u0005m\u0004\u0003BA?\u0003\u0007k!!a \u000b\u0007\u0005\u0005\u0015(\u0001\u0005b]\u0006d\u0017p]5t\u0013\u0011\t))a \u0003\u001fQK\b/Z\"iK\u000e\\'+Z:vYR\fqc\u0019:fCR,\u0017iZ4sK\u001e\fG/[8o\u0005V4g-\u001a:\u0015\u0003%\u000ba!\u001e9eCR,G#B%\u0002\u0010\u0006M\u0005BBAI-\u0001\u0007\u0011*\u0001\u0004tW\u0016$8\r\u001b\u0005\b\u0003+3\u0002\u0019AAL\u0003\u0015Ig\u000e];u!\u0011\tI*a'\u000e\u0003eJ1!!(:\u0005-Ie\u000e^3s]\u0006d'k\\<\u0002\u000b5,'oZ3\u0015\u000b%\u000b\u0019+a*\t\r\u0005\u0015v\u00031\u0001J\u00031)\b\u000fZ1uK\n+hMZ3s\u0011\u0019\t)j\u0006a\u0001\u0013\u0006!QM^1m)\u0011\ti+a-\u0011\u0007e\u000by+C\u0002\u00022j\u00131!\u00118z\u0011\u0019\t\t\n\u0007a\u0001\u0013\u0006I1/\u001a:jC2L'0\u001a\u000b\u0005\u0003s\u000b)\rE\u0003Z\u0003w\u000by,C\u0002\u0002>j\u0013Q!\u0011:sCf\u00042!WAa\u0013\r\t\u0019M\u0017\u0002\u0005\u0005f$X\r\u0003\u0004\u0002\u0012f\u0001\r!S\u0001\fI\u0016\u001cXM]5bY&TX\rF\u0002J\u0003\u0017Dq!!4\u001b\u0001\u0004\tI,\u0001\u0004ck\u001a4WM]\u0001\u0005G>\u0004\u0018\u0010\u0006\u0006\u0002\u0002\u0005M\u0017Q[Al\u00033DqA[\u000e\u0011\u0002\u0003\u0007A\u000eC\u0004q7A\u0005\t\u0019\u0001:\t\u000fY\\\u0002\u0013!a\u0001q\"9Ap\u0007I\u0001\u0002\u0004A\u0018AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003?T3\u0001\\AqW\t\t\u0019\u000f\u0005\u0003\u0002f\u0006=XBAAt\u0015\u0011\tI/a;\u0002\u0013Ut7\r[3dW\u0016$'bAAw5\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005E\u0018q\u001d\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0003oT3A]Aq\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM*\"!!@+\u0007a\f\t/\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001b\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\u0011)\u0001\u0005\u0003\u0003\b\tEQB\u0001B\u0005\u0015\u0011\u0011YA!\u0004\u0002\t1\fgn\u001a\u0006\u0003\u0005\u001f\tAA[1wC&!\u00111\u000fB\u0005\u00031\u0001(o\u001c3vGR\f%/\u001b;z\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!!,\u0003\u001a!A!1\u0004\u0012\u0002\u0002\u0003\u0007\u00010A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0005C\u0001bAa\t\u0003*\u00055VB\u0001B\u0013\u0015\r\u00119CW\u0001\u000bG>dG.Z2uS>t\u0017\u0002\u0002B\u0016\u0005K\u0011\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!\u0011Q\fB\u0019\u0011%\u0011Y\u0002JA\u0001\u0002\u0004\ti+\u0001\nqe>$Wo\u0019;FY\u0016lWM\u001c;OC6,G\u0003\u0002B\u0003\u0005oA\u0001Ba\u0007&\u0003\u0003\u0005\r\u0001_\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005u#Q\b\u0005\n\u000571\u0013\u0011!a\u0001\u0003[C3\u0003\u0001B!\u0005\u000f\u0012IE!\u0014\u0003P\tM#Q\u000bB-\u00057\u00022!\u0016B\"\u0013\r\u0011)e\u000e\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\u0011Y%\u0001B(\u0015\u0001\u0002\u0003\u0005I0G+:\u001bu\fK3yaJ\\F\u0006I6^S\u0001j\u0003EU3ukJt7\u000f\t;iK\u0002ZE\u000e\u001c#pk\ndWm]*lKR\u001c\u0007\u000eI2p[B\f7\r\u001e\u0011cS:\f'/\u001f\u0011sKB\u0014Xm]3oi\u0006$\u0018n\u001c8/\u0015\u0001\u0002\u0003\u0005\t\u0011!)\",\u0007e\u001c9uS>t\u0017\r\u001c\u0011lAA\f'/Y7fi\u0016\u0014\beY8oiJ|Gn\u001d\u0011uQ\u0016\u00043/\u001b>fA\u0005tG\rI1dGV\u0014\u0018mY=!_\u001a\u0004C\u000f[3!g.,Go\u00195!Q\u0011,g-Y;mi\u0002\u0012\u0004\u0007\r\u0017!e\u0006tw-\u001a\u00119[Y*TgM\u001b*])\u0001\u0003\u0005\t\u0011!A1\u000b'oZ3sA-\u0004c/\u00197vKN\u0004\u0003O]8wS\u0012,\u0007%\\8sK\u0002\n7mY;sCR,\u0007%];b]RLG.\u001a\u0011fgRLW.\u0019;fg\u0002\u0012W\u000f\u001e\u0011sKN,H\u000e\u001e\u0011j]\u0002b\u0017M]4fe2\u00023\u000f\\8xKJ\u00043o[3uG\",7O\f\u0006!A\u0005AQ\r_1na2,7/\t\u0002\u0003R\u0005\u0019iI\u0003\u0011!A\u0001*\u00050Y7qY\u0016\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011M\u000b:;E\u000b\u0013\u0015lY2|6o[3uG\"|Fo\\0tiJLgnZ0e_V\u0014G.\u001a\u0015`\rVs5i\u0018\u0015d_2L\u0013&\u000b\u0011?AA\u0002cIU(NAY\u000bE*V#TA!\u001a\u0015i\u0015+)c9\u0002\u0004%Q*!\t>+&\tT#*S1\u0002\u0003fQ!T)\"\u0012d\u0006\r\u0011B'\u0002\"u*\u0016\"M\u000b&JC\u0006\t\u0015D\u0003N#\u0006f\r\u00181A\u0005\u001b\u0006\u0005R(V\u00052+\u0015&\u000b\u0017!Q\r\u000b5\u000b\u0016\u00155]A\u0002\u0013i\u0015\u0011E\u001fV\u0013E*R\u0015*Y\u0001B3)Q*UQUr\u0003\u0007I!TA\u0011{UK\u0011'FS%\u0002C/\u00192)G>d\u0017f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011ueV,'\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000b\t'F\u001d\u001e#\u0006\nK6mY~\u001b8.\u001a;dQ~#xnX:ue&twm\u00183pk\ndW\rK0G+:\u001bu\fK2pY2\u0002C\u0007\r\u0019*S%\u0002c\b\t\u0019!\rJ{U\n\t,B\u0019V+5\u000b\t\u0015D\u0003N#\u0006&\r\u00181A\u0005\u001b\u0006\u0005R(V\u00052+\u0015&\u000b\u0017!Q\r\u000b5\u000b\u0016\u00153]A\u0002\u0013i\u0015\u0011E\u001fV\u0013E*R\u0015*Y\u0001B3)Q*UQMr\u0003\u0007I!TA\u0011{UK\u0011'FS%b\u0003\u0005K\"B'RCCG\f\u0019!\u0003N\u0003CiT+C\u0019\u0016K\u0013\u0006\f\u0011)\u0007\u0006\u001bF\u000bK\u001b/a\u0001\n5\u000b\t#P+\ncU)K\u0015!i\u0006\u0014\u0007fY8mSmR\u0001\u0005\t\u0011!A\u0001\u0002CO];f\u0015\u0001\u0002\u0013!B4s_V\u0004\u0018E\u0001B,\u0003%\twmZ0gk:\u001c7/A\u0003tS:\u001cW-\t\u0002\u0003^\u0005)AGL\u0019/a\u0005\u00112\n\u001c7TW\u0016$8\r[!hO\u0012{WO\u00197f!\t1\u0005fE\u0003)\u0005K\u0012\t\b\u0005\u0006\u0003h\t5DN\u001d=y\u0003\u0003i!A!\u001b\u000b\u0007\t-$,A\u0004sk:$\u0018.\\3\n\t\t=$\u0011\u000e\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:$\u0004\u0003\u0002B:\u0005sj!A!\u001e\u000b\t\t]$QB\u0001\u0003S>L1\u0001\u001bB;)\t\u0011\t'\u0001\u0005u_N#(/\u001b8h)\t\u0011)!A\u0003baBd\u0017\u0010\u0006\u0006\u0002\u0002\t\u0015%q\u0011BE\u0005\u0017CQA[\u0016A\u00021Dq\u0001]\u0016\u0011\u0002\u0003\u0007!\u000fC\u0004wWA\u0005\t\u0019\u0001=\t\u000fq\\\u0003\u0013!a\u0001q\u0006y\u0011\r\u001d9ms\u0012\"WMZ1vYR$#'A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00134\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\"\u0014aB;oCB\u0004H.\u001f\u000b\u0005\u0005/\u0013y\n\u0005\u0003Zg\ne\u0005cB-\u0003\u001c2\u0014\b\u0010_\u0005\u0004\u0005;S&A\u0002+va2,G\u0007C\u0005\u0003\">\n\t\u00111\u0001\u0002\u0002\u0005\u0019\u0001\u0010\n\u0019\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00133\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%g\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIQ\nAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"A!,\u0011\t\t\u001d!qV\u0005\u0005\u0005c\u0013IA\u0001\u0004PE*,7\r\u001e")
public class KllSketchAggDouble
extends TypedImperativeAggregate<KllDoublesSketch>
implements KllSketchAggBase,
ExpectsInputTypes,
Serializable {
    private final Expression child;
    private final Option<Expression> kExpr;
    private final int mutableAggBufferOffset;
    private final int inputAggBufferOffset;
    private int org$apache$spark$sql$catalyst$expressions$aggregate$KllSketchAggBase$$MIN_K;
    private int org$apache$spark$sql$catalyst$expressions$aggregate$KllSketchAggBase$$MAX_K;
    private int org$apache$spark$sql$catalyst$expressions$aggregate$KllSketchAggBase$$DEFAULT_K;
    private int kValue;
    private volatile boolean bitmap$0;

    public static int $lessinit$greater$default$4() {
        return KllSketchAggDouble$.MODULE$.$lessinit$greater$default$4();
    }

    public static int $lessinit$greater$default$3() {
        return KllSketchAggDouble$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<Expression> $lessinit$greater$default$2() {
        return KllSketchAggDouble$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple4<Expression, Option<Expression>, Object, Object>> unapply(KllSketchAggDouble x$0) {
        return KllSketchAggDouble$.MODULE$.unapply(x$0);
    }

    public static int apply$default$4() {
        return KllSketchAggDouble$.MODULE$.apply$default$4();
    }

    public static int apply$default$3() {
        return KllSketchAggDouble$.MODULE$.apply$default$3();
    }

    public static Option<Expression> apply$default$2() {
        return KllSketchAggDouble$.MODULE$.apply$default$2();
    }

    public static Function1<Tuple4<Expression, Option<Expression>, Object, Object>, KllSketchAggDouble> tupled() {
        return KllSketchAggDouble$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Option<Expression>, Function1<Object, Function1<Object, KllSketchAggDouble>>>> curried() {
        return KllSketchAggDouble$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkKInputDataTypes() {
        return KllSketchAggBase.checkKInputDataTypes$(this);
    }

    @Override
    public SparkUnsupportedOperationException unexpectedInputDataTypeError(Expression child) {
        return KllSketchAggBase.unexpectedInputDataTypeError$(this, child);
    }

    @Override
    public int org$apache$spark$sql$catalyst$expressions$aggregate$KllSketchAggBase$$MIN_K() {
        return this.org$apache$spark$sql$catalyst$expressions$aggregate$KllSketchAggBase$$MIN_K;
    }

    @Override
    public int org$apache$spark$sql$catalyst$expressions$aggregate$KllSketchAggBase$$MAX_K() {
        return this.org$apache$spark$sql$catalyst$expressions$aggregate$KllSketchAggBase$$MAX_K;
    }

    @Override
    public int org$apache$spark$sql$catalyst$expressions$aggregate$KllSketchAggBase$$DEFAULT_K() {
        return this.org$apache$spark$sql$catalyst$expressions$aggregate$KllSketchAggBase$$DEFAULT_K;
    }

    private int kValue$lzycompute() {
        KllSketchAggDouble kllSketchAggDouble = this;
        synchronized (kllSketchAggDouble) {
            if (!this.bitmap$0) {
                this.kValue = KllSketchAggBase.kValue$(this);
                this.bitmap$0 = true;
            }
        }
        return this.kValue;
    }

    @Override
    public int kValue() {
        if (!this.bitmap$0) {
            return this.kValue$lzycompute();
        }
        return this.kValue;
    }

    @Override
    public final void org$apache$spark$sql$catalyst$expressions$aggregate$KllSketchAggBase$_setter_$org$apache$spark$sql$catalyst$expressions$aggregate$KllSketchAggBase$$MIN_K_$eq(int x$1) {
        this.org$apache$spark$sql$catalyst$expressions$aggregate$KllSketchAggBase$$MIN_K = x$1;
    }

    @Override
    public final void org$apache$spark$sql$catalyst$expressions$aggregate$KllSketchAggBase$_setter_$org$apache$spark$sql$catalyst$expressions$aggregate$KllSketchAggBase$$MAX_K_$eq(int x$1) {
        this.org$apache$spark$sql$catalyst$expressions$aggregate$KllSketchAggBase$$MAX_K = x$1;
    }

    @Override
    public final void org$apache$spark$sql$catalyst$expressions$aggregate$KllSketchAggBase$_setter_$org$apache$spark$sql$catalyst$expressions$aggregate$KllSketchAggBase$$DEFAULT_K_$eq(int x$1) {
        this.org$apache$spark$sql$catalyst$expressions$aggregate$KllSketchAggBase$$DEFAULT_K = x$1;
    }

    public Expression child() {
        return this.child;
    }

    @Override
    public Option<Expression> kExpr() {
        return this.kExpr;
    }

    @Override
    public int mutableAggBufferOffset() {
        return this.mutableAggBufferOffset;
    }

    @Override
    public int inputAggBufferOffset() {
        return this.inputAggBufferOffset;
    }

    @Override
    public Seq<Expression> children() {
        Expression expression = this.child();
        return (Seq)Option$.MODULE$.option2Iterable(this.kExpr()).toSeq().$plus$colon((Object)expression);
    }

    @Override
    public KllSketchAggDouble withNewMutableAggBufferOffset(int newMutableAggBufferOffset) {
        int x$1 = newMutableAggBufferOffset;
        Expression x$2 = this.copy$default$1();
        Option<Expression> x$3 = this.copy$default$2();
        int x$4 = this.copy$default$4();
        return this.copy(x$2, x$3, x$1, x$4);
    }

    @Override
    public KllSketchAggDouble withNewInputAggBufferOffset(int newInputAggBufferOffset) {
        int x$1 = newInputAggBufferOffset;
        Expression x$2 = this.copy$default$1();
        Option<Expression> x$3 = this.copy$default$2();
        int x$4 = this.copy$default$3();
        return this.copy(x$2, x$3, x$4, x$1);
    }

    @Override
    public KllSketchAggDouble withNewChildrenInternal(IndexedSeq<Expression> newChildren) {
        if (newChildren.length() == 1) {
            return this.copy((Expression)newChildren.apply(0), (Option<Expression>)None$.MODULE$, this.copy$default$3(), this.copy$default$4());
        }
        return this.copy((Expression)newChildren.apply(0), (Option<Expression>)new Some(newChildren.apply(1)), this.copy$default$3(), this.copy$default$4());
    }

    @Override
    public DataType dataType() {
        return BinaryType$.MODULE$;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        .colon.colon baseTypes = new .colon.colon((Object)TypeCollection$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{FloatType$.MODULE$, DoubleType$.MODULE$})), (List)Nil$.MODULE$);
        if (this.kExpr().isDefined()) {
            return (Seq)baseTypes.$colon$plus((Object)IntegerType$.MODULE$);
        }
        return baseTypes;
    }

    @Override
    public boolean nullable() {
        return false;
    }

    @Override
    public String prettyName() {
        return "kll_sketch_agg_double";
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        TypeCheckResult defaultCheck = ExpectsInputTypes.checkInputDataTypes$(this);
        if (defaultCheck.isFailure()) {
            return defaultCheck;
        }
        return this.checkKInputDataTypes();
    }

    @Override
    public KllDoublesSketch createAggregationBuffer() {
        return KllDoublesSketch.newHeapInstance((int)this.kValue());
    }

    @Override
    public KllDoublesSketch update(KllDoublesSketch sketch, InternalRow input) {
        Object v = this.child().eval(input);
        if (v == null) {
            return sketch;
        }
        DataType dataType = this.child().dataType();
        if (DoubleType$.MODULE$.equals(dataType)) {
            sketch.update(BoxesRunTime.unboxToDouble((Object)v));
        } else if (FloatType$.MODULE$.equals(dataType)) {
            sketch.update((double)BoxesRunTime.unboxToFloat((Object)v));
        } else {
            throw this.unexpectedInputDataTypeError(this.child());
        }
        return sketch;
    }

    @Override
    public KllDoublesSketch merge(KllDoublesSketch updateBuffer, KllDoublesSketch input) {
        KllDoublesSketch kllDoublesSketch;
        try {
            updateBuffer.merge((KllSketch)input);
            kllDoublesSketch = updateBuffer;
        }
        catch (Exception exception) {
            throw QueryExecutionErrors$.MODULE$.kllInvalidInputSketchBuffer(this.prettyName(), QueryExecutionErrors$.MODULE$.kllInvalidInputSketchBuffer$default$2());
        }
        return kllDoublesSketch;
    }

    @Override
    public Object eval(KllDoublesSketch sketch) {
        return sketch.toByteArray();
    }

    @Override
    public byte[] serialize(KllDoublesSketch sketch) {
        return sketch.toByteArray();
    }

    @Override
    public KllDoublesSketch deserialize(byte[] buffer) {
        if (ArrayOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.byteArrayOps(buffer))) {
            KllDoublesSketch kllDoublesSketch;
            try {
                kllDoublesSketch = KllDoublesSketch.heapify((Memory)Memory.wrap((byte[])buffer));
            }
            catch (Exception exception) {
                throw QueryExecutionErrors$.MODULE$.kllInvalidInputSketchBuffer(this.prettyName(), QueryExecutionErrors$.MODULE$.kllInvalidInputSketchBuffer$default$2());
            }
            return kllDoublesSketch;
        }
        return this.createAggregationBuffer();
    }

    public KllSketchAggDouble copy(Expression child, Option<Expression> kExpr, int mutableAggBufferOffset, int inputAggBufferOffset) {
        return new KllSketchAggDouble(child, kExpr, mutableAggBufferOffset, inputAggBufferOffset);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public Option<Expression> copy$default$2() {
        return this.kExpr();
    }

    public int copy$default$3() {
        return this.mutableAggBufferOffset();
    }

    public int copy$default$4() {
        return this.inputAggBufferOffset();
    }

    @Override
    public String productPrefix() {
        return "KllSketchAggDouble";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.child();
            }
            case 1: {
                return this.kExpr();
            }
            case 2: {
                return BoxesRunTime.boxToInteger((int)this.mutableAggBufferOffset());
            }
            case 3: {
                return BoxesRunTime.boxToInteger((int)this.inputAggBufferOffset());
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof KllSketchAggDouble;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "child";
            }
            case 1: {
                return "kExpr";
            }
            case 2: {
                return "mutableAggBufferOffset";
            }
            case 3: {
                return "inputAggBufferOffset";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof KllSketchAggDouble)) return false;
        boolean bl = true;
        if (!bl) return false;
        KllSketchAggDouble kllSketchAggDouble = (KllSketchAggDouble)x$1;
        if (this.mutableAggBufferOffset() != kllSketchAggDouble.mutableAggBufferOffset()) return false;
        if (this.inputAggBufferOffset() != kllSketchAggDouble.inputAggBufferOffset()) return false;
        Expression expression = this.child();
        Expression expression2 = kllSketchAggDouble.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Option<Expression> option = this.kExpr();
        Option<Expression> option2 = kllSketchAggDouble.kExpr();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!kllSketchAggDouble.canEqual(this)) return false;
        return true;
    }

    public KllSketchAggDouble(Expression child, Option<Expression> kExpr, int mutableAggBufferOffset, int inputAggBufferOffset) {
        this.child = child;
        this.kExpr = kExpr;
        this.mutableAggBufferOffset = mutableAggBufferOffset;
        this.inputAggBufferOffset = inputAggBufferOffset;
        KllSketchAggBase.$init$(this);
        ExpectsInputTypes.$init$(this);
        Statics.releaseFence();
    }

    public KllSketchAggDouble(Expression child) {
        this(child, (Option<Expression>)None$.MODULE$, 0, 0);
    }

    public KllSketchAggDouble(Expression child, Expression kExpr) {
        this(child, (Option<Expression>)new Some((Object)kExpr), 0, 0);
    }
}

