/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.fido.metadata;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.regex.Pattern;
import lombok.Generated;

public final class AAID {
    private static final Pattern AAID_PATTERN = Pattern.compile("^[0-9a-fA-F]{4}#[0-9a-fA-F]{4}$");
    @JsonValue
    private final String value;

    @JsonCreator
    public AAID(String value) {
        this.value = this.validate(value);
    }

    private String validate(String value) {
        if (AAID_PATTERN.matcher(value).matches()) {
            return value;
        }
        throw new IllegalArgumentException(String.format("Value does not satisfy AAID format: %s", value));
    }

    @Generated
    public String getValue() {
        return this.value;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AAID)) {
            return false;
        }
        AAID other = (AAID)o;
        String this$value = this.getValue();
        String other$value = other.getValue();
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AAID(value=" + this.getValue() + ")";
    }
}

