/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.eventregistry.impl.payload;

import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.flowable.eventregistry.api.FlowableEventInfo;
import org.flowable.eventregistry.api.InboundEventInfoAwarePayloadExtractor;
import org.flowable.eventregistry.api.runtime.EventPayloadInstance;
import org.flowable.eventregistry.impl.runtime.EventPayloadInstanceImpl;
import org.flowable.eventregistry.model.EventModel;
import org.flowable.eventregistry.model.EventPayload;

public class HeadersPayloadExtractor<T>
implements InboundEventInfoAwarePayloadExtractor<T> {
    public Collection<EventPayloadInstance> extractPayload(EventModel eventModel, FlowableEventInfo<T> event) {
        Collection headers = eventModel.getHeaders();
        if (headers.isEmpty()) {
            return Collections.emptyList();
        }
        Map<String, Object> filteredHeaders = this.convertHeaderValues(event, eventModel);
        return headers.stream().filter(headerDefinition -> filteredHeaders.containsKey(headerDefinition.getName())).map(headerDefinition -> new EventPayloadInstanceImpl((EventPayload)headerDefinition, filteredHeaders.get(headerDefinition.getName()))).collect(Collectors.toList());
    }

    protected Map<String, Object> convertHeaderValues(FlowableEventInfo<T> eventInfo, EventModel eventModel) {
        HashMap<String, Object> filteredHeaders = new HashMap<String, Object>();
        if (eventInfo.getHeaders() != null) {
            Map headers = eventInfo.getHeaders();
            for (String headerName : headers.keySet()) {
                EventPayload eventHeaderDef = eventModel.getPayload(headerName);
                if (eventHeaderDef == null || !eventHeaderDef.isHeader()) continue;
                Object headerValueObject = headers.get(headerName);
                if (headerValueObject instanceof byte[]) {
                    byte[] headerValue = (byte[])headers.get(headerName);
                    this.convertBytesHeaderValue(headerName, headerValue, filteredHeaders, eventHeaderDef);
                    continue;
                }
                filteredHeaders.put(headerName, headerValueObject);
            }
        }
        return filteredHeaders;
    }

    protected void convertBytesHeaderValue(String headerName, byte[] headerValue, Map<String, Object> filteredHeaders, EventPayload eventHeaderDef) {
        if ("string".equals(eventHeaderDef.getType())) {
            filteredHeaders.put(headerName, this.convertBytesToString(headerValue));
        } else if ("double".equals(eventHeaderDef.getType())) {
            filteredHeaders.put(headerName, Double.valueOf(this.convertBytesToString(headerValue)));
        } else if ("integer".equals(eventHeaderDef.getType())) {
            filteredHeaders.put(headerName, Integer.valueOf(this.convertBytesToString(headerValue)));
        } else if ("long".equals(eventHeaderDef.getType())) {
            filteredHeaders.put(headerName, Long.valueOf(this.convertBytesToString(headerValue)));
        } else if ("boolean".equals(eventHeaderDef.getType())) {
            filteredHeaders.put(headerName, Boolean.valueOf(this.convertBytesToString(headerValue)));
        } else {
            filteredHeaders.put(headerName, headerValue);
        }
    }

    protected String convertBytesToString(byte[] bytes) {
        return new String(bytes, StandardCharsets.UTF_8);
    }
}

