/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.googleapps;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.apache.v2.ApacheHttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.gson.GsonFactory;
import com.google.api.services.directory.Directory;
import com.google.api.services.licensing.Licensing;
import com.google.auth.Credentials;
import com.google.auth.http.HttpCredentialsAdapter;
import com.google.auth.http.HttpTransportFactory;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.auth.oauth2.UserCredentials;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.tirasa.connid.bundles.googleapps.GoogleAppsCustomSchema;
import net.tirasa.connid.bundles.googleapps.GoogleAppsUtil;
import org.apache.http.HttpHost;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.identityconnectors.common.StringUtil;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.common.security.GuardedString;
import org.identityconnectors.common.security.SecurityUtil;
import org.identityconnectors.framework.common.exceptions.ConfigurationException;
import org.identityconnectors.framework.spi.AbstractConfiguration;
import org.identityconnectors.framework.spi.ConfigurationProperty;
import org.identityconnectors.framework.spi.StatefulConfiguration;

public class GoogleAppsConfiguration
extends AbstractConfiguration
implements StatefulConfiguration {
    private static final Log LOG = Log.getLog(GoogleAppsConfiguration.class);
    private static final JsonFactory JSON_FACTORY = new GsonFactory();
    private static final String APPLICATION_NAME = "ConnId";
    private String domain = null;
    private String clientId;
    private GuardedString clientSecret = null;
    private GuardedString refreshToken = null;
    private GoogleCredentials googleCredentials = null;
    private Directory directory;
    private Licensing licensing;
    private String projection = "basic";
    private String customSchemaJSON;
    private String[] skuIds = new String[0];
    private String productId;
    private boolean removeLicenseOnDisable = false;

    @ConfigurationProperty(order=1, displayMessageKey="domain.display", groupMessageKey="basic.group", helpMessageKey="domain.help", required=true, confidential=false)
    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    @ConfigurationProperty(order=2, displayMessageKey="clientid.display", groupMessageKey="basic.group", helpMessageKey="clientid.help", required=true, confidential=false)
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    @ConfigurationProperty(order=3, displayMessageKey="clientsecret.display", groupMessageKey="basic.group", helpMessageKey="clientsecret.help", required=true, confidential=true)
    public GuardedString getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(GuardedString clientSecret) {
        this.clientSecret = clientSecret;
    }

    @ConfigurationProperty(order=4, displayMessageKey="refreshtoken.display", groupMessageKey="basic.group", helpMessageKey="refreshtoken.help", required=true, confidential=true)
    public GuardedString getRefreshToken() {
        return this.refreshToken;
    }

    public void setRefreshToken(GuardedString refreshToken) {
        this.refreshToken = refreshToken;
    }

    @ConfigurationProperty(order=5, displayMessageKey="search.projection", groupMessageKey="basic.group", helpMessageKey="search.projection.help", required=false, confidential=false)
    public String getProjection() {
        return this.projection;
    }

    public void setProjection(String projection) {
        this.projection = projection;
    }

    @ConfigurationProperty(displayMessageKey="customSchemaJSON.display", helpMessageKey="customSchemaJSON.help", order=6)
    public String getCustomSchemasJSON() {
        return this.customSchemaJSON;
    }

    public void setCustomSchemasJSON(String customAttributesJSON) {
        this.customSchemaJSON = customAttributesJSON;
    }

    @ConfigurationProperty(displayMessageKey="skuIds.display", helpMessageKey="skuIds.help", required=false, order=7)
    public String[] getSkuIds() {
        return this.skuIds;
    }

    public void setSkuIds(String[] skuIds) {
        this.skuIds = skuIds;
    }

    @ConfigurationProperty(displayMessageKey="productId.display", helpMessageKey="productId.help", required=false, order=8)
    public String getProductId() {
        return this.productId;
    }

    public void setProductId(String productId) {
        this.productId = productId;
    }

    @ConfigurationProperty(displayMessageKey="removeLicenseOnDisable.display", helpMessageKey="removeLicenseOnDisable.help", required=false, order=9)
    public boolean getRemoveLicenseOnDisable() {
        return this.removeLicenseOnDisable;
    }

    public void setRemoveLicenseOnDisable(boolean removeLicenseOnDisable) {
        this.removeLicenseOnDisable = removeLicenseOnDisable;
    }

    public void validate() {
        if (StringUtil.isBlank((String)this.domain)) {
            throw new IllegalArgumentException("Domain cannot be null or empty.");
        }
        if (StringUtil.isBlank((String)this.clientId)) {
            throw new IllegalArgumentException("Client Id cannot be null or empty.");
        }
        if (null == this.clientSecret) {
            throw new IllegalArgumentException("Client Secret cannot be null.");
        }
        if (null == this.refreshToken) {
            throw new IllegalArgumentException("Refresh Token cannot be null.");
        }
        if (StringUtil.isNotBlank((String)this.projection) && !"basic".equals(this.projection) && !"full".equals(this.projection) && !"custom".equals(this.projection)) {
            throw new IllegalArgumentException("Projection must be a value among [basic, full, custom]");
        }
        if (StringUtil.isNotBlank((String)this.customSchemaJSON)) {
            try {
                GoogleAppsUtil.MAPPER.readValue(this.customSchemaJSON, (TypeReference)new TypeReference<List<GoogleAppsCustomSchema>>(){});
            }
            catch (IOException e) {
                LOG.error((Throwable)e, "While validating customSchemaJSON", new Object[0]);
                throw new ConfigurationException("'customSchemaJSON' parameter must be a valid JSON.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initGoogleCredentials() {
        GoogleAppsConfiguration googleAppsConfiguration = this;
        synchronized (googleAppsConfiguration) {
            if (null == this.googleCredentials) {
                Proxy.Type proxyType;
                UserCredentials.Builder credentialsBuilder = UserCredentials.newBuilder();
                Optional<String> httpProxyHost = Optional.ofNullable(System.getProperty("http.proxyHost"));
                Optional<String> httpProxyPort = Optional.ofNullable(System.getProperty("http.proxyPort"));
                Optional<String> httpsProxyHost = Optional.ofNullable(System.getProperty("https.proxyHost"));
                Optional<String> httpsProxyPort = Optional.ofNullable(System.getProperty("https.proxyPort"));
                Optional<String> socksProxyHost = Optional.ofNullable(System.getProperty("socksProxyHost"));
                Optional<String> socksProxyPort = Optional.ofNullable(System.getProperty("socksProxyPort"));
                Proxy.Type type = httpProxyHost.isPresent() && httpProxyPort.isPresent() || httpsProxyHost.isPresent() && httpsProxyPort.isPresent() ? Proxy.Type.HTTP : (proxyType = socksProxyHost.isPresent() && socksProxyPort.isPresent() ? Proxy.Type.SOCKS : Proxy.Type.DIRECT);
                if (Proxy.Type.HTTP == proxyType) {
                    final HttpClientBuilder clientBuilder = HttpClientBuilder.create();
                    clientBuilder.useSystemProperties();
                    clientBuilder.setProxy(httpsProxyHost.isPresent() && httpsProxyPort.isPresent() ? new HttpHost(httpsProxyHost.get(), Integer.parseInt(httpsProxyPort.get())) : new HttpHost(httpProxyHost.get(), Integer.parseInt(httpProxyPort.get())));
                    credentialsBuilder.setHttpTransportFactory(new HttpTransportFactory(){

                        public HttpTransport create() {
                            return new ApacheHttpTransport((HttpClient)clientBuilder.build());
                        }
                    });
                }
                credentialsBuilder.setClientId(this.getClientId()).setClientSecret(SecurityUtil.decrypt((GuardedString)this.getClientSecret()));
                this.getRefreshToken().access(chars -> credentialsBuilder.setRefreshToken(new String(chars)));
                UserCredentials userCredentials = credentialsBuilder.build();
                this.googleCredentials = userCredentials.createScoped(Arrays.asList("https://www.googleapis.com/auth/admin.directory.user", "https://www.googleapis.com/auth/admin.directory.user.alias", "https://www.googleapis.com/auth/admin.directory.userschema", "https://www.googleapis.com/auth/admin.directory.orgunit", "https://www.googleapis.com/auth/admin.directory.domain", "https://www.googleapis.com/auth/admin.directory.group", "https://www.googleapis.com/auth/admin.directory.group.member"));
                NetHttpTransport httpTransport = Proxy.Type.DIRECT == proxyType ? new NetHttpTransport() : new NetHttpTransport.Builder().setProxy(new Proxy(proxyType, Proxy.Type.SOCKS == proxyType ? new InetSocketAddress(socksProxyHost.get(), Integer.parseInt(socksProxyHost.get())) : (httpsProxyHost.isPresent() && httpsProxyPort.isPresent() ? new InetSocketAddress(httpsProxyHost.get(), Integer.parseInt(httpsProxyPort.get())) : new InetSocketAddress(httpProxyHost.get(), Integer.parseInt(httpProxyPort.get()))))).build();
                HttpCredentialsAdapter requestInitializer = new HttpCredentialsAdapter((Credentials)this.googleCredentials);
                this.directory = new Directory.Builder((HttpTransport)httpTransport, JSON_FACTORY, (HttpRequestInitializer)requestInitializer).setApplicationName(APPLICATION_NAME).build();
                this.licensing = new Licensing.Builder((HttpTransport)httpTransport, JSON_FACTORY, (HttpRequestInitializer)requestInitializer).setApplicationName(APPLICATION_NAME).build();
            }
        }
    }

    public void test() throws IOException {
        this.initGoogleCredentials();
        this.googleCredentials.refreshIfExpired();
    }

    public void release() {
        this.googleCredentials = null;
    }

    public Directory getDirectory() {
        this.initGoogleCredentials();
        return this.directory;
    }

    public Licensing getLicensing() {
        this.initGoogleCredentials();
        return this.licensing;
    }
}

