/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.validation.validator.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.BaseElement;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.ExclusiveGateway;
import org.flowable.bpmn.model.Process;
import org.flowable.bpmn.model.SequenceFlow;
import org.flowable.validation.ValidationError;
import org.flowable.validation.validator.ProcessLevelValidator;

public class ExclusiveGatewayValidator
extends ProcessLevelValidator {
    @Override
    protected void executeValidation(BpmnModel bpmnModel, Process process, List<ValidationError> errors) {
        List gateways = process.findFlowElementsOfType(ExclusiveGateway.class);
        for (ExclusiveGateway gateway : gateways) {
            this.validateExclusiveGateway(process, gateway, errors);
        }
    }

    public void validateExclusiveGateway(Process process, ExclusiveGateway exclusiveGateway, List<ValidationError> errors) {
        if (exclusiveGateway.getOutgoingFlows().isEmpty()) {
            this.addError(errors, "flowable-exclusive-gateway-no-outgoing-seq-flow", process, (BaseElement)exclusiveGateway, "Exclusive gateway has no outgoing sequence flow");
        } else if (exclusiveGateway.getOutgoingFlows().size() == 1) {
            SequenceFlow sequenceFlow = (SequenceFlow)exclusiveGateway.getOutgoingFlows().get(0);
            if (StringUtils.isNotEmpty((CharSequence)sequenceFlow.getConditionExpression())) {
                this.addError(errors, "flowable-exclusive-gateway-condition-not-allowed-on-single-seq-flow", process, (BaseElement)exclusiveGateway, "Exclusive gateway has only one outgoing sequence flow. This is not allowed to have a condition.");
            }
        } else {
            String defaultSequenceFlow = exclusiveGateway.getDefaultFlow();
            ArrayList<SequenceFlow> flowsWithoutCondition = new ArrayList<SequenceFlow>();
            for (SequenceFlow flow : exclusiveGateway.getOutgoingFlows()) {
                String condition = flow.getConditionExpression();
                boolean isDefaultFlow = flow.getId() != null && flow.getId().equals(defaultSequenceFlow);
                boolean hasCondition = StringUtils.isNotEmpty((CharSequence)condition);
                if (!hasCondition && !isDefaultFlow) {
                    flowsWithoutCondition.add(flow);
                }
                if (!hasCondition || !isDefaultFlow) continue;
                this.addError(errors, "flowable-exclusive-gateway-condition-on-seq-flow", process, (BaseElement)exclusiveGateway, "Default sequenceflow has a condition, which is not allowed");
            }
            if (!flowsWithoutCondition.isEmpty()) {
                this.addWarning(errors, "flowable-exclusive-gateway-seq-flow-without-conditions", process, (BaseElement)exclusiveGateway, "Exclusive gateway has at least one outgoing sequence flow without a condition (which isn't the default one)");
            }
        }
    }
}

