/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.agenda;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.flowable.bpmn.model.FlowNode;
import org.flowable.bpmn.model.Process;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.impl.agenda.AbstractOperation;
import org.flowable.engine.impl.delegate.InactiveActivityBehavior;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.ProcessDefinitionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecuteInactiveBehaviorsOperation
extends AbstractOperation {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExecuteInactiveBehaviorsOperation.class);
    protected Collection<ExecutionEntity> involvedExecutions;

    public ExecuteInactiveBehaviorsOperation(CommandContext commandContext, Collection<ExecutionEntity> executions) {
        super(commandContext, null);
        this.involvedExecutions = executions;
    }

    @Override
    public void run() {
        HashSet<String> handledProcessInstanceIds = null;
        for (ExecutionEntity executionEntity : this.involvedExecutions) {
            String processInstanceId = executionEntity.getProcessInstanceId();
            if (handledProcessInstanceIds != null && handledProcessInstanceIds.contains(processInstanceId)) continue;
            Process process = ProcessDefinitionUtil.getProcess(executionEntity.getProcessDefinitionId());
            ArrayList<String> flowNodeIdsWithInactivatedBehavior = new ArrayList<String>();
            for (FlowNode flowNode : process.findFlowElementsOfType(FlowNode.class)) {
                if (!(flowNode.getBehavior() instanceof InactiveActivityBehavior)) continue;
                flowNodeIdsWithInactivatedBehavior.add(flowNode.getId());
            }
            if (flowNodeIdsWithInactivatedBehavior.size() <= 0) continue;
            Collection<ExecutionEntity> inactiveExecutions = CommandContextUtil.getExecutionEntityManager(this.commandContext).findInactiveExecutionsByProcessInstanceId(processInstanceId);
            for (ExecutionEntity inactiveExecution : inactiveExecutions) {
                if (inactiveExecution.isActive() || !flowNodeIdsWithInactivatedBehavior.contains(inactiveExecution.getActivityId()) || inactiveExecution.isDeleted()) continue;
                FlowNode flowNode = (FlowNode)process.getFlowElement(inactiveExecution.getActivityId(), true);
                InactiveActivityBehavior inactiveActivityBehavior = (InactiveActivityBehavior)flowNode.getBehavior();
                LOGGER.debug("Found InactiveActivityBehavior instance of class {} that can be executed on activity '{}'", inactiveActivityBehavior.getClass(), (Object)flowNode.getId());
                inactiveActivityBehavior.executeInactive(inactiveExecution);
            }
            if (handledProcessInstanceIds == null) {
                handledProcessInstanceIds = new HashSet<String>();
            }
            handledProcessInstanceIds.add(processInstanceId);
        }
    }
}

