/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.x.discovery.strategies;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.curator.x.discovery.ProviderStrategy;
import org.apache.curator.x.discovery.ServiceInstance;
import org.apache.curator.x.discovery.details.InstanceProvider;

public class StickyStrategy<T>
implements ProviderStrategy<T> {
    private final ProviderStrategy<T> masterStrategy;
    private final AtomicReference<ServiceInstance<T>> ourInstance = new AtomicReference<Object>(null);
    private final AtomicInteger instanceNumber = new AtomicInteger(-1);

    public StickyStrategy(ProviderStrategy<T> masterStrategy) {
        this.masterStrategy = masterStrategy;
    }

    @Override
    public ServiceInstance<T> getInstance(InstanceProvider<T> instanceProvider) throws Exception {
        ServiceInstance<T> instance;
        ServiceInstance<T> localOurInstance;
        final List<ServiceInstance<T>> instances = instanceProvider.getInstances();
        if (!instances.contains(localOurInstance = this.ourInstance.get())) {
            this.ourInstance.compareAndSet(localOurInstance, null);
        }
        if (this.ourInstance.get() == null && this.ourInstance.compareAndSet(null, instance = this.masterStrategy.getInstance(new InstanceProvider<T>(){

            @Override
            public List<ServiceInstance<T>> getInstances() throws Exception {
                return instances;
            }
        }))) {
            this.instanceNumber.incrementAndGet();
        }
        return this.ourInstance.get();
    }

    public int getInstanceNumber() {
        return this.instanceNumber.get();
    }
}

