/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup.dictionary;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.runtime.compress.colgroup.dictionary.IDictionary;
import org.apache.sysds.runtime.compress.colgroup.indexes.IColIndex;
import org.apache.sysds.runtime.data.SparseBlock;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;

public class DictLibMatrixMult {
    static final Log LOG = LogFactory.getLog((String)DictLibMatrixMult.class.getName());

    private DictLibMatrixMult() {
    }

    public static void addToUpperTriangle(int nCols, int row, int col, double[] res, double val) {
        if (row == col) {
            int n = row * nCols + col;
            res[n] = res[n] + (val + val);
        } else if (row > col) {
            int n = col * nCols + row;
            res[n] = res[n] + val;
        } else {
            int n = row * nCols + col;
            res[n] = res[n] + val;
        }
    }

    public static void MMDictsWithScaling(IDictionary left, IDictionary right, IColIndex leftRows, IColIndex rightColumns, MatrixBlock result, int[] counts) {
        left.MMDictScaling(right, leftRows, rightColumns, result, counts);
    }

    public static void TSMMDictionaryWithScaling(IDictionary dict, int[] counts, IColIndex rows, IColIndex cols, MatrixBlock ret) {
        dict.TSMMWithScaling(counts, rows, cols, ret);
    }

    public static void MMDicts(IDictionary left, IDictionary right, IColIndex rowsLeft, IColIndex colsRight, MatrixBlock result) {
        left.MMDict(right, rowsLeft, colsRight, result);
    }

    public static void TSMMToUpperTriangle(IDictionary left, IDictionary right, IColIndex rowsLeft, IColIndex colsRight, MatrixBlock result) {
        left.TSMMToUpperTriangle(right, rowsLeft, colsRight, result);
    }

    public static void TSMMToUpperTriangleScaling(IDictionary left, IDictionary right, IColIndex rowsLeft, IColIndex colsRight, int[] scale, MatrixBlock result) {
        left.TSMMToUpperTriangleScaling(left, rowsLeft, colsRight, scale, result);
    }

    protected static void TSMMDictsDenseWithScaling(double[] dv, IColIndex rowsLeft, IColIndex colsRight, int[] scaling, MatrixBlock result) {
        int commonDim = Math.min(dv.length / rowsLeft.size(), dv.length / colsRight.size());
        int resCols = result.getNumColumns();
        double[] resV = result.getDenseBlockValues();
        for (int k = 0; k < commonDim; ++k) {
            int offL = k * rowsLeft.size();
            int offR = k * colsRight.size();
            int scale = scaling[k];
            for (int i = 0; i < rowsLeft.size(); ++i) {
                int offOut = rowsLeft.get(i) * resCols;
                double vl = dv[offL + i] * (double)scale;
                if (vl == 0.0) continue;
                for (int j = 0; j < colsRight.size(); ++j) {
                    int n = offOut + colsRight.get(j);
                    resV[n] = resV[n] + vl * dv[offR + j];
                }
            }
        }
    }

    protected static void TSMMDictsSparseWithScaling(SparseBlock sb, IColIndex rowsLeft, IColIndex colsRight, int[] scaling, MatrixBlock result) {
        int commonDim = sb.numRows();
        int resCols = result.getNumColumns();
        double[] resV = result.getDenseBlockValues();
        for (int i = 0; i < commonDim; ++i) {
            if (sb.isEmpty(i)) continue;
            int apos = sb.pos(i);
            int alen = sb.size(i) + apos;
            int[] aix = sb.indexes(i);
            double[] avals = sb.values(i);
            int scale = scaling[i];
            for (int k = apos; k < alen; ++k) {
                double v = avals[k] * (double)scale;
                int offOut = rowsLeft.get(aix[k]) * resCols;
                for (int j = apos; j < alen; ++j) {
                    int n = offOut + colsRight.get(aix[j]);
                    resV[n] = resV[n] + v * avals[j];
                }
            }
        }
    }

    protected static void MMDictsDenseDense(double[] left, double[] right, IColIndex rowsLeft, IColIndex colsRight, MatrixBlock result) {
        int leftSide = rowsLeft.size();
        int rightSide = colsRight.size();
        int commonDim = Math.min(left.length / leftSide, right.length / rightSide);
        int resCols = result.getNumColumns();
        double[] resV = result.getDenseBlockValues();
        for (int k = 0; k < commonDim; ++k) {
            int offL = k * leftSide;
            int offR = k * rightSide;
            for (int i = 0; i < leftSide; ++i) {
                int offOut = rowsLeft.get(i) * resCols;
                double vl = left[offL + i];
                if (vl == 0.0) continue;
                for (int j = 0; j < rightSide; ++j) {
                    int n = offOut + colsRight.get(j);
                    resV[n] = resV[n] + vl * right[offR + j];
                }
            }
        }
    }

    protected static void MMDictsScalingDenseDense(double[] left, double[] right, IColIndex rowsLeft, IColIndex colsRight, MatrixBlock result, int[] scaling) {
        int leftSide = rowsLeft.size();
        int rightSide = colsRight.size();
        int commonDim = Math.min(left.length / leftSide, right.length / rightSide);
        int resCols = result.getNumColumns();
        double[] resV = result.getDenseBlockValues();
        for (int k = 0; k < commonDim; ++k) {
            int offL = k * leftSide;
            int offR = k * rightSide;
            int s = scaling[k];
            for (int i = 0; i < leftSide; ++i) {
                int offOut = rowsLeft.get(i) * resCols;
                double vl = left[offL + i] * (double)s;
                if (vl == 0.0) continue;
                for (int j = 0; j < rightSide; ++j) {
                    int n = offOut + colsRight.get(j);
                    resV[n] = resV[n] + vl * right[offR + j];
                }
            }
        }
    }

    protected static void MMDictsSparseDense(SparseBlock left, double[] right, IColIndex rowsLeft, IColIndex colsRight, MatrixBlock result) {
        double[] resV = result.getDenseBlockValues();
        int commonDim = Math.min(left.numRows(), right.length / colsRight.size());
        for (int i = 0; i < commonDim; ++i) {
            if (left.isEmpty(i)) continue;
            int apos = left.pos(i);
            int alen = left.size(i) + apos;
            int[] aix = left.indexes(i);
            double[] leftVals = left.values(i);
            int offRight = i * colsRight.size();
            for (int k = apos; k < alen; ++k) {
                int offOut = rowsLeft.get(aix[k]) * result.getNumColumns();
                double v = leftVals[k];
                for (int j = 0; j < colsRight.size(); ++j) {
                    int n = offOut + colsRight.get(j);
                    resV[n] = resV[n] + v * right[offRight + j];
                }
            }
        }
    }

    protected static void MMDictsScalingSparseDense(SparseBlock left, double[] right, IColIndex rowsLeft, IColIndex colsRight, MatrixBlock result, int[] scaling) {
        double[] resV = result.getDenseBlockValues();
        int commonDim = Math.min(left.numRows(), right.length / colsRight.size());
        for (int i = 0; i < commonDim; ++i) {
            if (left.isEmpty(i)) continue;
            int apos = left.pos(i);
            int alen = left.size(i) + apos;
            int[] aix = left.indexes(i);
            double[] leftVals = left.values(i);
            int offRight = i * colsRight.size();
            int s = scaling[i];
            for (int k = apos; k < alen; ++k) {
                int offOut = rowsLeft.get(aix[k]) * result.getNumColumns();
                double v = leftVals[k] * (double)s;
                for (int j = 0; j < colsRight.size(); ++j) {
                    int n = offOut + colsRight.get(j);
                    resV[n] = resV[n] + v * right[offRight + j];
                }
            }
        }
    }

    protected static void MMDictsDenseSparse(double[] left, SparseBlock right, IColIndex rowsLeft, IColIndex colsRight, MatrixBlock result) {
        double[] resV = result.getDenseBlockValues();
        int leftSize = rowsLeft.size();
        int commonDim = Math.min(left.length / leftSize, right.numRows());
        for (int i = 0; i < commonDim; ++i) {
            if (right.isEmpty(i)) continue;
            int apos = right.pos(i);
            int alen = right.size(i) + apos;
            int[] aix = right.indexes(i);
            double[] rightVals = right.values(i);
            int offLeft = i * leftSize;
            for (int j = 0; j < leftSize; ++j) {
                int offOut = rowsLeft.get(j) * result.getNumColumns();
                double v = left[offLeft + j];
                if (v == 0.0) continue;
                for (int k = apos; k < alen; ++k) {
                    int n = offOut + colsRight.get(aix[k]);
                    resV[n] = resV[n] + v * rightVals[k];
                }
            }
        }
    }

    protected static void MMDictsScalingDenseSparse(double[] left, SparseBlock right, IColIndex rowsLeft, IColIndex colsRight, MatrixBlock result, int[] scaling) {
        double[] resV = result.getDenseBlockValues();
        int leftSize = rowsLeft.size();
        int commonDim = Math.min(left.length / leftSize, right.numRows());
        for (int i = 0; i < commonDim; ++i) {
            if (right.isEmpty(i)) continue;
            int apos = right.pos(i);
            int alen = right.size(i) + apos;
            int[] aix = right.indexes(i);
            double[] rightVals = right.values(i);
            int offLeft = i * leftSize;
            int s = scaling[i];
            for (int j = 0; j < leftSize; ++j) {
                int offOut = rowsLeft.get(j) * result.getNumColumns();
                double v = left[offLeft + j] * (double)s;
                if (v == 0.0) continue;
                for (int k = apos; k < alen; ++k) {
                    int n = offOut + colsRight.get(aix[k]);
                    resV[n] = resV[n] + v * rightVals[k];
                }
            }
        }
    }

    protected static void MMDictsSparseSparse(SparseBlock left, SparseBlock right, IColIndex rowsLeft, IColIndex colsRight, MatrixBlock result) {
        int commonDim = Math.min(left.numRows(), right.numRows());
        double[] resV = result.getDenseBlockValues();
        int resCols = result.getNumColumns();
        for (int i = 0; i < commonDim; ++i) {
            if (left.isEmpty(i) || right.isEmpty(i)) continue;
            int leftAPos = left.pos(i);
            int leftAlen = left.size(i) + leftAPos;
            int[] leftAix = left.indexes(i);
            double[] leftVals = left.values(i);
            int rightAPos = right.pos(i);
            int rightAlen = right.size(i) + rightAPos;
            int[] rightAix = right.indexes(i);
            double[] rightVals = right.values(i);
            for (int k = leftAPos; k < leftAlen; ++k) {
                int offOut = rowsLeft.get(leftAix[k]) * resCols;
                double v = leftVals[k];
                for (int j = rightAPos; j < rightAlen; ++j) {
                    int n = offOut + colsRight.get(rightAix[j]);
                    resV[n] = resV[n] + v * rightVals[j];
                }
            }
        }
    }

    protected static void MMDictsScalingSparseSparse(SparseBlock left, SparseBlock right, IColIndex rowsLeft, IColIndex colsRight, MatrixBlock result, int[] scaling) {
        int commonDim = Math.min(left.numRows(), right.numRows());
        double[] resV = result.getDenseBlockValues();
        int resCols = result.getNumColumns();
        for (int i = 0; i < commonDim; ++i) {
            if (left.isEmpty(i) || right.isEmpty(i)) continue;
            int leftAPos = left.pos(i);
            int leftAlen = left.size(i) + leftAPos;
            int[] leftAix = left.indexes(i);
            double[] leftVals = left.values(i);
            int rightAPos = right.pos(i);
            int rightAlen = right.size(i) + rightAPos;
            int[] rightAix = right.indexes(i);
            double[] rightVals = right.values(i);
            int s = scaling[i];
            for (int k = leftAPos; k < leftAlen; ++k) {
                int offOut = rowsLeft.get(leftAix[k]) * resCols;
                double v = leftVals[k] * (double)s;
                for (int j = rightAPos; j < rightAlen; ++j) {
                    int n = offOut + colsRight.get(rightAix[j]);
                    resV[n] = resV[n] + v * rightVals[j];
                }
            }
        }
    }

    protected static void MMToUpperTriangleSparseSparse(SparseBlock left, SparseBlock right, IColIndex rowsLeft, IColIndex colsRight, MatrixBlock result) {
        int commonDim = Math.min(left.numRows(), right.numRows());
        int resCols = result.getNumColumns();
        double[] resV = result.getDenseBlockValues();
        for (int i = 0; i < commonDim; ++i) {
            if (left.isEmpty(i) || right.isEmpty(i)) continue;
            int leftAPos = left.pos(i);
            int leftAlen = left.size(i) + leftAPos;
            int[] leftAix = left.indexes(i);
            double[] leftVals = left.values(i);
            int rightAPos = right.pos(i);
            int rightAlen = right.size(i) + rightAPos;
            int[] rightAix = right.indexes(i);
            double[] rightVals = right.values(i);
            for (int k = leftAPos; k < leftAlen; ++k) {
                int rowOut = rowsLeft.get(leftAix[k]);
                double vl = leftVals[k];
                for (int j = rightAPos; j < rightAlen; ++j) {
                    double vr = rightVals[j];
                    int colOut = colsRight.get(rightAix[j]);
                    DictLibMatrixMult.addToUpperTriangle(resCols, rowOut, colOut, resV, vl * vr);
                }
            }
        }
    }

    protected static void MMToUpperTriangleDenseSparse(double[] left, SparseBlock right, IColIndex rowsLeft, IColIndex colsRight, MatrixBlock result) {
        double[] resV = result.getDenseBlockValues();
        int commonDim = Math.min(left.length / rowsLeft.size(), right.numRows());
        int resCols = result.getNumColumns();
        for (int i = 0; i < commonDim; ++i) {
            if (right.isEmpty(i)) continue;
            int apos = right.pos(i);
            int alen = right.size(i) + apos;
            int[] aix = right.indexes(i);
            double[] rightVals = right.values(i);
            int offLeft = i * rowsLeft.size();
            for (int j = 0; j < rowsLeft.size(); ++j) {
                int rowOut = rowsLeft.get(j);
                double vl = left[offLeft + j];
                if (vl == 0.0) continue;
                for (int k = apos; k < alen; ++k) {
                    double vr = rightVals[k];
                    int colOut = colsRight.get(aix[k]);
                    DictLibMatrixMult.addToUpperTriangle(resCols, rowOut, colOut, resV, vl * vr);
                }
            }
        }
    }

    protected static void MMToUpperTriangleSparseDense(SparseBlock left, double[] right, IColIndex rowsLeft, IColIndex colsRight, MatrixBlock result) {
        int loc = DictLibMatrixMult.location(rowsLeft, colsRight);
        if (loc < 0) {
            DictLibMatrixMult.MMToUpperTriangleSparseDenseAllUpperTriangle(left, right, rowsLeft, colsRight, result);
        } else if (loc > 0) {
            DictLibMatrixMult.MMToUpperTriangleSparseDenseAllLowerTriangle(left, right, rowsLeft, colsRight, result);
        } else {
            DictLibMatrixMult.MMToUpperTriangleSparseDenseDiagonal(left, right, rowsLeft, colsRight, result);
        }
    }

    protected static void MMToUpperTriangleSparseDenseAllUpperTriangle(SparseBlock left, double[] right, IColIndex rowsLeft, IColIndex colsRight, MatrixBlock result) {
        double[] resV = result.getDenseBlockValues();
        int commonDim = Math.min(left.numRows(), right.length / colsRight.size());
        int resCols = result.getNumColumns();
        for (int i = 0; i < commonDim; ++i) {
            if (left.isEmpty(i)) continue;
            int apos = left.pos(i);
            int alen = left.size(i) + apos;
            int[] aix = left.indexes(i);
            double[] leftVals = left.values(i);
            int offRight = i * colsRight.size();
            for (int k = apos; k < alen; ++k) {
                int rowOut = rowsLeft.get(aix[k]);
                double vl = leftVals[k];
                for (int j = 0; j < colsRight.size(); ++j) {
                    int n = colsRight.get(j) * resCols + rowOut;
                    resV[n] = resV[n] + vl * right[offRight + j];
                }
            }
        }
    }

    protected static void MMToUpperTriangleSparseDenseAllLowerTriangle(SparseBlock left, double[] right, IColIndex rowsLeft, IColIndex colsRight, MatrixBlock result) {
        double[] resV = result.getDenseBlockValues();
        int commonDim = Math.min(left.numRows(), right.length / colsRight.size());
        int resCols = result.getNumColumns();
        for (int i = 0; i < commonDim; ++i) {
            if (left.isEmpty(i)) continue;
            int apos = left.pos(i);
            int alen = left.size(i) + apos;
            int[] aix = left.indexes(i);
            double[] leftVals = left.values(i);
            int offRight = i * colsRight.size();
            for (int k = apos; k < alen; ++k) {
                int rowOut = rowsLeft.get(aix[k]) * resCols;
                double vl = leftVals[k];
                for (int j = 0; j < colsRight.size(); ++j) {
                    int n = colsRight.get(j) + rowOut;
                    resV[n] = resV[n] + vl * right[offRight + j];
                }
            }
        }
    }

    protected static void MMToUpperTriangleSparseDenseDiagonal(SparseBlock left, double[] right, IColIndex rowsLeft, IColIndex colsRight, MatrixBlock result) {
        double[] resV = result.getDenseBlockValues();
        int commonDim = Math.min(left.numRows(), right.length / colsRight.size());
        int resCols = result.getNumColumns();
        for (int i = 0; i < commonDim; ++i) {
            if (left.isEmpty(i)) continue;
            int apos = left.pos(i);
            int alen = left.size(i) + apos;
            int[] aix = left.indexes(i);
            double[] leftVals = left.values(i);
            int offRight = i * colsRight.size();
            for (int k = apos; k < alen; ++k) {
                int rowOut = rowsLeft.get(aix[k]);
                double vl = leftVals[k];
                for (int j = 0; j < colsRight.size(); ++j) {
                    double vr = right[offRight + j];
                    int colOut = colsRight.get(j);
                    DictLibMatrixMult.addToUpperTriangle(resCols, rowOut, colOut, resV, vl * vr);
                }
            }
        }
    }

    protected static void MMToUpperTriangleDenseDense(double[] left, double[] right, IColIndex rowsLeft, IColIndex colsRight, MatrixBlock result) {
        int loc = DictLibMatrixMult.location(rowsLeft, colsRight);
        if (loc < 0) {
            DictLibMatrixMult.MMToUpperTriangleDenseDenseAllUpperTriangle(left, right, rowsLeft, colsRight, result);
        } else if (loc > 0) {
            DictLibMatrixMult.MMToUpperTriangleDenseDenseAllLowerTriangle(left, right, rowsLeft, colsRight, result);
        } else {
            DictLibMatrixMult.MMToUpperTriangleDenseDenseDiagonal(left, right, rowsLeft, colsRight, result);
        }
    }

    protected static void MMToUpperTriangleDenseDenseAllUpperTriangle(double[] left, double[] right, IColIndex rowsLeft, IColIndex colsRight, MatrixBlock result) {
        int lSize = rowsLeft.size();
        int rSize = colsRight.size();
        int commonDim = Math.min(left.length / lSize, right.length / rSize);
        int resCols = result.getNumColumns();
        double[] resV = result.getDenseBlockValues();
        for (int i = 0; i < lSize; ++i) {
            DictLibMatrixMult.MMToUpperTriangleDenseDenseAllUpperTriangleRow(left, right, rowsLeft.get(i), colsRight, commonDim, lSize, rSize, i, resV, resCols);
        }
    }

    protected static void MMToUpperTriangleDenseDenseAllUpperTriangleRow(double[] left, double[] right, int rowOut, IColIndex colsRight, int commonDim, int lSize, int rSize, int i, double[] resV, int resCols) {
        for (int k = 0; k < commonDim; ++k) {
            int offL = k * lSize;
            double vl = left[offL + i];
            if (vl == 0.0) continue;
            int offR = k * rSize;
            for (int j = 0; j < rSize; ++j) {
                int n = colsRight.get(j) * resCols + rowOut;
                resV[n] = resV[n] + vl * right[offR + j];
            }
        }
    }

    protected static void MMToUpperTriangleDenseDenseAllLowerTriangle(double[] left, double[] right, IColIndex rowsLeft, IColIndex colsRight, MatrixBlock result) {
        int commonDim = Math.min(left.length / rowsLeft.size(), right.length / colsRight.size());
        int resCols = result.getNumColumns();
        double[] resV = result.getDenseBlockValues();
        for (int k = 0; k < commonDim; ++k) {
            int offL = k * rowsLeft.size();
            int offR = k * colsRight.size();
            for (int i = 0; i < rowsLeft.size(); ++i) {
                int rowOut = rowsLeft.get(i) * resCols;
                double vl = left[offL + i];
                for (int j = 0; j < colsRight.size(); ++j) {
                    int n = colsRight.get(j) + rowOut;
                    resV[n] = resV[n] + vl * right[offR + j];
                }
            }
        }
    }

    protected static void MMToUpperTriangleDenseDenseDiagonal(double[] left, double[] right, IColIndex rowsLeft, IColIndex colsRight, MatrixBlock result) {
        int commonDim = Math.min(left.length / rowsLeft.size(), right.length / colsRight.size());
        int resCols = result.getNumColumns();
        double[] resV = result.getDenseBlockValues();
        for (int k = 0; k < commonDim; ++k) {
            int offL = k * rowsLeft.size();
            int offR = k * colsRight.size();
            for (int i = 0; i < rowsLeft.size(); ++i) {
                int rowOut = rowsLeft.get(i);
                double vl = left[offL + i];
                for (int j = 0; j < colsRight.size(); ++j) {
                    double vr = right[offR + j];
                    int colOut = colsRight.get(j);
                    DictLibMatrixMult.addToUpperTriangle(resCols, rowOut, colOut, resV, vl * vr);
                }
            }
        }
    }

    protected static void TSMMToUpperTriangleSparseSparseScaling(SparseBlock left, SparseBlock right, IColIndex rowsLeft, IColIndex colsRight, int[] scale, MatrixBlock result) {
        int commonDim = Math.min(left.numRows(), right.numRows());
        int resCols = result.getNumColumns();
        double[] resV = result.getDenseBlockValues();
        for (int i = 0; i < commonDim; ++i) {
            if (left.isEmpty(i) || right.isEmpty(i)) continue;
            int leftAPos = left.pos(i);
            int leftAlen = left.size(i) + leftAPos;
            int[] leftAix = left.indexes(i);
            double[] leftVals = left.values(i);
            int rightAPos = right.pos(i);
            int rightAlen = right.size(i) + rightAPos;
            int[] rightAix = right.indexes(i);
            double[] rightVals = right.values(i);
            double sv = scale[i];
            for (int k = leftAPos; k < leftAlen; ++k) {
                int rowOut = rowsLeft.get(leftAix[k]);
                double vl = leftVals[k] * sv;
                for (int j = rightAPos; j < rightAlen; ++j) {
                    double vr = rightVals[j];
                    int colOut = colsRight.get(rightAix[j]);
                    DictLibMatrixMult.addToUpperTriangle(resCols, rowOut, colOut, resV, vl * vr);
                }
            }
        }
    }

    protected static void TSMMToUpperTriangleDenseSparseScaling(double[] left, SparseBlock right, IColIndex rowsLeft, IColIndex colsRight, int[] scale, MatrixBlock result) {
        double[] resV = result.getDenseBlockValues();
        int commonDim = Math.min(left.length / rowsLeft.size(), right.numRows());
        int resCols = result.getNumColumns();
        for (int i = 0; i < commonDim; ++i) {
            if (right.isEmpty(i)) continue;
            int apos = right.pos(i);
            int alen = right.size(i) + apos;
            int[] aix = right.indexes(i);
            double[] rightVals = right.values(i);
            int offLeft = i * rowsLeft.size();
            double sv = scale[i];
            for (int j = 0; j < rowsLeft.size(); ++j) {
                int rowOut = rowsLeft.get(j);
                double vl = left[offLeft + j] * sv;
                if (vl == 0.0) continue;
                for (int k = apos; k < alen; ++k) {
                    double vr = rightVals[k];
                    int colOut = colsRight.get(aix[k]);
                    DictLibMatrixMult.addToUpperTriangle(resCols, rowOut, colOut, resV, vl * vr);
                }
            }
        }
    }

    protected static void TSMMToUpperTriangleSparseDenseScaling(SparseBlock left, double[] right, IColIndex rowsLeft, IColIndex colsRight, int[] scale, MatrixBlock result) {
        double[] resV = result.getDenseBlockValues();
        int commonDim = Math.min(left.numRows(), right.length / colsRight.size());
        int resCols = result.getNumColumns();
        for (int i = 0; i < commonDim; ++i) {
            if (left.isEmpty(i)) continue;
            int apos = left.pos(i);
            int alen = left.size(i) + apos;
            int[] aix = left.indexes(i);
            double[] leftVals = left.values(i);
            int offRight = i * colsRight.size();
            double sv = scale[i];
            for (int k = apos; k < alen; ++k) {
                int rowOut = rowsLeft.get(aix[k]);
                double vl = leftVals[k] * sv;
                for (int j = 0; j < colsRight.size(); ++j) {
                    double vr = right[offRight + j];
                    int colOut = colsRight.get(j);
                    DictLibMatrixMult.addToUpperTriangle(resCols, rowOut, colOut, resV, vl * vr);
                }
            }
        }
    }

    protected static void TSMMToUpperTriangleDenseDenseScaling(double[] left, double[] right, IColIndex rowsLeft, IColIndex colsRight, int[] scale, MatrixBlock result) {
        int commonDim = Math.min(left.length / rowsLeft.size(), right.length / colsRight.size());
        int resCols = result.getNumColumns();
        double[] resV = result.getDenseBlockValues();
        for (int k = 0; k < commonDim; ++k) {
            int offL = k * rowsLeft.size();
            int offR = k * colsRight.size();
            int sv = scale[k];
            for (int i = 0; i < rowsLeft.size(); ++i) {
                int rowOut = rowsLeft.get(i);
                double vl = left[offL + i] * (double)sv;
                if (vl == 0.0) continue;
                for (int j = 0; j < colsRight.size(); ++j) {
                    double vr = right[offR + j];
                    int colOut = colsRight.get(j);
                    DictLibMatrixMult.addToUpperTriangle(resCols, rowOut, colOut, resV, vl * vr);
                }
            }
        }
    }

    private static int location(IColIndex leftRows, IColIndex rightColumns) {
        int firstRow = leftRows.get(0);
        int firstCol = rightColumns.get(0);
        int lastRow = leftRows.get(leftRows.size() - 1);
        int lastCol = rightColumns.get(rightColumns.size() - 1);
        int locationLower = DictLibMatrixMult.location(lastRow, firstCol);
        int locationHigher = DictLibMatrixMult.location(firstRow, lastCol);
        if (locationLower > 0) {
            return 1;
        }
        if (locationHigher < 0) {
            return -1;
        }
        return 0;
    }

    private static int location(int row, int col) {
        if (row == col) {
            return 0;
        }
        if (row < col) {
            return 1;
        }
        return -1;
    }
}

