/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup.mapping;

import java.io.DataInput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.runtime.compress.colgroup.mapping.AMapToData;
import org.apache.sysds.runtime.compress.colgroup.mapping.MapToBit;
import org.apache.sysds.runtime.compress.colgroup.mapping.MapToByte;
import org.apache.sysds.runtime.compress.colgroup.mapping.MapToChar;
import org.apache.sysds.runtime.compress.colgroup.mapping.MapToCharPByte;
import org.apache.sysds.runtime.compress.colgroup.mapping.MapToInt;
import org.apache.sysds.runtime.compress.colgroup.mapping.MapToUByte;
import org.apache.sysds.runtime.compress.colgroup.mapping.MapToZero;
import org.apache.sysds.runtime.compress.utils.IntArrayList;
import org.apache.sysds.runtime.util.CommonThreadPool;

public interface MapToFactory {
    public static final Log LOG = LogFactory.getLog((String)MapToFactory.class.getName());

    public static AMapToData create(int[] values, int nUnique) {
        AMapToData _data = MapToFactory.create(values.length, nUnique);
        _data.copyInt(values);
        return _data;
    }

    public static AMapToData create(int size, int[] values, int nUnique) {
        AMapToData _data = MapToFactory.create(size, nUnique);
        _data.copyInt(values);
        return _data;
    }

    public static AMapToData create(int unique, IntArrayList values) {
        AMapToData _data = MapToFactory.create(values.size(), unique);
        _data.copyInt(values.extractValues());
        return _data;
    }

    public static AMapToData create(int size, int[] values, int nUnique, int k) throws Exception {
        AMapToData _data = MapToFactory.create(size, nUnique);
        ExecutorService pool = CommonThreadPool.get(k);
        int blk = Math.max(values.length / k, 1024);
        blk -= blk % 64;
        ArrayList tasks = new ArrayList();
        for (int i = 0; i < values.length; i += blk) {
            int n = i;
            int end = Math.min(i + blk, values.length);
            tasks.add(pool.submit(() -> _data.copyInt(values, start, end)));
        }
        for (Future future : tasks) {
            future.get();
        }
        return _data;
    }

    public static AMapToData create(int size, int unique) {
        if (unique <= 1) {
            return new MapToZero(size);
        }
        if (unique == 2 && size > 32) {
            return new MapToBit(unique, size);
        }
        if (unique <= 128) {
            return new MapToUByte(unique, size);
        }
        if (unique <= 256) {
            return new MapToByte(unique, size);
        }
        if (unique <= 65536) {
            return new MapToChar(unique, size);
        }
        if (unique <= 0x800000) {
            return new MapToCharPByte(unique, size);
        }
        return new MapToInt(unique, size);
    }

    public static AMapToData create(int size, MAP_TYPE t) {
        switch (t) {
            case ZERO: {
                return new MapToZero(size);
            }
            case BIT: {
                return new MapToBit(size);
            }
            case UBYTE: {
                return new MapToUByte(size);
            }
            case BYTE: {
                return new MapToByte(size);
            }
            case CHAR: {
                return new MapToChar(size);
            }
            case CHAR_BYTE: {
                return new MapToCharPByte(size);
            }
        }
        return new MapToInt(size);
    }

    public static AMapToData create(int[] values, MAP_TYPE t) {
        AMapToData map = MapToFactory.create(values.length, t);
        map.copyInt(values);
        return map;
    }

    public static AMapToData resizeForce(AMapToData d, MAP_TYPE t) {
        AMapToData ret;
        int size = d.size();
        int numTuples = d.getUnique();
        switch (t) {
            case ZERO: {
                return new MapToZero(size);
            }
            case BIT: {
                ret = new MapToBit(numTuples, size);
                break;
            }
            case UBYTE: {
                ret = new MapToUByte(numTuples, size);
                break;
            }
            case BYTE: {
                ret = new MapToByte(numTuples, size);
                break;
            }
            case CHAR: {
                ret = new MapToChar(numTuples, size);
                break;
            }
            case CHAR_BYTE: {
                ret = new MapToCharPByte(numTuples, size);
                break;
            }
            default: {
                ret = new MapToInt(numTuples, size);
            }
        }
        ret.copy(d);
        return ret;
    }

    public static long estimateInMemorySize(int size, int unique) {
        if (unique <= 1) {
            return MapToZero.getInMemorySize(size);
        }
        if (unique == 2 && size > 32) {
            return MapToBit.getInMemorySize(size);
        }
        if (unique <= 256) {
            return MapToByte.getInMemorySize(size);
        }
        if (unique <= 65536) {
            return MapToChar.getInMemorySize(size);
        }
        if (unique <= 0x7FFFFF) {
            return MapToCharPByte.getInMemorySize(size);
        }
        return MapToInt.getInMemorySize(size);
    }

    public static AMapToData readIn(DataInput in) throws IOException {
        MAP_TYPE t = MAP_TYPE.values()[in.readByte()];
        switch (t) {
            case ZERO: {
                return MapToZero.readFields(in);
            }
            case BIT: {
                return MapToBit.readFields(in);
            }
            case UBYTE: {
                return MapToUByte.readFields(in);
            }
            case BYTE: {
                return MapToByte.readFields(in);
            }
            case CHAR: {
                return MapToChar.readFields(in);
            }
            case CHAR_BYTE: {
                return MapToCharPByte.readFields(in);
            }
        }
        return MapToInt.readFields(in);
    }

    public static int getMaxPossible(MAP_TYPE t) {
        switch (t) {
            case ZERO: {
                return 0;
            }
            case BIT: {
                return 1;
            }
            case UBYTE: {
                return 127;
            }
            case BYTE: {
                return 255;
            }
            case CHAR: {
                return 65535;
            }
            case CHAR_BYTE: {
                return 0x7FFFFF;
            }
        }
        return Integer.MAX_VALUE;
    }

    public static enum MAP_TYPE {
        ZERO,
        BIT,
        UBYTE,
        BYTE,
        CHAR,
        CHAR_BYTE,
        INT;

    }
}

