/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.metadata.resolver.index.impl;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import org.opensaml.saml.metadata.resolver.index.MetadataIndexKey;

public class MetadataIndexStore<T> {
    @Nonnull
    private final Map<MetadataIndexKey, Set<T>> index = new ConcurrentHashMap<MetadataIndexKey, Set<T>>();

    @Nonnull
    @Unmodifiable
    @NotLive
    public Set<MetadataIndexKey> getKeys() {
        return CollectionSupport.copyToSet(this.index.keySet());
    }

    @Nonnull
    @Unmodifiable
    @NotLive
    public Set<T> lookup(@Nonnull MetadataIndexKey key) {
        Constraint.isNotNull((Object)key, (String)"IndexKey was null");
        Set<T> items = this.index.get(key);
        if (items == null) {
            return CollectionSupport.emptySet();
        }
        return CollectionSupport.copyToSet(items);
    }

    public void add(@Nonnull MetadataIndexKey key, @Nonnull T item) {
        Constraint.isNotNull((Object)key, (String)"IndexKey was null");
        Constraint.isNotNull(item, (String)"The indexed data element was null");
        Set<T> items = this.index.get(key);
        if (items == null) {
            items = new HashSet<T>();
            this.index.put(key, items);
        }
        items.add(item);
    }

    public void remove(@Nonnull MetadataIndexKey key, @Nonnull T item) {
        Constraint.isNotNull((Object)key, (String)"IndexKey was null");
        Constraint.isNotNull(item, (String)"The indexed data element was null");
        Set<T> items = this.index.get(key);
        if (items == null) {
            return;
        }
        items.remove(item);
    }

    public void clear(@Nonnull MetadataIndexKey key) {
        Constraint.isNotNull((Object)key, (String)"IndexKey was null");
        this.index.remove(key);
    }

    public void clear() {
        this.index.clear();
    }
}

