/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.resource.jdbc;

import java.io.Flushable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.sql.CommonDataSource;
import org.apache.openejb.resource.jdbc.DataSourceFactory;
import org.apache.openejb.resource.jdbc.DelegatableHandler;
import org.apache.openejb.resource.jdbc.ResettableDataSourceHandler;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.xbean.recipe.ObjectRecipe;
import org.apache.xbean.recipe.Option;

public class FlushableDataSourceHandler
implements DelegatableHandler {
    private static final Logger LOGGER = Logger.getInstance(LogCategory.OPENEJB, FlushableDataSourceHandler.class);
    public static final String[] FACTORY_ARGS = new String[]{"ServiceId", "JtaManaged", "JdbcDriver", "Definition", "MaxWaitTime", "TimeBetweenEvictionRuns", "MinEvictableIdleTime", "OpenEJBResourceClasspath"};
    private final FlushConfig config;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private AtomicReference<CommonDataSource> delegate = new AtomicReference();
    private final ResettableDataSourceHandler resettableHandler;

    public FlushableDataSourceHandler(CommonDataSource original, FlushConfig config, ResettableDataSourceHandler resettableHandler) {
        this.config = config;
        this.delegate.set(original);
        this.resettableHandler = resettableHandler;
    }

    private void createANewDelegate() {
        CommonDataSource old = this.delegate.get();
        try {
            ObjectRecipe recipe = new ObjectRecipe(DataSourceFactory.class.getName(), "create", FACTORY_ARGS);
            recipe.allow(Option.CASE_INSENSITIVE_PROPERTIES);
            recipe.allow(Option.IGNORE_MISSING_PROPERTIES);
            recipe.allow(Option.NAMED_PARAMETERS);
            recipe.allow(Option.PRIVATE_PROPERTIES);
            recipe.setAllProperties(this.config.properties);
            recipe.setProperty("resettableHandler", (Object)this.resettableHandler);
            recipe.setProperty("flushableHandler", (Object)this);
            this.updateDataSource((CommonDataSource)CommonDataSource.class.cast(recipe.create()));
        }
        catch (Exception e) {
            LOGGER.error("Can't recreate the datasource, keeping old one", e);
            return;
        }
        if (DataSourceFactory.knows(old)) {
            try {
                DataSourceFactory.destroy(old);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        CommonDataSource actualDelegate = this.delegate.get();
        if (Object.class == method.getDeclaringClass()) {
            if ("hashCode".equals(method.getName())) {
                return this.hashCode();
            }
            if ("toString".equals(method.getName())) {
                return "Flushable[" + actualDelegate.toString() + "]";
            }
        }
        if (Flushable.class == method.getDeclaringClass()) {
            Lock l = this.lock.writeLock();
            l.lock();
            try {
                this.createANewDelegate();
                if (Flushable.class.isInstance(actualDelegate) && (!Proxy.isProxyClass(actualDelegate.getClass()) || !FlushableDataSourceHandler.class.isInstance(Proxy.getInvocationHandler(actualDelegate)) && !ResettableDataSourceHandler.class.isInstance(Proxy.getInvocationHandler(actualDelegate)))) {
                    ((Flushable)Flushable.class.cast(actualDelegate)).flush();
                }
            }
            finally {
                l.unlock();
            }
            return null;
        }
        Lock l = this.lock.readLock();
        l.lock();
        try {
            Object object = method.invoke((Object)this.getDelegate(), args);
            return object;
        }
        catch (InvocationTargetException ite) {
            throw ite.getCause();
        }
        finally {
            l.unlock();
        }
    }

    @Override
    public CommonDataSource getDelegate() {
        return this.delegate.get();
    }

    public void updateDataSource(CommonDataSource ds) {
        InvocationHandler handler;
        CommonDataSource current = ds;
        while (Proxy.isProxyClass(current.getClass()) && (FlushableDataSourceHandler.class.isInstance(handler = Proxy.getInvocationHandler(current)) || ResettableDataSourceHandler.class.isInstance(handler))) {
            current = ((DelegatableHandler)DelegatableHandler.class.cast(handler)).getDelegate();
        }
        this.delegate.set(current);
    }

    public static class FlushConfig {
        public final Map<String, Object> properties;

        public FlushConfig(Map<String, Object> properties) {
            this.properties = properties;
        }
    }
}

