/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Session;
import org.hsqldb.SessionInterface;
import org.hsqldb.error.Error;
import org.hsqldb.lib.HsqlByteArrayOutputStream;
import org.hsqldb.lib.StringUtil;
import org.hsqldb.types.BinaryData;
import org.hsqldb.types.BlobData;
import org.hsqldb.types.CharacterType;
import org.hsqldb.types.ClobData;
import org.hsqldb.types.LobData;
import org.hsqldb.types.Type;

class Like
implements Cloneable {
    private static final BinaryData maxByteValue = new BinaryData(new byte[]{-128}, false);
    private char[] cLike;
    private int[] wildCardType;
    private int iLen;
    private boolean isIgnoreCase;
    private int iFirstWildCard;
    private boolean isNull;
    int escapeChar;
    String prefix = "";
    static final int NORMAL_CHAR = 0;
    static final int UNDERSCORE_CHAR = 1;
    static final int PERCENT_CHAR = 2;
    boolean isVariable = true;
    boolean isBinary = false;
    Type dataType;

    Like() {
    }

    void setIgnoreCase(boolean bl) {
        this.isIgnoreCase = bl;
    }

    private Object getStartsWith() {
        int n;
        if (this.iLen == 0) {
            return this.isBinary ? BinaryData.zeroLengthBinary : "";
        }
        StringBuilder stringBuilder = null;
        HsqlByteArrayOutputStream hsqlByteArrayOutputStream = null;
        if (this.isBinary) {
            hsqlByteArrayOutputStream = new HsqlByteArrayOutputStream();
        } else {
            stringBuilder = new StringBuilder();
        }
        for (n = 0; n < this.iLen && this.wildCardType[n] == 0; ++n) {
            if (this.isBinary) {
                hsqlByteArrayOutputStream.writeByte(this.cLike[n]);
                continue;
            }
            stringBuilder.append(this.cLike[n]);
        }
        if (n == 0) {
            return null;
        }
        return this.isBinary ? new BinaryData(hsqlByteArrayOutputStream.toByteArray(), false) : stringBuilder.toString();
    }

    Boolean compare(Session session, Object object) {
        if (object == null) {
            return null;
        }
        if (this.isNull) {
            return null;
        }
        if (this.isIgnoreCase) {
            object = ((CharacterType)this.dataType).upper(session, object);
        }
        long l = this.getLength(session, object);
        boolean bl = object instanceof String;
        if (bl && this.prefix.length() > 0) {
            if (l < (long)this.prefix.length()) {
                return false;
            }
            int n = this.dataType.compare(session, this.prefix, object = ((String)object).substring(0, this.prefix.length()));
            return n == 0;
        }
        return this.compareAt(session, object, 0, 0L, this.iLen, l, this.cLike, this.wildCardType);
    }

    char getChar(Session session, Object object, long l) {
        char c = this.isBinary ? (char)((BlobData)object).getBytes()[(int)l] : (object instanceof String ? ((String)object).charAt((int)l) : (object instanceof ClobData ? ((ClobData)object).getChars(session, l, 1)[0] : ((char[])object)[(int)l]));
        return c;
    }

    int getLength(SessionInterface sessionInterface, Object object) {
        int n = object instanceof LobData ? (int)((LobData)object).length(sessionInterface) : ((String)object).length();
        return n;
    }

    private boolean compareAt(Session session, Object object, int n, long l, int n2, long l2, char[] cArray, int[] nArray) {
        while (n < n2) {
            switch (nArray[n]) {
                case 0: {
                    if (l < l2 && cArray[n] == this.getChar(session, object, l++)) break;
                    return false;
                }
                case 1: {
                    if (l++ < l2) break;
                    return false;
                }
                case 2: {
                    if (++n >= n2) {
                        return true;
                    }
                    while (l < l2) {
                        if (cArray[n] == this.getChar(session, object, l) && this.compareAt(session, object, n, l, n2, l2, cArray, nArray)) {
                            return true;
                        }
                        ++l;
                    }
                    return false;
                }
            }
            ++n;
        }
        return l == l2;
    }

    /*
     * Enabled aggressive block sorting
     */
    void setPattern(Session session, Object object, Object object2, boolean bl) {
        char c;
        int n;
        int n2;
        boolean bl2 = this.isNull = object == null;
        if (!bl) {
            this.escapeChar = -1;
        } else {
            if (object2 == null) {
                this.isNull = true;
                return;
            }
            n2 = this.getLength(session, object2);
            if (n2 != 1) {
                if (!this.isBinary) throw Error.error(3439);
                throw Error.error(3412);
            }
            this.escapeChar = this.getChar(session, object2, 0L);
        }
        if (this.isNull) {
            return;
        }
        if (this.isIgnoreCase) {
            object = ((CharacterType)this.dataType).upper(null, object);
        }
        this.iLen = 0;
        this.iFirstWildCard = -1;
        n2 = this.getLength(session, object);
        this.cLike = new char[n2];
        this.wildCardType = new int[n2];
        boolean bl3 = false;
        boolean bl4 = false;
        for (n = 0; n < n2; ++n) {
            block25: {
                block23: {
                    block24: {
                        c = this.getChar(session, object, n);
                        if (bl3) break block23;
                        if (this.escapeChar == c) {
                            bl3 = true;
                            continue;
                        }
                        if (c != '_') break block24;
                        this.wildCardType[this.iLen] = 1;
                        if (this.iFirstWildCard == -1) {
                            this.iFirstWildCard = this.iLen;
                        }
                        break block25;
                    }
                    if (c == '%') {
                        if (bl4) continue;
                        bl4 = true;
                        this.wildCardType[this.iLen] = 2;
                        if (this.iFirstWildCard == -1) {
                            this.iFirstWildCard = this.iLen;
                        }
                        break block25;
                    } else {
                        bl4 = false;
                    }
                    break block25;
                }
                if (c != this.escapeChar && c != '_' && c != '%') {
                    throw Error.error(3458);
                }
                bl4 = false;
                bl3 = false;
            }
            this.cLike[this.iLen++] = c;
        }
        if (bl3) {
            throw Error.error(3458);
        }
        for (n = 0; n < this.iLen - 1; ++n) {
            if (this.wildCardType[n] != 2 || this.wildCardType[n + 1] != 1) continue;
            this.wildCardType[n] = 1;
            this.wildCardType[n + 1] = 2;
        }
        if (this.isBinary) {
            return;
        }
        this.prefix = "";
        n = 0;
        c = '\u0000';
        for (int i = 0; i < this.iLen; ++i) {
            switch (this.wildCardType[i]) {
                case 0: {
                    if (c == '\u0000') break;
                    return;
                }
                case 1: {
                    return;
                }
                case 2: {
                    if (c != '\u0000') {
                        return;
                    }
                    n = i;
                    c = '\u0001';
                }
            }
        }
        if (c == '\u0000') return;
        this.prefix = String.valueOf(this.cLike, 0, n);
    }

    boolean isEquivalentToUnknownPredicate() {
        return !this.isVariable && this.isNull;
    }

    boolean isEquivalentToEqualsPredicate() {
        return !this.isVariable && this.iFirstWildCard == -1;
    }

    boolean isEquivalentToNotNullPredicate() {
        if (this.isVariable || this.isNull || this.iFirstWildCard == -1) {
            return false;
        }
        for (int i = 0; i < this.wildCardType.length; ++i) {
            if (this.wildCardType[i] == 2) continue;
            return false;
        }
        return true;
    }

    int getFirstWildCardIndex() {
        return this.iFirstWildCard;
    }

    Object getRangeLow() {
        return this.getStartsWith();
    }

    public String describe(Session session) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(super.toString()).append("[\n").append("escapeChar=").append(this.escapeChar).append('\n').append("isNull=").append(this.isNull).append('\n').append("isIgnoreCase=").append(this.isIgnoreCase).append('\n').append("iLen=").append(this.iLen).append('\n').append("iFirstWildCard=").append(this.iFirstWildCard).append('\n').append("cLike=");
        if (this.cLike != null) {
            stringBuilder.append(StringUtil.arrayToString(this.cLike));
        }
        stringBuilder.append('\n').append("wildCardType=");
        if (this.wildCardType != null) {
            stringBuilder.append(StringUtil.arrayToString(this.wildCardType));
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public Like duplicate() {
        try {
            return (Like)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw Error.runtimeError(201, "Expression");
        }
    }
}

