/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.common.shuffle;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.tez.runtime.library.common.InputAttemptIdentifier;
import org.apache.tez.runtime.library.common.shuffle.FetchedInput;
import org.apache.tez.runtime.library.common.shuffle.FetchedInputCallback;
import org.apache.uniffle.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteFetchedInput
extends FetchedInput {
    private static final Logger LOG = LoggerFactory.getLogger(RemoteFetchedInput.class);
    private static final String OUTPUT_FILE_PATTERN = "%s/%s_src_%d_spill_%d.out";
    private final FileSystem remoteFS;
    private final Path tmpOutputPath;
    private final Path outputPath;
    private final long size;

    public RemoteFetchedInput(long compressedSize, InputAttemptIdentifier inputAttemptIdentifier, FetchedInputCallback callbackHandler, FileSystem remoteFS, String remoteSpillBasePath, String uniqueId, String appAttemptId) {
        super(inputAttemptIdentifier, callbackHandler);
        this.size = compressedSize;
        this.remoteFS = remoteFS;
        String outputFile = String.format(OUTPUT_FILE_PATTERN, appAttemptId, uniqueId, this.getInputAttemptIdentifier().getInputIdentifier(), this.getInputAttemptIdentifier().getSpillEventId());
        this.outputPath = new Path(remoteSpillBasePath, outputFile);
        this.tmpOutputPath = this.outputPath.suffix(String.valueOf(this.getId()));
    }

    public FetchedInput.Type getType() {
        return FetchedInput.Type.DISK;
    }

    public long getSize() {
        return this.size;
    }

    public OutputStream getOutputStream() throws IOException {
        return this.remoteFS.create(this.tmpOutputPath);
    }

    public InputStream getInputStream() throws IOException {
        return this.remoteFS.open(this.outputPath);
    }

    public final Path getInputPath() {
        if (this.isState(FetchedInput.State.COMMITTED)) {
            return this.outputPath;
        }
        return this.tmpOutputPath;
    }

    public void commit() throws IOException {
        if (this.isState(FetchedInput.State.PENDING)) {
            this.setState(FetchedInput.State.COMMITTED);
            this.remoteFS.rename(this.tmpOutputPath, this.outputPath);
            this.notifyFetchComplete();
        }
    }

    public void abort() throws IOException {
        if (this.isState(FetchedInput.State.PENDING)) {
            this.setState(FetchedInput.State.ABORTED);
            this.remoteFS.delete(this.tmpOutputPath, false);
            this.notifyFetchFailure();
        }
    }

    public void free() {
        Preconditions.checkState(this.isState(FetchedInput.State.COMMITTED) || this.isState(FetchedInput.State.ABORTED), "FetchedInput can only be freed after it is committed or aborted");
        if (this.isState(FetchedInput.State.COMMITTED)) {
            this.setState(FetchedInput.State.FREED);
            try {
                this.remoteFS.delete(this.outputPath, false);
            }
            catch (IOException e) {
                LOG.warn("Failed to remvoe file : " + this.outputPath.toString());
            }
            this.notifyFreedResource();
        }
    }

    public String toString() {
        return "RemoteFetchedInput [outputPath=" + this.outputPath + ", inputAttemptIdentifier=" + this.getInputAttemptIdentifier() + ", actualSize=" + this.getSize() + ", type=" + this.getType() + ", id=" + this.getId() + ", state=" + this.getState() + "]";
    }
}

