/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.common;

import java.util.Objects;
import org.apache.uniffle.common.exception.RssException;

public class BufferSegment {
    private long blockId;
    private long offset;
    private int length;
    private int uncompressLength;
    private long crc;
    private long taskAttemptId;

    public BufferSegment(long blockId, long offset, int length, int uncompressLength, long crc, long taskAttemptId) {
        this.blockId = blockId;
        this.offset = offset;
        this.length = length;
        this.uncompressLength = uncompressLength;
        this.crc = crc;
        this.taskAttemptId = taskAttemptId;
    }

    public boolean equals(Object obj) {
        if (obj instanceof BufferSegment) {
            return this.blockId == ((BufferSegment)obj).getBlockId() && this.offset == (long)((BufferSegment)obj).getOffset() && this.length == ((BufferSegment)obj).getLength() && this.uncompressLength == ((BufferSegment)obj).getUncompressLength() && this.crc == ((BufferSegment)obj).getCrc() && this.taskAttemptId == ((BufferSegment)obj).getTaskAttemptId();
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.blockId, this.offset, this.length, this.uncompressLength, this.crc, this.taskAttemptId);
    }

    public String toString() {
        return "BufferSegment{blockId[" + this.blockId + "], taskAttemptId[" + this.taskAttemptId + "], offset[" + this.offset + "], length[" + this.length + "], crc[" + this.crc + "], uncompressLength[" + this.uncompressLength + "]}";
    }

    public int getOffset() {
        if (this.offset > Integer.MAX_VALUE) {
            throw new RssException("Unsupported offset[" + this.offset + "] for BufferSegment");
        }
        return (int)this.offset;
    }

    public int getLength() {
        return this.length;
    }

    public long getBlockId() {
        return this.blockId;
    }

    public long getCrc() {
        return this.crc;
    }

    public int getUncompressLength() {
        return this.uncompressLength;
    }

    public long getTaskAttemptId() {
        return this.taskAttemptId;
    }
}

