/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.core.request.handler.logger;

import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.core.request.handler.IPageAndComponentProvider;
import org.apache.wicket.core.request.handler.logger.PageLogData;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IFormSubmitter;
import org.apache.wicket.request.component.IRequestableComponent;

public class ListenerLogData
extends PageLogData {
    private static final long serialVersionUID = 1L;
    private final Class<? extends IRequestableComponent> componentClass;
    private final String componentPath;
    private final Integer behaviorIndex;
    private final Class<? extends Behavior> behaviorClass;
    private final Class<? extends IRequestableComponent> submittingComponentClass;
    private final String submittingComponentPath;

    public ListenerLogData(IPageAndComponentProvider pageAndComponentProvider, Integer behaviorIndex) {
        super(pageAndComponentProvider);
        this.behaviorIndex = behaviorIndex;
        this.componentClass = this.optional(() -> pageAndComponentProvider.getComponent().getClass());
        this.componentPath = this.optional(() -> pageAndComponentProvider.getComponentPath());
        this.behaviorClass = behaviorIndex != null ? this.optional(() -> pageAndComponentProvider.getComponent().getBehaviorById(behaviorIndex).getClass()) : null;
        Component formSubmitter = this.optional(() -> {
            IRequestableComponent component = pageAndComponentProvider.getComponent();
            if (component instanceof Form) {
                IFormSubmitter submitter = ((Form)component).findSubmittingButton();
                return submitter instanceof Component ? (Component)((Object)submitter) : null;
            }
            return null;
        });
        if (formSubmitter != null) {
            this.submittingComponentClass = formSubmitter.getClass();
            this.submittingComponentPath = formSubmitter.getPageRelativePath();
        } else {
            this.submittingComponentClass = null;
            this.submittingComponentPath = null;
        }
    }

    public final Class<? extends IRequestableComponent> getComponentClass() {
        return this.componentClass;
    }

    public final String getComponentPath() {
        return this.componentPath;
    }

    public final Integer getBehaviorIndex() {
        return this.behaviorIndex;
    }

    public final Class<? extends Behavior> getBehaviorClass() {
        return this.behaviorClass;
    }

    public Class<? extends IRequestableComponent> getSubmittingComponentClass() {
        return this.submittingComponentClass;
    }

    public String getSubmittingComponentPath() {
        return this.submittingComponentPath;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.setCharAt(sb.length() - 1, ',');
        if (this.getComponentClass() != null) {
            sb.append("componentClass=");
            sb.append(this.getComponentClass().getName());
            sb.append(',');
        }
        if (this.getComponentPath() != null) {
            sb.append("componentPath=");
            sb.append(this.getComponentPath());
            sb.append(',');
        }
        sb.append("behaviorIndex=");
        sb.append(this.getBehaviorIndex());
        if (this.getBehaviorClass() != null) {
            sb.append(",behaviorClass=");
            sb.append(this.getBehaviorClass().getName());
        }
        if (this.getSubmittingComponentClass() != null) {
            sb.append(",submittingComponentClass=");
            sb.append(this.getSubmittingComponentClass().getName());
        }
        if (this.getSubmittingComponentPath() != null) {
            sb.append(",submittingComponentPath=");
            sb.append(this.getSubmittingComponentPath());
        }
        sb.append("}");
        return sb.toString();
    }
}

