/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.core.request.handler.logger;

import java.util.function.Supplier;
import org.apache.wicket.Page;
import org.apache.wicket.core.request.handler.IPageProvider;
import org.apache.wicket.request.ILogData;
import org.apache.wicket.request.component.IRequestablePage;
import org.apache.wicket.request.mapper.parameter.PageParameters;

public class PageLogData
implements ILogData {
    private static final long serialVersionUID = 1L;
    private final Class<? extends IRequestablePage> pageClass;
    private final Integer pageId;
    private final PageParameters pageParameters;
    private final Integer renderCount;

    public PageLogData(IPageProvider pageProvider) {
        this.pageId = this.optional(pageProvider::getPageId);
        this.renderCount = this.optional(pageProvider::getRenderCount);
        this.pageClass = this.optional(pageProvider::getPageClass);
        this.pageParameters = this.optional(pageProvider::getPageParameters);
    }

    protected <T> T optional(Supplier<T> function) {
        try {
            return function.get();
        }
        catch (Exception ex) {
            return null;
        }
    }

    public PageLogData(Page page) {
        this.pageClass = page.getPageClass();
        this.pageId = page.getPageId();
        this.pageParameters = page.getPageParameters();
        this.renderCount = page.getRenderCount();
    }

    public final Class<? extends IRequestablePage> getPageClass() {
        return this.pageClass;
    }

    public final Integer getPageId() {
        return this.pageId;
    }

    public final PageParameters getPageParameters() {
        return this.pageParameters;
    }

    public final Integer getRenderCount() {
        return this.renderCount;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.pageClass != null) {
            sb.append("pageClass=");
            sb.append(this.getPageClass().getName());
            sb.append(',');
        }
        sb.append("pageId=");
        sb.append(this.getPageId());
        sb.append(",pageParameters={");
        sb.append(this.getPageParameters());
        sb.append("},renderCount=");
        sb.append(this.getRenderCount());
        sb.append("}");
        return sb.toString();
    }
}

