/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.core.util.resource;

import java.net.URL;
import org.apache.wicket.core.util.resource.UrlResourceStream;
import org.apache.wicket.util.file.IResourceFinder;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.resource.IResourceStream;
import org.apache.wicket.util.string.Strings;

public class ClassPathResourceFinder
implements IResourceFinder {
    private final String prefix;

    public ClassPathResourceFinder(String prefix) {
        this.prefix = Strings.isEmpty(prefix) ? "" : (prefix.endsWith("/") ? prefix : prefix + "/");
    }

    @Override
    public IResourceStream find(Class<?> clazz, String path) {
        IResourceStream resourceStream;
        Args.notEmpty(path, "path");
        String fullPath = this.prefix + (path.startsWith("/") ? path.substring(1) : path);
        if (clazz != null && (resourceStream = this.getResourceStreamWithClassLoader(clazz.getClassLoader(), fullPath)) != null) {
            return resourceStream;
        }
        resourceStream = this.getResourceStreamWithClassLoader(Thread.currentThread().getContextClassLoader(), fullPath);
        if (resourceStream != null) {
            return resourceStream;
        }
        resourceStream = this.getResourceStreamWithClassLoader(this.getClass().getClassLoader(), fullPath);
        if (resourceStream != null) {
            return resourceStream;
        }
        return null;
    }

    private IResourceStream getResourceStreamWithClassLoader(ClassLoader classLoader, String path) {
        URL url;
        if (classLoader != null && (url = classLoader.getResource(path)) != null) {
            return new UrlResourceStream(url);
        }
        return null;
    }

    public String toString() {
        if (Strings.isEmpty(this.prefix)) {
            return "[classpath]";
        }
        return "[classpath: " + this.prefix + "]";
    }
}

