/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public class TransformThread
implements Runnable {
    public static final int STREAM = 0;
    public static final int SAX = 1;
    public static final int DOM = 2;
    public static final String[] flavorNames = new String[]{"Stream", "SAX", "DOM"};
    private static int SOURCE_FLAVOR = 0;
    private static int RESULT_FLAVOR = 0;
    private static boolean USE_XSLTC = false;
    private static final int NUM_THREADS = 2;
    private static TransformThread[] INSTANCES = null;
    protected Thread m_thread = null;
    private static final int NUM_TRANSFORMATIONS = 2;
    private static final String XML_IN_BASE = "foo";
    private static final String XML_EXT = ".xml";
    private static final String XSL_IN_BASE = "foo";
    private static final String XSL_EXT = ".xsl";
    private static final String FILE_OUT_BASE = "foo_";
    private static final String FILE_OUT_EXT = ".out";
    private int m_thrdNum = -1;
    private InputStream[] m_inStream = null;
    private Source[] m_inSource = null;
    private Result[] m_outResult = null;
    private Transformer m_transformer = null;

    public TransformThread(int thrdNum) {
        this.m_thrdNum = thrdNum;
        this.m_inStream = new InputStream[2];
        this.m_inSource = new Source[2];
        this.m_outResult = new Result[2];
        try {
            this.initSource();
            this.initResult();
            String xslSourceFileName = "foo" + this.m_thrdNum + XSL_EXT;
            String xslSourceURI = new File(xslSourceFileName).toURL().toString();
            StreamSource xslSource = new StreamSource(xslSourceFileName);
            xslSource.setSystemId(xslSourceURI);
            this.m_transformer = TransformerFactory.newInstance().newTransformer(xslSource);
            this.m_thread = new Thread(this);
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private void initResult() {
        try {
            block7: for (int i = 0; i < 2; ++i) {
                switch (RESULT_FLAVOR) {
                    case 0: {
                        FileOutputStream outStream = new FileOutputStream("foo_thread_" + this.m_thrdNum + "_transformation_" + i + FILE_OUT_EXT);
                        this.m_outResult[i] = new StreamResult(outStream);
                        continue block7;
                    }
                    case 1: {
                        DefaultHandler defaultHandler = new DefaultHandler();
                        this.m_outResult[i] = new SAXResult(defaultHandler);
                        continue block7;
                    }
                    case 2: {
                        this.m_outResult[i] = new DOMResult();
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private void initSource() {
        try {
            for (int i = 0; i < 2; ++i) {
                String sourceXMLURI = new File("foo" + i + XML_EXT).toURL().toString();
                this.m_inStream[i] = new FileInputStream("foo" + i + XML_EXT);
                switch (SOURCE_FLAVOR) {
                    case 0: {
                        this.m_inSource[i] = new StreamSource(this.m_inStream[i]);
                        break;
                    }
                    case 1: {
                        this.m_inSource[i] = new SAXSource(new InputSource(this.m_inStream[i]));
                        break;
                    }
                    case 2: {
                        try {
                            DocumentBuilderFactory dfactory = DocumentBuilderFactory.newInstance();
                            dfactory.setNamespaceAware(true);
                            this.m_inSource[i] = new DOMSource(dfactory.newDocumentBuilder().parse(this.m_inStream[i]));
                            break;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
                if (this.m_inSource[i] == null) continue;
                this.m_inSource[i].setSystemId(sourceXMLURI);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    @Override
    public void run() {
        try {
            for (int i = 0; i < 2; ++i) {
                this.m_transformer.transform(this.m_inSource[i], this.m_outResult[i]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private static void initThreads() {
        INSTANCES = new TransformThread[2];
        for (int count = 0; count < 2; ++count) {
            TransformThread.INSTANCES[count] = new TransformThread(count);
        }
    }

    private static void initSystemProperties() {
        if (USE_XSLTC) {
            String key = "javax.xml.transform.TransformerFactory";
            String value = "org.apache.xalan.xsltc.trax.TransformerFactoryImpl";
            Properties props = System.getProperties();
            props.put(key, value);
            System.setProperties(props);
        }
    }

    public static void main(String[] argv) {
        try {
            TransformThread.initSystemProperties();
            TransformThread.initThreads();
            for (int count = 0; count < 2; ++count) {
                TransformThread.INSTANCES[count].m_thread.start();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.exit(1);
        }
    }
}

